/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ConditionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;

public class FilterAdapter
extends FilterDefinition {
    protected IModelAdapter adapter;

    public FilterAdapter(IModelAdapter adapter, FilterConditionHandle modelFilter) throws AdapterException {
        super(null);
        this.adatperBuildInFilter(adapter, modelFilter);
    }

    private void adatperBuildInFilter(IModelAdapter adapter, FilterConditionHandle modelFilter) throws AdapterException {
        this.adapter = adapter;
        String filterTarget = modelFilter.getFilterTarget();
        if ("DataSet".equals(filterTarget)) {
            this.setFilterTarget(IFilterDefinition.FilterTarget.DATASET);
        } else if ("ResultSet".equals(filterTarget)) {
            this.setFilterTarget(IFilterDefinition.FilterTarget.RESULTSET);
        }
        String filterExpr = modelFilter.getExpr();
        if (filterExpr != null) {
            String filterOpr = modelFilter.getOperator();
            if (filterOpr == null || filterOpr.length() == 0) {
                this.setExpression(adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))));
            } else {
                if (!filterOpr.equals("in") && !filterOpr.equals("not-in")) {
                    String operand1 = modelFilter.getValue1();
                    this.setExpression(adapter.adaptConditionalExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr")), filterOpr, operand1 == null ? null : modelFilter.getValue1ExpressionList().getListValue().get(0), DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("value2"))));
                } else {
                    List<Expression> operands = modelFilter.getValue1ExpressionList().getListValue();
                    if (operands == null) {
                        throw new AdapterException("invalid.filter.operands");
                    }
                    ArrayList<ScriptExpression> adaptedExpressions = new ArrayList<ScriptExpression>();
                    for (Expression expr : operands) {
                        adaptedExpressions.add(adapter.adaptExpression(expr));
                    }
                    this.setExpression(new ConditionAdapter((IScriptExpression)adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))), filterOpr, adaptedExpressions));
                }
                this.setUpdateAggregation(modelFilter.updateAggregation());
            }
        }
    }

    public FilterAdapter(IModelAdapter adapter, FilterConditionHandle modelFilter, IFilterExprDefinition filterDefn) throws AdapterException {
        super(null);
        if (filterDefn == null) {
            this.adatperBuildInFilter(adapter, modelFilter);
            return;
        }
        this.adapter = adapter;
        String filterTarget = modelFilter.getFilterTarget();
        if ("DataSet".equals(filterTarget)) {
            this.setFilterTarget(IFilterDefinition.FilterTarget.DATASET);
        } else if ("ResultSet".equals(filterTarget)) {
            this.setFilterTarget(IFilterDefinition.FilterTarget.RESULTSET);
        }
        String filterExpr = modelFilter.getExpr();
        if (filterExpr != null) {
            String filterOpr = null;
            if (filterDefn != null) {
                if (filterDefn.getBirtFilterExprId() != null) {
                    filterOpr = modelFilter.getOperator();
                } else if (filterDefn.getExtFilterExprId() != null) {
                    filterOpr = filterDefn.getExtFilterExprId();
                }
            }
            if (filterOpr == null) {
                filterOpr = modelFilter.getOperator();
            }
            if (filterOpr == null || filterOpr.length() == 0) {
                this.setExpression(adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))));
            } else {
                if (filterDefn.getMaxArguments() != null && filterDefn.getMaxArguments() <= 2) {
                    String operand1 = modelFilter.getValue1();
                    this.setExpression(adapter.adaptConditionalExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr")), filterOpr, operand1 == null ? null : modelFilter.getValue1ExpressionList().getListValue().get(0), DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("value2"))));
                } else {
                    List<Expression> operands = modelFilter.getValue1ExpressionList().getListValue();
                    if (operands == null) {
                        throw new AdapterException("invalid.filter.operands");
                    }
                    ArrayList<ScriptExpression> adaptedExpressions = new ArrayList<ScriptExpression>();
                    for (Expression expr : operands) {
                        adaptedExpressions.add(adapter.adaptExpression(expr));
                    }
                    this.setExpression(new ConditionAdapter((IScriptExpression)adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))), filterOpr, adaptedExpressions));
                }
                this.setUpdateAggregation(modelFilter.updateAggregation());
            }
        }
    }

    public FilterAdapter(IModelAdapter adapter, ExpressionHandle handle) throws AdapterException {
        super(adapter.adaptExpression(DataAdapterUtil.getExpression(handle)));
        this.adapter = adapter;
    }
}

