/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.ILinkedResult;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataAdapterUtil {
    private static Map<String, String> aggrAdapterMap = new HashMap<String, String>();
    private static Map<String, Integer> filterOptMap = new HashMap<String, Integer>();

    static {
        DataAdapterUtil.registerAggregationFunction();
        DataAdapterUtil.registerFilterOperator();
    }

    private static void registerAggregationFunction() {
        aggrAdapterMap.put("sum", "SUM");
        aggrAdapterMap.put("count", "COUNT");
        aggrAdapterMap.put("min", "MIN");
        aggrAdapterMap.put("max", "MAX");
        aggrAdapterMap.put("average", "AVE");
        aggrAdapterMap.put("weighted-avg", "WEIGHTEDAVE");
        aggrAdapterMap.put("stddev", "STDDEV");
        aggrAdapterMap.put("first", "FIRST");
        aggrAdapterMap.put("last", "LAST");
        aggrAdapterMap.put("mode", "MODE");
        aggrAdapterMap.put("moving-ave", "MOVINGAVE");
        aggrAdapterMap.put("median", "MEDIAN");
        aggrAdapterMap.put("variance", "VARIANCE");
        aggrAdapterMap.put("running-sum", "RUNNINGSUM");
        aggrAdapterMap.put("irr", "IRR");
        aggrAdapterMap.put("mirr", "MIRR");
        aggrAdapterMap.put("npv", "NPV");
        aggrAdapterMap.put("running-npv", "RUNNINGNPV");
        aggrAdapterMap.put("count-distinct", "COUNTDISTINCT");
        aggrAdapterMap.put("running-count", "RUNNINGCOUNT");
        aggrAdapterMap.put("is-top-n", "ISTOPN");
        aggrAdapterMap.put("is-bottom-n", "ISBOTTOMN");
        aggrAdapterMap.put("is-top-n-percent", "ISTOPNPERCENT");
        aggrAdapterMap.put("is-bottom-n-percent", "ISBOTTOMNPERCENT");
        aggrAdapterMap.put("percent-rank", "PERCENTRANK");
        aggrAdapterMap.put("percentile", "PERCENTILE");
        aggrAdapterMap.put("quartile", "QUARTILE");
        aggrAdapterMap.put("percent-sum", "PERCENTSUM");
        aggrAdapterMap.put("rank", "RANK");
    }

    private static void registerFilterOperator() {
        filterOptMap.put("eq", new Integer(1));
        filterOptMap.put("ne", new Integer(2));
        filterOptMap.put("lt", new Integer(3));
        filterOptMap.put("le", new Integer(4));
        filterOptMap.put("ge", new Integer(5));
        filterOptMap.put("gt", new Integer(6));
        filterOptMap.put("between", new Integer(7));
        filterOptMap.put("not-between", new Integer(8));
        filterOptMap.put("is-null", new Integer(9));
        filterOptMap.put("is-not-null", new Integer(10));
        filterOptMap.put("is-true", new Integer(11));
        filterOptMap.put("is-false", new Integer(12));
        filterOptMap.put("like", new Integer(13));
        filterOptMap.put("top-n", new Integer(14));
        filterOptMap.put("bottom-n", new Integer(15));
        filterOptMap.put("top-percent", new Integer(16));
        filterOptMap.put("bottom-percent", new Integer(17));
        filterOptMap.put("match", new Integer(19));
        filterOptMap.put("not-like", new Integer(20));
        filterOptMap.put("not-match", new Integer(21));
        filterOptMap.put("in", new Integer(22));
        filterOptMap.put("not-in", 23);
    }

    public static void registerDataObject(ScriptContext context, ILinkedResult source) throws AdapterException {
        try {
            Scriptable targetScope = ((IDataScriptEngine)((Object)context.getScriptEngine("javascript"))).getJSScope(context);
            int type = source.getCurrentResultType();
            if (type == 2) {
                targetScope.put("row", targetScope, (Object)new JSResultIteratorObject(source, targetScope));
                targetScope.put("data", targetScope, (Object)new JSResultIteratorObject(source, targetScope));
            } else if (type == 1 && source.getCurrentResult() != null) {
                Scriptable scope = ((ICubeCursor)source.getCurrentResult()).getScope();
                targetScope.put("data", targetScope, scope.get("data", scope));
                if (scope.get("data", scope) != null && scope.get("data", scope) instanceof Scriptable) {
                    targetScope.put("row", targetScope, scope.get("row", scope));
                }
                targetScope.put("dimension", targetScope, scope.get("dimension", scope));
                targetScope.put("measure", targetScope, scope.get("measure", scope));
            }
        }
        catch (BirtException e) {
            throw new AdapterException(e.getErrorCode(), e);
        }
    }

    public static void unRegisterDataObject(ScriptContext context) throws AdapterException {
        try {
            if (context != null) {
                Scriptable targetScope = ((IDataScriptEngine)((Object)context.getScriptEngine("javascript"))).getJSScope(context);
                targetScope.delete("row");
                targetScope.delete("dimension");
                targetScope.delete("measure");
                targetScope.delete("data");
            }
        }
        catch (BirtException e) {
            throw new AdapterException(e.getErrorCode(), e);
        }
    }

    public static int adaptModelDataType(String modelDataType) {
        if (modelDataType == null) {
            return -1;
        }
        if (modelDataType.equals("any")) {
            return 0;
        }
        if (modelDataType.equals("integer")) {
            return 2;
        }
        if (modelDataType.equals("string")) {
            return 5;
        }
        if (modelDataType.equals("date-time")) {
            return 6;
        }
        if (modelDataType.equals("decimal")) {
            return 4;
        }
        if (modelDataType.equals("float")) {
            return 3;
        }
        if (modelDataType.equals("time")) {
            return 10;
        }
        if (modelDataType.equals("date")) {
            return 9;
        }
        if (modelDataType.equals("boolean")) {
            return 1;
        }
        if (modelDataType.equals("blob")) {
            return 7;
        }
        if (modelDataType.equals("javaObject")) {
            return 11;
        }
        return -1;
    }

    public static int[] getCompatibleDataTypes(int type) throws AdapterException {
        switch (type) {
            case 1: {
                return new int[]{1};
            }
            case 2: {
                return new int[]{2};
            }
            case 3: {
                return new int[]{3, 2};
            }
            case 4: {
                return new int[]{4, 3, 2};
            }
            case 5: {
                return new int[]{5, 1, 4, 3, 2, 6, 7, 8, 9, 10, 11};
            }
            case 6: {
                return new int[]{6, 9, 10};
            }
            case 7: {
                return new int[]{7};
            }
            case 8: {
                return new int[]{8};
            }
            case 9: {
                return new int[]{9, 6};
            }
            case 10: {
                return new int[]{10, 6};
            }
            case 11: {
                return new int[]{11, 5, 1, 4, 3, 2, 6, 7, 9, 10};
            }
        }
        throw new AdapterException("invlid.data.type", type);
    }

    public static String adapterToModelDataType(int apiDataType) {
        if (apiDataType == 2) {
            return "integer";
        }
        if (apiDataType == 5) {
            return "string";
        }
        if (apiDataType == 6) {
            return "date-time";
        }
        if (apiDataType == 4) {
            return "decimal";
        }
        if (apiDataType == 3) {
            return "float";
        }
        if (apiDataType == 9) {
            return "date";
        }
        if (apiDataType == 10) {
            return "time";
        }
        if (apiDataType == 1) {
            return "boolean";
        }
        if (apiDataType == 7) {
            return "blob";
        }
        if (apiDataType == 11) {
            return "javaObject";
        }
        return "any";
    }

    public static String toModelAggregationType(String funcName) {
        for (Map.Entry<String, String> funcEntry : aggrAdapterMap.entrySet()) {
            if (!funcEntry.getValue().equals(funcName)) continue;
            return funcEntry.getKey();
        }
        return funcName;
    }

    public static String adaptModelAggregationType(String modelAggrType) throws AdapterException {
        String o = aggrAdapterMap.get(modelAggrType);
        return o == null ? modelAggrType : o.toString();
    }

    public static int adaptModelFilterOperator(String modelOpr) {
        Integer operator = filterOptMap.get(modelOpr);
        if (operator != null) {
            return operator;
        }
        return 0;
    }

    public static String getRollUpAggregationName(String functionName) {
        if (functionName == null || functionName.trim().length() == 0) {
            return functionName;
        }
        String func = functionName;
        try {
            func = DataAdapterUtil.adaptModelAggregationType(functionName);
        }
        catch (AdapterException adapterException) {
            // empty catch block
        }
        if (func.equals("AVE") || func.equals("COUNT") || func.equals("COUNTDISTINCT")) {
            return "SUM";
        }
        return func;
    }

    public static int adaptModelSortDirection(String modelSortDir) {
        return "desc".equals(modelSortDir) ? 1 : 0;
    }

    public static int modelDataTypeToCoreDataType(String type) {
        int typeNum = 0;
        if ("string".equals(type)) {
            typeNum = 5;
        } else if ("float".equals(type)) {
            typeNum = 3;
        } else if ("decimal".equals(type)) {
            typeNum = 4;
        } else if ("dateTime".equals(type)) {
            typeNum = 6;
        } else if ("date".equals(type)) {
            typeNum = 9;
        } else if ("time".equals(type)) {
            typeNum = 10;
        } else if ("boolean".equals(type)) {
            typeNum = 1;
        } else if ("integer".equals(type)) {
            typeNum = 2;
        } else if ("javaObject".equals(type)) {
            typeNum = 11;
        }
        return typeNum;
    }

    public static String coreDataTypeToModelDataType(String dteDTName) {
        if (dteDTName == null) {
            return null;
        }
        String modelDataType = "any";
        if (dteDTName.equals(DataType.INTEGER_TYPE_NAME)) {
            modelDataType = "integer";
        } else if (dteDTName.equals(DataType.DOUBLE_TYPE_NAME)) {
            modelDataType = "float";
        } else if (dteDTName.equals(DataType.DECIMAL_TYPE_NAME)) {
            modelDataType = "decimal";
        } else if (dteDTName.equals(DataType.STRING_TYPE_NAME)) {
            modelDataType = "string";
        } else if (dteDTName.equals(DataType.DATE_TYPE_NAME)) {
            modelDataType = "dateTime";
        } else if (dteDTName.equals(DataType.BOOLEAN_TYPE_NAME)) {
            modelDataType = "boolean";
        } else if (dteDTName.equals(DataType.SQL_DATE_TYPE_NAME)) {
            modelDataType = "date";
        } else if (dteDTName.equals(DataType.SQL_TIME_TYPE_NAME)) {
            modelDataType = "time";
        } else if (dteDTName.equals(DataType.OBJECT_TYPE_NAME)) {
            modelDataType = "javaObject";
        }
        return modelDataType;
    }

    public static TimePeriodType toTimePeriodType(String type) {
        if (type.equals(TimePeriodType.YEAR.toString())) {
            return TimePeriodType.YEAR;
        }
        if (type.equals(TimePeriodType.QUARTER.toString())) {
            return TimePeriodType.QUARTER;
        }
        if (type.equals(TimePeriodType.MONTH.toString())) {
            return TimePeriodType.MONTH;
        }
        if (type.equals(TimePeriodType.WEEK.toString())) {
            return TimePeriodType.WEEK;
        }
        if (type.equals(TimePeriodType.DAY.toString())) {
            return TimePeriodType.DAY;
        }
        if (type.equals("Year to Date")) {
            return TimePeriodType.YEAR;
        }
        if (type.equals("Quarter to Date")) {
            return TimePeriodType.QUARTER;
        }
        if (type.equals("Month to Date")) {
            return TimePeriodType.MONTH;
        }
        if (type.equals("Week to Date")) {
            return TimePeriodType.WEEK;
        }
        return null;
    }

    public static String toModelTimeType(TimePeriodType type) {
        if (TimePeriodType.YEAR.equals(type)) {
            return "year";
        }
        if (TimePeriodType.QUARTER.equals(type)) {
            return "quarter";
        }
        if (TimePeriodType.MONTH.equals(type)) {
            return "month";
        }
        if (TimePeriodType.WEEK.equals(type)) {
            return "week-of-year";
        }
        if (TimePeriodType.DAY.equals(type)) {
            return "day-of-year";
        }
        return null;
    }

    public static String adaptArgumentName(String name) {
        return "Data Field".equals(name) ? "Expression" : name;
    }

    public static Object getParamValueFromConfigFile(ScalarParameterHandle paramHandle) {
        ModuleHandle designModule = paramHandle.getModuleHandle();
        String designFileName = designModule.getFileName();
        int index = designFileName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        String reportConfigName = String.valueOf(designFileName.substring(0, index + 1)) + "rptconfig";
        final File file = new File(reportConfigName);
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        }).booleanValue()) {
            String paraName = paramHandle.getName();
            ScalarParameterHandle parameterHandle = (ScalarParameterHandle)designModule.findParameter(paraName);
            paraName = String.valueOf(paraName) + "_" + parameterHandle.getID();
            SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
            ReportDesignHandle rdHandle = null;
            try {
                rdHandle = sessionHandle.openDesign(reportConfigName);
            }
            catch (DesignFileException e) {
                return null;
            }
            if (rdHandle != null) {
                ArrayList<String> values = new ArrayList<String>();
                Iterator configVars = rdHandle.configVariablesIterator();
                while (configVars != null && configVars.hasNext()) {
                    ConfigVariableHandle configVar = (ConfigVariableHandle)configVars.next();
                    if (configVar == null) continue;
                    String varName = DataAdapterUtil.prepareConfigVarName(configVar.getName());
                    String varValue = configVar.getValue();
                    if (varName == null || varValue == null) continue;
                    if (varName.equals(paraName)) {
                        String value = varValue;
                        values.add(value);
                    }
                    if (!DataAdapterUtil.isNullValue(varName, varValue, paraName)) continue;
                    if (!parameterHandle.getParamType().equals("multi-value")) {
                        return null;
                    }
                    return new Object[0];
                }
                if (values.size() > 0) {
                    if (parameterHandle.getParamType().equals("simple")) {
                        try {
                            return DataTypeUtil.convert(values.get(0), DataAdapterUtil.modelDataTypeToCoreDataType(parameterHandle.getDataType()));
                        }
                        catch (BirtException e) {
                            return null;
                        }
                    }
                    try {
                        Object[] reValues = new Object[values.size()];
                        int i = 0;
                        while (i < reValues.length) {
                            reValues[i] = DataTypeUtil.convert(values.get(i), DataAdapterUtil.modelDataTypeToCoreDataType(parameterHandle.getDataType()));
                            ++i;
                        }
                        return reValues;
                    }
                    catch (BirtException e) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private static String prepareConfigVarName(String name) {
        int index = name.lastIndexOf("_");
        return name.substring(0, index);
    }

    private static boolean isNullValue(String varName, String varValue, String newParaName) {
        return varName.toLowerCase().startsWith("__isnull") && varValue.equals(newParaName);
    }

    private static class JSResultIteratorObject
    extends ScriptableObject {
        private static final long serialVersionUID = 684728008759347940L;
        private ILinkedResult it;
        private IResultIterator currentIterator;
        private Scriptable scope;

        JSResultIteratorObject(ILinkedResult it, Scriptable scope) {
            this.it = it;
            this.scope = scope;
            if (it.getCurrentResultType() == 2) {
                this.currentIterator = (IResultIterator)it.getCurrentResult();
            }
        }

        public String getClassName() {
            return "JSResultIteratorObject";
        }

        public Object get(String arg0, Scriptable scope) {
            block5: {
                try {
                    if (this.currentIterator != null) break block5;
                    return null;
                }
                catch (BirtException e) {
                    return null;
                }
            }
            if ("__rownum".equalsIgnoreCase(arg0) || "0".equalsIgnoreCase(arg0)) {
                return this.currentIterator.getRowIndex();
            }
            if ("_outer".equalsIgnoreCase(arg0)) {
                return new JSResultIteratorObject(this.it.getParent(), this.scope);
            }
            return JavascriptEvalUtil.convertToJavascriptValue(this.currentIterator.getValue(arg0), this.scope);
        }

        public Object get(int index, Scriptable start) {
            return this.get(String.valueOf(index), start);
        }
    }
}

