/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DrilledInfo;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.DrillOnDimensionHierarchy;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefn;

public class DrillFilterHelper {
    public static AggregationDefinition[] preparedDrillForNestedAggregation(ICubeQueryDefinition cubeQueryDefinition, CubeAggrDefn[] cubeAggr, AggregationDefinition[] aggrDefns) {
        IEdgeDefinition columnEdge = cubeQueryDefinition.getEdge(2);
        IEdgeDefinition rowEdge = cubeQueryDefinition.getEdge(1);
        List<DrillOnDimensionHierarchy> columnDrill = CubeQueryDefinitionUtil.flatternDrillFilter(columnEdge);
        List<DrillOnDimensionHierarchy> rowDrill = CubeQueryDefinitionUtil.flatternDrillFilter(rowEdge);
        ArrayList<DrillOnDimensionHierarchy> combinedDrill = new ArrayList<DrillOnDimensionHierarchy>(rowDrill);
        combinedDrill.addAll(columnDrill);
        if (combinedDrill.isEmpty()) {
            return new AggregationDefinition[0];
        }
        ArrayList<DrilledInfo> aggregation = new ArrayList<DrilledInfo>();
        int i = 0;
        while (i < aggrDefns.length) {
            DimLevel[] levels;
            if (aggrDefns[i].getAggregationFunctions() != null && (levels = cubeAggr[i].getAggrLevelsInAggregationResult().toArray(new DimLevel[0])) != null) {
                ArrayList<List<DimLevel>> groupByDimension = new ArrayList<List<DimLevel>>();
                String dimensionName = null;
                ArrayList<DimLevel> list = null;
                int j = 0;
                while (j < levels.length - 1) {
                    if (dimensionName != null && dimensionName.equals(levels[j].getDimensionName())) {
                        if (DrillFilterHelper.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                    } else {
                        list = new ArrayList<DimLevel>();
                        if (DrillFilterHelper.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                        dimensionName = levels[j].getDimensionName();
                        groupByDimension.add(list);
                    }
                    ++j;
                }
                if (!groupByDimension.isEmpty()) {
                    ArrayList<DimLevel[]> tagetLevels = new ArrayList<DimLevel[]>();
                    tagetLevels.add(levels);
                    DrillFilterHelper.buildAggregationDimLevel(tagetLevels, groupByDimension, 0);
                    int k = 1;
                    while (k < tagetLevels.size()) {
                        boolean exist = false;
                        int t = 0;
                        while (t < aggregation.size()) {
                            if (((DrilledInfo)aggregation.get(t)).matchTargetlevels((DimLevel[])tagetLevels.get(k))) {
                                ((DrilledInfo)aggregation.get(t)).addOriginalAggregation(aggrDefns[i]);
                                exist = true;
                                break;
                            }
                            ++t;
                        }
                        if (!exist) {
                            DrilledInfo aggr = null;
                            if (DrillFilterHelper.isRunningAggregation(aggrDefns[i])) {
                                DimLevel[] aggrLevels = aggrDefns[i].getLevels();
                                List<DimLevel> onList = Arrays.asList((DimLevel[])tagetLevels.get(k));
                                ArrayList<DimLevel> targetList = null;
                                if (aggrLevels != null) {
                                    targetList = new ArrayList<DimLevel>();
                                    DimLevel[] dimLevelArray = aggrLevels;
                                    int n = aggrLevels.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        DimLevel dimLevel = dimLevelArray[n2];
                                        if (onList.contains(dimLevel)) {
                                            targetList.add(dimLevel);
                                        }
                                        ++n2;
                                    }
                                }
                                aggr = new DrilledInfo(targetList == null ? null : targetList.toArray(new DimLevel[0]), cubeQueryDefinition);
                            } else {
                                aggr = new DrilledInfo((DimLevel[])tagetLevels.get(k), cubeQueryDefinition);
                            }
                            aggr.addOriginalAggregation(aggrDefns[i]);
                            aggregation.add(aggr);
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        AggregationDefinition[] a = new AggregationDefinition[aggregation.size()];
        int i2 = 0;
        while (i2 < aggregation.size()) {
            a[i2] = new AggregationDefinition(((DrilledInfo)aggregation.get(i2)).getTargetLevels(), ((DrilledInfo)aggregation.get(i2)).getSortType(), ((DrilledInfo)aggregation.get(i2)).getAggregationFunctionDefinition());
            a[i2].setDrilledInfo((DrilledInfo)aggregation.get(i2));
            ++i2;
        }
        return a;
    }

    public static boolean containsDrillFilter(ICubeQueryDefinition cubeQueryDefinition) {
        IEdgeDefinition columnEdge = cubeQueryDefinition.getEdge(2);
        IEdgeDefinition rowEdge = cubeQueryDefinition.getEdge(1);
        List<DrillOnDimensionHierarchy> columnDrill = CubeQueryDefinitionUtil.flatternDrillFilter(columnEdge);
        List<DrillOnDimensionHierarchy> rowDrill = CubeQueryDefinitionUtil.flatternDrillFilter(rowEdge);
        return !columnDrill.isEmpty() || !rowDrill.isEmpty();
    }

    public static AggregationDefinition[] preparedDrillAggregation(ICubeQueryDefinition cubeQueryDefinition, AggregationDefinition[] aggrDefns) {
        IEdgeDefinition columnEdge = cubeQueryDefinition.getEdge(2);
        IEdgeDefinition rowEdge = cubeQueryDefinition.getEdge(1);
        List<DrillOnDimensionHierarchy> columnDrill = CubeQueryDefinitionUtil.flatternDrillFilter(columnEdge);
        List<DrillOnDimensionHierarchy> rowDrill = CubeQueryDefinitionUtil.flatternDrillFilter(rowEdge);
        ArrayList<DrillOnDimensionHierarchy> combinedDrill = new ArrayList<DrillOnDimensionHierarchy>(rowDrill);
        combinedDrill.addAll(columnDrill);
        if (combinedDrill.isEmpty()) {
            return new AggregationDefinition[0];
        }
        ArrayList<DrilledInfo> aggregation = new ArrayList<DrilledInfo>();
        int i = 0;
        while (i < aggrDefns.length) {
            DimLevel[] levels;
            if (aggrDefns[i].getAggregationFunctions() != null && (levels = aggrDefns[i].getLevels()) != null) {
                ArrayList<List<DimLevel>> groupByDimension = new ArrayList<List<DimLevel>>();
                String dimensionName = null;
                ArrayList<DimLevel> list = null;
                int j = 0;
                while (j < levels.length - 1) {
                    if (dimensionName != null && dimensionName.equals(levels[j].getDimensionName())) {
                        if (DrillFilterHelper.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                    } else {
                        list = new ArrayList<DimLevel>();
                        if (DrillFilterHelper.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                        dimensionName = levels[j].getDimensionName();
                        groupByDimension.add(list);
                    }
                    ++j;
                }
                if (!groupByDimension.isEmpty()) {
                    ArrayList<DimLevel[]> tagetLevels = new ArrayList<DimLevel[]>();
                    tagetLevels.add(levels);
                    DrillFilterHelper.buildAggregationDimLevel(tagetLevels, groupByDimension, 0);
                    int k = 1;
                    while (k < tagetLevels.size()) {
                        boolean exist = false;
                        int t = 0;
                        while (t < aggregation.size()) {
                            if (((DrilledInfo)aggregation.get(t)).matchTargetlevels((DimLevel[])tagetLevels.get(k))) {
                                ((DrilledInfo)aggregation.get(t)).addOriginalAggregation(aggrDefns[i]);
                                exist = true;
                                break;
                            }
                            ++t;
                        }
                        if (!exist) {
                            DrilledInfo aggr = new DrilledInfo((DimLevel[])tagetLevels.get(k), cubeQueryDefinition);
                            aggr.addOriginalAggregation(aggrDefns[i]);
                            aggregation.add(aggr);
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        AggregationDefinition[] a = new AggregationDefinition[aggregation.size()];
        int i2 = 0;
        while (i2 < aggregation.size()) {
            a[i2] = new AggregationDefinition(((DrilledInfo)aggregation.get(i2)).getTargetLevels(), ((DrilledInfo)aggregation.get(i2)).getSortType(), ((DrilledInfo)aggregation.get(i2)).getAggregationFunctionDefinition());
            a[i2].setDrilledInfo((DrilledInfo)aggregation.get(i2));
            ++i2;
        }
        return a;
    }

    private static boolean isRunningAggregation(AggregationDefinition defn) {
        AggregationFunctionDefinition[] afds;
        AggregationDefinition ad = defn;
        if (ad != null && (afds = ad.getAggregationFunctions()) != null && afds.length == 1) {
            String functionName = afds[0].getFunctionName();
            IAggrFunction af = null;
            try {
                af = AggregationManager.getInstance().getAggregation(functionName);
            }
            catch (DataException dataException) {
                // empty catch block
            }
            return af != null && af.getType() == 1;
        }
        return false;
    }

    private static void buildAggregationDimLevel(List<DimLevel[]> tagetLevels, List<List<DimLevel>> groupByDimension, int dimIndex) {
        List<DimLevel> l = groupByDimension.get(dimIndex);
        ArrayList<DimLevel[]> temp = new ArrayList<DimLevel[]>();
        int t = 0;
        while (t < l.size()) {
            DimLevel dimLevel = l.get(t);
            int i = 0;
            while (i < tagetLevels.size()) {
                temp.add(DrillFilterHelper.getDrilledDimLevel(dimLevel, tagetLevels.get(i)));
                ++i;
            }
            ++t;
        }
        tagetLevels.addAll(temp);
        if (++dimIndex < groupByDimension.size()) {
            DrillFilterHelper.buildAggregationDimLevel(tagetLevels, groupByDimension, dimIndex);
        }
    }

    private static DimLevel[] getDrilledDimLevel(DimLevel dimLevel, DimLevel[] levels) {
        boolean find = false;
        ArrayList<DimLevel> d = new ArrayList<DimLevel>();
        int i = 0;
        while (i < levels.length) {
            if (!dimLevel.getDimensionName().equals(levels[i].getDimensionName())) {
                d.add(levels[i]);
            } else {
                if (dimLevel.equals(levels[i])) {
                    find = true;
                    d.add(levels[i]);
                }
                if (!find) {
                    d.add(levels[i]);
                }
            }
            ++i;
        }
        DimLevel[] dim = new DimLevel[d.size()];
        int i2 = 0;
        while (i2 < dim.length) {
            dim[i2] = (DimLevel)d.get(i2);
            ++i2;
        }
        return dim;
    }

    private static boolean isDrilledLevel(DimLevel levels, List<DrillOnDimensionHierarchy> combinedDrill) {
        int i = 0;
        while (i < combinedDrill.size()) {
            DrillOnDimensionHierarchy dim = combinedDrill.get(i);
            List<IEdgeDrillFilter> filters = dim.getDrillFilterByLevel(levels);
            if (filters != null && !filters.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

