/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;

public class RDSubQueryUtil {
    private DataEngineContext context;
    private String queryResultID;
    private String subQueryName;
    private int groupLevel;
    private int[] subQueryInfo;

    RDSubQueryUtil(DataEngineContext context, String queryResultID, String subQueryName) {
        this.context = context;
        this.queryResultID = queryResultID;
        this.subQueryName = subQueryName;
    }

    public static void doSave(OutputStream stream, int groupLevel, int[] subQueryInfo) throws DataException {
        if (subQueryInfo == null) {
            return;
        }
        try {
            IOUtil.writeInt(stream, groupLevel);
            int size = subQueryInfo.length;
            IOUtil.writeInt(stream, size);
            int i = 0;
            while (i < size) {
                IOUtil.writeInt(stream, subQueryInfo[i]);
                ++i;
            }
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, (Object)"Subquery");
        }
    }

    int getSubQueryIndex(int currParentIndex) throws DataException {
        this.loadSubQuery();
        return RDSubQueryUtil.findSubQueryIndex(currParentIndex, this.groupLevel, this.subQueryInfo);
    }

    private void loadSubQuery() throws DataException {
        if (this.subQueryInfo != null) {
            return;
        }
        RAInputStream stream = this.context.getInputStream(this.queryResultID, this.subQueryName, 42);
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            this.groupLevel = IOUtil.readInt(bis);
            int size = IOUtil.readInt(bis);
            this.subQueryInfo = new int[size];
            int i = 0;
            while (i < size) {
                this.subQueryInfo[i] = IOUtil.readInt(bis);
                ++i;
            }
            bis.close();
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Subquery");
        }
    }

    private static int findSubQueryIndex(int currParentIndex, int groupLevel, int[] subQueryInfo) {
        if (groupLevel == 0) {
            return 0;
        }
        int subQueryCount = subQueryInfo.length / 2;
        int subQueryIndex = 0;
        while (subQueryIndex < subQueryCount) {
            if (currParentIndex < subQueryInfo[subQueryIndex * 2 + 1]) break;
            ++subQueryIndex;
        }
        return subQueryIndex;
    }
}

