/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.NumberUtil;

public class Methods
implements IConstants {
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    public static final CDateTime asDateTime(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DateTimeDataElement) {
            return ((DateTimeDataElement)o).getValueAsCDateTime();
        }
        if (o instanceof Calendar) {
            return new CDateTime((Calendar)o);
        }
        if (o instanceof Date) {
            return new CDateTime((Date)o);
        }
        if (o instanceof CDateTime) {
            return (CDateTime)((Object)o);
        }
        return null;
    }

    public static final Double asDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NumberDataElement) {
            return new Double(((NumberDataElement)o).getValue());
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return 0.0;
    }

    public static final int asInteger(Object o) {
        return ((Number)o).intValue();
    }

    static final double getLocation(AutoScale sc, IntersectionValue iv) {
        AxisTickCoordinates da = sc.getTickCordinates();
        if (iv.getType() == 2) {
            return da.getStart();
        }
        if (iv.getType() == 1) {
            return da.getEnd();
        }
        if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
            double dValue = iv.getValueAsDouble(sc);
            return da.getStart() + da.getStep() * dValue;
        }
        if ((sc.getType() & 8) == 8) {
            CDateTime cdtValue = Methods.asDateTime(iv.getValue());
            CDateTime cdt = Methods.asDateTime(sc.getMinimum());
            CDateTime cdtPrev = null;
            int iUnit = Methods.asInteger(sc.getUnit());
            int iStep = Methods.asInteger(sc.getStep());
            int i = 0;
            while (i < da.size()) {
                if (cdt.after((Object)cdtValue)) {
                    if (cdtPrev == null) {
                        return da.getCoordinate(i);
                    }
                    long l1 = cdtPrev.getTimeInMillis();
                    long l2 = cdt.getTimeInMillis();
                    long l = cdtValue.getTimeInMillis();
                    double dUnitSize = da.getStep();
                    double dOffset = dUnitSize / (double)(l2 - l1) * (double)(l - l1);
                    return da.getCoordinate(i - 1) + dOffset;
                }
                cdtPrev = cdt;
                cdt = cdt.forward(iUnit, iStep);
                ++i;
            }
            return da.getEnd();
        }
        if ((sc.getType() & 4) == 4) {
            double dValue = iv.getValueAsDouble(sc);
            if (dValue == 0.0 || dValue < 0.0) {
                return sc.getStart();
            }
            double dMinimumLog = Math.log(Methods.asDouble(sc.getMinimum())) / LOG_10;
            double dStepLog = Math.log(Methods.asDouble(sc.getStep())) / LOG_10;
            double dValueLog = Math.log(dValue) / LOG_10;
            return da.getStart() + (dValueLog - dMinimumLog) / dStepLog * da.getStep();
        }
        double dValue = iv.getValueAsDouble(sc);
        double dMinimum = Methods.asDouble(sc.getMinimum());
        double dMaximum = Methods.asDouble(sc.getMaximum());
        double[] ea = sc.getEndPoints();
        if (dMaximum == dMinimum) {
            return ea[0];
        }
        return ea[0] - (dValue - dMinimum) / (dMaximum - dMinimum) * (ea[0] - ea[1]);
    }

    public static final double getLocation(AutoScale sc, Object oValue) throws ChartException, IllegalArgumentException {
        if (oValue == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(sc.getRunTimeContext().getULocale()).getString("exception.scale.null.location"), sc));
        }
        if (oValue instanceof Number) {
            return Methods.getLocation(sc, ((Number)oValue).doubleValue());
        }
        if (oValue instanceof Calendar) {
            return Methods.getDateLocation(sc, new CDateTime((Calendar)oValue));
        }
        if (oValue instanceof NumberDataElement) {
            return Methods.getLocation(sc, ((NumberDataElement)oValue).getValue());
        }
        if (oValue instanceof DateTimeDataElement) {
            return Methods.getDateLocation(sc, ((DateTimeDataElement)oValue).getValueAsCDateTime());
        }
        if (oValue instanceof BigNumberDataElement) {
            return Methods.getLocation(sc, ((BigNumberDataElement)oValue).getValue());
        }
        if (oValue instanceof IntersectionValue) {
            return Methods.getLocation(sc, (IntersectionValue)oValue);
        }
        return sc.getStart();
    }

    public static final double getNormalizedLocation(AutoScale sc, double dValue) {
        return Methods.getLocation(sc, dValue) - sc.getStart();
    }

    public static final double getNormalizedLocation(AutoScale sc, Object oValue) throws ChartException, IllegalArgumentException {
        return Methods.getLocation(sc, oValue) - sc.getStart();
    }

    public static final double getLocation(AutoScale sc, Number bdValue) {
        if (sc.isBigNumber()) {
            return Methods.getLocation(sc, NumberUtil.asBigDecimal(bdValue).divide(sc.getBigNumberDivisor()).doubleValue());
        }
        return Methods.getLocation(sc, bdValue.doubleValue());
    }

    public static final double getLocation(AutoScale sc, double dValue) throws IllegalArgumentException {
        if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
            AxisTickCoordinates da = sc.getTickCordinates();
            return da.getStart() + da.getStep() * dValue;
        }
        if ((sc.getType() & 2) == 2) {
            double dMinimum = Methods.asDouble(sc.getMinimum());
            double dMaximum = Methods.asDouble(sc.getMaximum());
            double[] da = sc.getEndPoints();
            if (sc.isSetFactor()) {
                double delta = (dValue - dMinimum) / sc.getFactor();
                return da[0] < da[1] ? da[0] + delta : da[0] - delta;
            }
            if (dMaximum == dMinimum) {
                return da[0];
            }
            return da[0] - (dValue - dMinimum) / (dMaximum - dMinimum) * (da[0] - da[1]);
        }
        if ((sc.getType() & 4) == 4) {
            if (dValue == 0.0) {
                return sc.getStart();
            }
            if (dValue < 0.0) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(sc.getRunTimeContext().getULocale()).getString("exception.zero.negative.logarithmic.scale"), sc));
            }
            double dMinimumLog = Math.log(Methods.asDouble(sc.getMinimum())) / LOG_10;
            double dStepLog = Math.log(Methods.asDouble(sc.getStep())) / LOG_10;
            double dValueLog = Math.log(dValue) / LOG_10;
            AxisTickCoordinates da = sc.getTickCordinates();
            return da.getStart() + (dValueLog - dMinimumLog) / dStepLog * da.getStep();
        }
        return 0.0;
    }

    static final double getDateLocation(AutoScale sc, CDateTime cdtValue) {
        AxisTickCoordinates da = sc.getTickCordinates();
        CDateTime cdtMin = Methods.asDateTime(sc.getMinimum());
        CDateTime cdtMax = Methods.asDateTime(sc.getMaximum());
        long max = cdtMax.getTimeInMillis();
        long min = cdtMin.getTimeInMillis();
        long curr = cdtValue.getTimeInMillis();
        if (max == min) {
            return da.getStart();
        }
        return da.getStart() + (double)(curr - min) * ((da.getEnd() - da.getStart()) / (double)(max - min));
    }

    public static final double computeWidth(IDisplayServer xs, Label la) {
        ITextMetrics itm = xs.getTextMetrics(la);
        try {
            double d = Methods.computeWidth(itm, la);
            return d;
        }
        finally {
            itm.dispose();
        }
    }

    public static final double computeWidth(ITextMetrics itm, Label la) {
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInRadians = -fd.getRotation() * Math.PI / 180.0;
        double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
        double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
        double dW = itm.getFullWidth() * dCosTheta + itm.getFullHeight() * dSineTheta;
        return dW;
    }

    public static final double computeHeight(IDisplayServer xs, Label la) {
        ITextMetrics itm = xs.getTextMetrics(la);
        try {
            double d = Methods.computeHeight(itm, la);
            return d;
        }
        finally {
            itm.dispose();
        }
    }

    public static final double computeHeight(ITextMetrics itm, Label la) {
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInRadians = -fd.getRotation() * Math.PI / 180.0;
        double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
        double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
        double dH = itm.getFullWidth() * dSineTheta + itm.getFullHeight() * dCosTheta;
        return dH;
    }

    public static final RotatedRectangle computePolygon(IDisplayServer xs, int iLabelLocation, Label la, double dX, double dY) throws IllegalArgumentException {
        return Methods.computePolygon(xs, iLabelLocation, la, dX, dY, null);
    }

    public static final RotatedRectangle computePolygon(IDisplayServer xs, int iLabelLocation, Label la, double dX, double dY, Double fontHeight) throws IllegalArgumentException {
        ITextMetrics itm = xs.getTextMetrics(la);
        try {
            RotatedRectangle rotatedRectangle = Methods.computePolygon(itm, iLabelLocation, la, dX, dY, fontHeight);
            return rotatedRectangle;
        }
        finally {
            itm.dispose();
        }
    }

    public static final RotatedRectangle computePolygon(ITextMetrics itm, int iLabelLocation, Label la, double dX, double dY, Double fontHeight) throws IllegalArgumentException {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
        double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
        double dW = itm.getFullWidth();
        double dH = fontHeight == null ? itm.getFullHeight() : itm.getFullHeight(fontHeight);
        RotatedRectangle rr = null;
        if ((iLabelLocation & 1) == 1) {
            if (dAngleInDegrees == 0.0) {
                rr = new RotatedRectangle(dX - dW, dY - dH / 2.0, dX, dY - dH / 2.0, dX, dY + dH / 2.0, dX - dW, dY + dH / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                rr = new RotatedRectangle(dX - dH * dSineTheta - dW * dCosTheta, dY - dH * dCosTheta + dW * dSineTheta, dX - dH * dSineTheta, dY - dH * dCosTheta, dX, dY, dX - dW * dCosTheta, dY + dW * dSineTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                rr = new RotatedRectangle(dX - dW * dCosTheta, dY - dW * dSineTheta, dX, dY, dX - dH * dSineTheta, dY + dH * dCosTheta, dX - dH * dSineTheta - dW * dCosTheta, dY + dH * dCosTheta - dW * dSineTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                rr = new RotatedRectangle(dX - dH, dY - dW / 2.0, dX, dY - dW / 2.0, dX, dY + dW / 2.0, dX - dH, dY + dW / 2.0);
            }
        } else if ((iLabelLocation & 2) == 2) {
            if (dAngleInDegrees == 0.0) {
                rr = new RotatedRectangle(dX, dY - dH / 2.0, dX + dW, dY - dH / 2.0, dX + dW, dY + dH / 2.0, dX, dY + dH / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                rr = new RotatedRectangle(dX, dY, dX + dW * dCosTheta, dY - dW * dSineTheta, dX + dW * dCosTheta + dH * dSineTheta, dY - dW * dSineTheta + dH * dCosTheta, dX + dH * dSineTheta, dY + dH * dCosTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                rr = new RotatedRectangle(dX + dH * dSineTheta, dY - dH * dCosTheta, dX + dH * dSineTheta + dW * dCosTheta, dY - dH * dCosTheta + dW * dSineTheta, dX + dW * dCosTheta, dY + dW * dSineTheta, dX, dY);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                rr = new RotatedRectangle(dX, dY - dW / 2.0, dX + dH, dY - dW / 2.0, dX + dH, dY + dW / 2.0, dX, dY + dW / 2.0);
            }
        } else if ((iLabelLocation & 8) == 8) {
            if (dAngleInDegrees == 0.0) {
                rr = new RotatedRectangle(dX - dW / 2.0, dY, dX + dW / 2.0, dY, dX + dW / 2.0, dY + dH, dX - dW / 2.0, dY + dH);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                rr = new RotatedRectangle(dX - dW * dCosTheta, dY + dW * dSineTheta, dX, dY, dX + dH * dSineTheta, dY + dH * dCosTheta, dX + dH * dSineTheta - dW * dCosTheta, dY + dH * dCosTheta + dW * dSineTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                rr = new RotatedRectangle(dX, dY, dX + dW * dCosTheta, dY + dW * dSineTheta, dX + dW * dCosTheta - dH * dSineTheta, dY + dW * dSineTheta + dH * dCosTheta, dX - dH * dSineTheta, dY + dH * dCosTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                rr = new RotatedRectangle(dX - dH / 2.0, dY, dX + dH / 2.0, dY, dX + dH / 2.0, dY + dW, dX - dH / 2.0, dY + dW);
            }
        } else if ((iLabelLocation & 4) == 4) {
            if (dAngleInDegrees == 0.0) {
                rr = new RotatedRectangle(dX - dW / 2.0, dY - dH, dX + dW / 2.0, dY - dH, dX + dW / 2.0, dY, dX - dW / 2.0, dY);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                rr = new RotatedRectangle(dX - dH * dSineTheta, dY - dH * dCosTheta, dX - dH * dSineTheta + dW * dCosTheta, dY - dH * dCosTheta - dW * dSineTheta, dX + dW * dCosTheta, dY - dW * dSineTheta, dX, dY);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                rr = new RotatedRectangle(dX - dW * dCosTheta + dH * dSineTheta, dY - dW * dSineTheta - dH * dCosTheta, dX + dH * dSineTheta, dY - dH * dCosTheta, dX, dY, dX - dW * dCosTheta, dY - dW * dSineTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                rr = new RotatedRectangle(dX - dH / 2.0, dY - dW, dX + dH / 2.0, dY - dW, dX + dH / 2.0, dY, dX - dH / 2.0, dY);
            }
        } else if ((iLabelLocation & 0x20) == 32) {
            if (dAngleInDegrees == 0.0) {
                rr = new RotatedRectangle(dX - dW / 2.0, dY - dH / 2.0, dX + dW / 2.0, dY - dH / 2.0, dX + dW / 2.0, dY + dH / 2.0, dX - dW / 2.0, dY + dH / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                rr = new RotatedRectangle(dX - dH / 2.0 * dSineTheta - dW / 2.0 * dCosTheta, dY - dH / 2.0 * dCosTheta + dW / 2.0 * dSineTheta, dX - dH / 2.0 * dSineTheta + dW / 2.0 * dCosTheta, dY - dH / 2.0 * dCosTheta - dW / 2.0 * dSineTheta, dX + dH / 2.0 * dSineTheta + dW / 2.0 * dCosTheta, dY + dH / 2.0 * dCosTheta - dW / 2.0 * dSineTheta, dX + dH / 2.0 * dSineTheta - dW / 2.0 * dCosTheta, dY + dH / 2.0 * dCosTheta + dW / 2.0 * dSineTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                rr = new RotatedRectangle(dX - dW / 2.0 * dCosTheta + dH / 2.0 * dSineTheta, dY - dW / 2.0 * dSineTheta - dH / 2.0 * dCosTheta, dX + dH / 2.0 * dSineTheta + dW / 2.0 * dCosTheta, dY - dH / 2.0 * dCosTheta + dW / 2.0 * dSineTheta, dX + dW / 2.0 * dCosTheta - dH / 2.0 * dSineTheta, dY + dH / 2.0 * dCosTheta + dW / 2.0 * dSineTheta, dX - dW / 2.0 * dCosTheta - dH / 2.0 * dSineTheta, dY - dW / 2.0 * dSineTheta + dH / 2.0 * dCosTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                rr = new RotatedRectangle(dX - dH / 2.0, dY - dW / 2.0, dX + dH / 2.0, dY - dW / 2.0, dX + dH / 2.0, dY + dW / 2.0, dX - dH / 2.0, dY + dW / 2.0);
            }
        }
        return rr;
    }

    public static final Location computeRotatedTopPoint(IDisplayServer xs, BoundingBox bbox, Label la, double fullHeight) throws IllegalArgumentException {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(xs.getULocale()).getString("exception.illegal.rotation.angle.label"), la));
        }
        double dAngleInRadians = Math.toRadians(dAngleInDegrees);
        Location loc = goFactory.createLocation(bbox.getLeft(), bbox.getTop());
        if (dAngleInDegrees != 0.0) {
            if (dAngleInDegrees == 90.0) {
                loc.setY(loc.getY() + bbox.getHeight());
            } else if (dAngleInDegrees == -90.0) {
                loc.setX(loc.getX() + bbox.getWidth());
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double A = bbox.getTop() + bbox.getHeight() / 2.0 - (bbox.getLeft() + bbox.getWidth() / 2.0) * Math.tan(dAngleInRadians);
                double ny = 2.0 * (bbox.getTop() + bbox.getHeight() / 2.0) - (Math.tan(dAngleInRadians) * bbox.getLeft() + A) - fullHeight / 2.0 / Math.cos(dAngleInRadians);
                loc.setY(ny);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double A = bbox.getTop() + bbox.getHeight() / 2.0 - (bbox.getLeft() + bbox.getWidth() / 2.0) * Math.tan(dAngleInRadians);
                double nx = 2.0 * (bbox.getLeft() + bbox.getWidth() / 2.0) - (bbox.getTop() - A) / Math.tan(dAngleInRadians) + fullHeight / 2.0 / Math.abs(Math.sin(dAngleInRadians));
                loc.setX(nx);
            }
        }
        return loc;
    }

    public static final BoundingBox computeBox(IDisplayServer xs, int iLabelLocation, Label la, double dX, double dY) throws IllegalArgumentException {
        return Methods.computeBox(xs, iLabelLocation, la, dX, dY, 0.0);
    }

    public static final BoundingBox computeLabelSize(IDisplayServer xs, Label la, double dWrapping, Double fontHeight) throws ChartException {
        try {
            return Methods.computeBox(xs, 4, la, 0.0, 0.0, dWrapping, fontHeight);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)uiex);
        }
    }

    public static final BoundingBox computeBox(IDisplayServer xs, int iLabelLocation, Label la, double dX, double dY, double dWrapping) throws IllegalArgumentException {
        return Methods.computeBox(xs, iLabelLocation, la, dX, dY, dWrapping, null);
    }

    public static final BoundingBox computeBox(IDisplayServer xs, ITextMetrics itm, int iLabelLocation, Label la, double dX, double dY, Double fontHeight) throws IllegalArgumentException {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(xs.getULocale()).getString("exception.illegal.rotation.angle.label"), la));
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
        double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
        double dW = itm.getFullWidth();
        double dH = fontHeight == null ? itm.getFullHeight() : itm.getFullHeight(fontHeight);
        BoundingBox bb = null;
        if ((iLabelLocation & 1) == 1) {
            if (dAngleInDegrees == 0.0) {
                bb = new BoundingBox(1, dX - dW, dY - dH / 2.0, dW, dH, dH / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                bb = new BoundingBox(1, dX - (dH * dSineTheta + dW * dCosTheta), dY - dH * dCosTheta, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dH * dCosTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                bb = new BoundingBox(1, dX - (dH * dSineTheta + dW * dCosTheta), dY - dW * dSineTheta, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dW * dSineTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                bb = new BoundingBox(1, dX - dH, dY - dW / 2.0, dH, dW, dW / 2.0);
            }
        } else if ((iLabelLocation & 2) == 2) {
            if (dAngleInDegrees == 0.0) {
                bb = new BoundingBox(2, dX, dY - dH / 2.0, dW, dH, dH / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                bb = new BoundingBox(2, dX, dY - dW * dSineTheta, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dW * dSineTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                bb = new BoundingBox(2, dX, dY - dH * dCosTheta, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dH * dCosTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                bb = new BoundingBox(2, dX, dY - dW / 2.0, dH, dW, dW / 2.0);
            }
        } else if ((iLabelLocation & 8) == 8) {
            if (dAngleInDegrees == 0.0) {
                bb = new BoundingBox(8, dX - dW / 2.0, dY, dW, dH, dW / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                bb = new BoundingBox(8, dX - dW * dCosTheta, dY, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dW * dCosTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                bb = new BoundingBox(8, dX - dH * dSineTheta, dY, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dH * dSineTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                bb = new BoundingBox(8, dX - dH / 2.0, dY, dH, dW, dH / 2.0);
            }
        } else if ((iLabelLocation & 4) == 4) {
            if (dAngleInDegrees == 0.0) {
                bb = new BoundingBox(4, dX - dW / 2.0, dY - dH, dW, dH, dW / 2.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                bb = new BoundingBox(4, dX - dH * dSineTheta, dY - (dH * dCosTheta + dW * dSineTheta), dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dH * dSineTheta);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                bb = new BoundingBox(4, dX - dW * dCosTheta, dY - (dH * dCosTheta + dW * dSineTheta), dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, dW * dCosTheta);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                bb = new BoundingBox(4, dX - dH / 2.0, dY - dW, dH, dW, dH / 2.0);
            }
        } else if ((iLabelLocation & 0x20) == 32) {
            if (dAngleInDegrees == 0.0) {
                bb = new BoundingBox(32, dX - dW / 2.0, dY - dH / 2.0, dW, dH, 0.0);
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                bb = new BoundingBox(32, dX - (dH * dSineTheta + dW * dCosTheta) / 2.0, dY - (dH * dCosTheta + dW * dSineTheta) / 2.0, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, 0.0);
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                bb = new BoundingBox(32, dX - (dW * dCosTheta + dH * dSineTheta) / 2.0, dY - (dH * dCosTheta + dW * dSineTheta) / 2.0, dH * dSineTheta + dW * dCosTheta, dH * dCosTheta + dW * dSineTheta, 0.0);
            } else if (dAngleInDegrees == 90.0 || dAngleInDegrees == -90.0) {
                bb = new BoundingBox(32, dX - dH / 2.0, dY - dW / 2.0, dH, dW, 0.0);
            }
        }
        return bb;
    }

    public static final BoundingBox computeBox(IDisplayServer xs, int iLabelLocation, Label la, double dX, double dY, double dWrapping, Double fontHeight) throws IllegalArgumentException {
        ITextMetrics itm = xs.getTextMetrics(la);
        try {
            if (dWrapping > 0.0) {
                itm.reuse(la, dWrapping);
            }
            BoundingBox boundingBox = Methods.computeBox(xs, itm, iLabelLocation, la, dX, dY, fontHeight);
            return boundingBox;
        }
        finally {
            itm.dispose();
        }
    }

    public static final int getLabelPosition(Position lp) {
        int iLabelPosition = 0;
        switch (lp.getValue()) {
            case 2: {
                iLabelPosition = 1;
                break;
            }
            case 3: {
                iLabelPosition = 2;
                break;
            }
            case 0: {
                iLabelPosition = 4;
                break;
            }
            case 1: {
                iLabelPosition = 8;
                break;
            }
            case 5: {
                iLabelPosition = 16;
                break;
            }
            case 4: {
                iLabelPosition = 32;
            }
        }
        return iLabelPosition;
    }

    public static double computeFontHeight(IDisplayServer xs, Label la) {
        String sText = la.getCaption().getValue();
        la.getCaption().setValue("X");
        ITextMetrics itm = xs.getTextMetrics(la);
        try {
            itm.reuse(la);
            double d = itm.getHeight();
            return d;
        }
        finally {
            itm.dispose();
            la.getCaption().setValue(sText);
        }
    }
}

