/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.utils;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ByteBufferOutputStream
extends OutputStream {
    static final int INITIAL_BUFFER_SIZE = 256;
    private List<ByteBuffer> buffers;

    public ByteBufferOutputStream() {
        this.reset();
    }

    public List<ByteBuffer> getBufferList() {
        List<ByteBuffer> result = this.buffers;
        this.reset();
        for (ByteBuffer buffer : result) {
            buffer.flip();
        }
        return result;
    }

    public ByteBuffer getByteBuffer() {
        List<ByteBuffer> list = this.getBufferList();
        if (list.size() == 1) {
            return list.get(0);
        }
        int size = 0;
        for (ByteBuffer buffer : list) {
            size += buffer.remaining();
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        for (ByteBuffer buffer : list) {
            result.put(buffer);
        }
        return (ByteBuffer)result.rewind();
    }

    public void prepend(List<ByteBuffer> lists) {
        for (ByteBuffer buffer : lists) {
            buffer.position(buffer.limit());
        }
        this.buffers.addAll(0, lists);
    }

    public void append(List<ByteBuffer> lists) {
        for (ByteBuffer buffer : lists) {
            buffer.position(buffer.limit());
        }
        this.buffers.addAll(lists);
    }

    public void reset() {
        this.buffers = new LinkedList<ByteBuffer>();
        this.buffers.add(ByteBuffer.allocate(256));
    }

    private ByteBuffer getBufferWithCapacity(int capacity) {
        ByteBuffer lastBuffer = this.buffers.get(this.buffers.size() - 1);
        if (lastBuffer.remaining() >= capacity) {
            return lastBuffer;
        }
        int newSize = lastBuffer.capacity() * 2;
        if (newSize < capacity) {
            newSize = capacity;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
        this.buffers.add(newBuffer);
        return newBuffer;
    }

    @Override
    public void write(int b) {
        ByteBuffer buffer = this.getBufferWithCapacity(1);
        buffer.put((byte)b);
    }

    public void writeShort(short value) {
        ByteBuffer buffer = this.getBufferWithCapacity(2);
        buffer.putShort(value);
    }

    public void writeChar(char value) {
        ByteBuffer buffer = this.getBufferWithCapacity(2);
        buffer.putChar(value);
    }

    public void writeInt(int value) {
        ByteBuffer buffer = this.getBufferWithCapacity(4);
        buffer.putInt(value);
    }

    public void writeFloat(float value) {
        ByteBuffer buffer = this.getBufferWithCapacity(4);
        buffer.putFloat(value);
    }

    public void writeLong(long value) {
        ByteBuffer buffer = this.getBufferWithCapacity(8);
        buffer.putLong(value);
    }

    public void writeDouble(double value) {
        ByteBuffer buffer = this.getBufferWithCapacity(8);
        buffer.putDouble(value);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        ByteBuffer lastBuffer = this.buffers.get(this.buffers.size() - 1);
        if (lastBuffer.remaining() >= len) {
            lastBuffer.put(b, off, len);
        } else {
            int writtenToLast = lastBuffer.remaining();
            if (lastBuffer.remaining() != 0) {
                lastBuffer.put(b, off, writtenToLast);
            }
            this.getBufferWithCapacity(len - writtenToLast);
            this.write(b, off + writtenToLast, len - writtenToLast);
        }
    }

    public void write(ByteBuffer buffer) {
        if (buffer.remaining() < 8196) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            ByteBuffer dup = buffer.duplicate();
            dup.position(buffer.limit());
            this.buffers.add(dup);
        }
    }
}

