/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Iterator;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.query.RangeSlicesQuery;

public class RangeSlicesIterator<K, N, V>
implements Iterator<Row<K, N, V>> {
    private RangeSlicesQuery<K, N, V> query;
    private K startKey;
    private K endKey;
    private Iterator<Row<K, N, V>> iterator;
    private int rows = 0;

    public RangeSlicesIterator(RangeSlicesQuery<K, N, V> query, K startKey, K endKey) {
        this.query = query;
        this.startKey = startKey;
        this.query.setKeys(startKey, endKey);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = ((OrderedRows)this.query.execute().get()).getList().iterator();
        } else if (!this.iterator.hasNext() && this.rows == this.query.getRowCount()) {
            this.query.setKeys(this.startKey, this.endKey);
            this.iterator = ((OrderedRows)this.query.execute().get()).getList().iterator();
            this.rows = 0;
            if (this.iterator.hasNext()) {
                this.next();
            }
        }
        return this.iterator.hasNext();
    }

    @Override
    public Row<K, N, V> next() {
        Row<K, N, V> row = this.iterator.next();
        this.startKey = row.getKey();
        ++this.rows;
        return row;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

