/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.HCounterColumnImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.CounterSlice;
import me.prettyprint.hector.api.beans.HCounterColumn;
import org.apache.cassandra.thrift.CounterColumn;

public final class CounterSliceImpl<N>
implements CounterSlice<N> {
    private final Map<N, HCounterColumn<N>> columnsMap;
    private final List<HCounterColumn<N>> columnsList;

    public CounterSliceImpl(List<CounterColumn> tColumns, Serializer<N> nameSerializer) {
        Assert.noneNull(tColumns, nameSerializer);
        this.columnsMap = new HashMap<N, HCounterColumn<N>>(tColumns.size());
        ArrayList<HCounterColumn<N>> list = new ArrayList<HCounterColumn<N>>(tColumns.size());
        for (CounterColumn c : tColumns) {
            HCounterColumnImpl<N> column = new HCounterColumnImpl<N>(c, nameSerializer);
            this.columnsMap.put(column.getName(), column);
            list.add(column);
        }
        this.columnsList = list;
    }

    @Override
    public List<HCounterColumn<N>> getColumns() {
        return this.columnsList;
    }

    @Override
    public HCounterColumn<N> getColumnByName(N columnName) {
        return this.columnsMap.get(columnName);
    }

    public String toString() {
        return String.format("ColumnSlice(%s)", this.columnsList.toString());
    }
}

