/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfoComparator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInformationUtil;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class GroupCalculationUtil {
    private BaseQuery query;
    private IResultClass rsMeta;
    private GroupBy[] groupDefs;
    private ResultSetCache smartCache;
    private GroupInformationUtil groupInformationUtil;
    private ResultSetPopulator resultPopoulator;

    GroupCalculationUtil(BaseQuery query, ResultSetPopulator resultPopoulator, DataEngineSession session) throws DataException {
        this.query = query;
        this.resultPopoulator = resultPopoulator;
        this.rsMeta = resultPopoulator.getResultSetMetadata();
        this.groupInformationUtil = new GroupInformationUtil(this, session);
        this.initGroupSpec();
    }

    public GroupInformationUtil getGroupInformationUtil() {
        return this.groupInformationUtil;
    }

    public void doSave(OutputStream outputStream) throws DataException {
        try {
            this.groupInformationUtil.saveGroupsToStream(outputStream);
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Group Information");
        }
    }

    public void setResultSetCache(ResultSetCache rsc) {
        this.smartCache = rsc;
    }

    int getGroupCount() {
        return this.groupDefs.length;
    }

    void sortGroupBoundaryInfos(List[] groupArray) {
        int i = 0;
        while (i < groupArray.length) {
            Object[] toBeSorted = new Object[groupArray[i].size()];
            int j = 0;
            while (j < toBeSorted.length) {
                toBeSorted[j] = groupArray[i].get(j);
                ++j;
            }
            Arrays.sort(toBeSorted, new GroupBoundaryInfoComparator());
            groupArray[i].clear();
            j = 0;
            while (j < toBeSorted.length) {
                groupArray[i].add(toBeSorted[j]);
                ++j;
            }
            ++i;
        }
    }

    public BaseQuery getQuery() {
        return this.query;
    }

    List[] filterGroupBoundaryInfos(List[] groupArray) {
        List[] result = new List[groupArray.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new CachedList(this.resultPopoulator.getSession().getTempDir(), DataEngineSession.getCurrentClassLoader(), GroupBoundaryInfo.getCreator());
            ++i;
        }
        i = 0;
        while (i < groupArray.length) {
            int j = 0;
            while (j < groupArray[i].size()) {
                if (((GroupBoundaryInfo)groupArray[i].get(j)).isAccpted()) {
                    result[i].add(groupArray[i].get(j));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    GroupBy[] getGroupDefn() {
        return this.groupDefs;
    }

    ResultSetCache getResultSetCache() {
        return this.smartCache;
    }

    ResultSetPopulator getResultSetPopoulator() {
        return this.resultPopoulator;
    }

    private void initGroupSpec() throws DataException {
        IQuery.GroupSpec[] groupSpecs = this.query.getGrouping();
        if (groupSpecs != null) {
            this.groupDefs = new GroupBy[groupSpecs.length];
            int i = 0;
            while (i < groupSpecs.length) {
                int keyIndex = groupSpecs[i].getKeyIndex();
                String keyColumn = groupSpecs[i].getKeyColumn();
                if (keyColumn != null) {
                    keyIndex = this.rsMeta.getFieldIndex(keyColumn);
                }
                if (keyIndex < 1 || keyIndex > this.rsMeta.getFieldCount()) {
                    throw new DataException("data.engine.InvalidGroupKeyName", keyColumn);
                }
                this.groupDefs[i] = GroupBy.newInstance(groupSpecs[i], keyIndex, keyColumn, this.rsMeta.getFieldValueClass(keyIndex));
                ++i;
            }
        } else {
            this.groupDefs = new GroupBy[0];
        }
    }

    public SortSpec getSortSpec() throws DataException {
        assert (this.groupDefs != null);
        int groupCount = 0;
        int sortCount = 0;
        int i = 0;
        while (i < this.groupDefs.length) {
            if (this.groupDefs[i].getColumnIndex() >= 0) {
                ++groupCount;
            }
            ++i;
        }
        if (this.query.getOrdering() != null) {
            sortCount = this.query.getOrdering().length;
        }
        boolean doGroupSort = false;
        int i2 = 0;
        while (i2 < groupCount) {
            if (this.groupDefs[i2].getGroupSpec().getSortDirection() != -1) {
                doGroupSort = true;
                break;
            }
            ++i2;
        }
        if (!doGroupSort && !this.needSortingOnGroupKeys()) {
            groupCount = 0;
        }
        int[] sortKeyIndexes = new int[groupCount + sortCount];
        String[] sortKeyColumns = new String[groupCount + sortCount];
        int[] sortAscending = new int[groupCount + sortCount];
        CompareHints[] comparator = new CompareHints[groupCount + sortCount];
        int i3 = 0;
        while (i3 < groupCount) {
            int index = this.groupDefs[i3].getColumnIndex();
            if (index >= 0) {
                sortKeyIndexes[i3] = this.groupDefs[i3].getColumnIndex();
                sortKeyColumns[i3] = this.groupDefs[i3].getColumnName();
                sortAscending[i3] = this.groupDefs[i3].getGroupSpec().getSortDirection();
                comparator[i3] = null;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < sortCount) {
            int keyIndex = this.query.getOrdering()[i3].getIndex();
            String keyName = this.query.getOrdering()[i3].getField();
            if (keyName != null) {
                keyIndex = this.rsMeta.getFieldIndex(keyName);
            }
            sortKeyIndexes[groupCount + i3] = keyIndex;
            sortKeyColumns[groupCount + i3] = keyName;
            sortAscending[groupCount + i3] = this.query.getOrdering()[i3].isAscendingOrder() ? 0 : 1;
            comparator[groupCount + i3] = new CompareHints(this.query.getOrdering()[i3].getComparator(), null);
            ++i3;
        }
        return new SortSpec(sortKeyIndexes, sortKeyColumns, sortAscending, comparator);
    }

    private boolean needSortingOnGroupKeys() {
        List groups = this.query.getQueryDefinition().getGroups();
        List sorts = this.query.getQueryDefinition().getSorts();
        if (sorts == null || sorts.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < groups.size() && i < sorts.size()) {
            String sortKey;
            String groupKey = ((IGroupDefinition)groups.get(i)).getKeyColumn() != null ? ExpressionUtil.createJSRowExpression((String)((IGroupDefinition)groups.get(i)).getKeyColumn()) : ((IGroupDefinition)groups.get(i)).getKeyExpression();
            String string = sortKey = ((ISortDefinition)sorts.get(i)).getColumn() != null ? ExpressionUtil.createJSRowExpression((String)((ISortDefinition)sorts.get(i)).getColumn()) : ((ISortDefinition)sorts.get(i)).getExpression().getText();
            if (!groupKey.equals(sortKey)) break;
            ++i;
        }
        return i != groups.size();
    }
}

