/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class LayoutMeasuresProvider
extends AbstractDescriptorProvider {
    protected Object input;
    protected CrosstabReportItemHandle crosstabHandle;
    protected static final Logger logger = Logger.getLogger(LayoutMeasuresProvider.class.getName());

    public String getDisplayName() {
        return Messages.getString("LayoutMeasuresProvider.DisplayName");
    }

    public Object load() {
        String vertical = "vertical";
        if (this.input == null) {
            return "false";
        }
        if (this.crosstabHandle == null) {
            this.initializeCrosstab();
        }
        if (this.crosstabHandle != null) {
            vertical = this.crosstabHandle.getMeasureDirection();
        }
        return vertical.equals("vertical") ? "true" : "false";
    }

    public void save(Object value) throws SemanticException {
        String stringValue = (String)value;
        if (this.input == null) {
            return;
        }
        if (this.crosstabHandle == null) {
            this.initializeCrosstab();
        }
        if (stringValue != null && stringValue.equalsIgnoreCase("true")) {
            this.crosstabHandle.setMeasureDirection("vertical");
        } else {
            this.crosstabHandle.setMeasureDirection("horizontal");
        }
    }

    public void setInput(Object input) {
        this.input = input;
        this.initializeCrosstab();
    }

    protected void initializeCrosstab() {
        this.crosstabHandle = null;
        if (!(this.input != null && (this.input instanceof List && ((List)this.input).size() > 0 && ((List)this.input).get(0) instanceof ExtendedItemHandle || this.input instanceof ExtendedItemHandle))) {
            return;
        }
        ExtendedItemHandle handle = ((List)this.input).size() > 0 ? (ExtendedItemHandle)((List)this.input).get(0) : (ExtendedItemHandle)this.input;
        try {
            this.crosstabHandle = (CrosstabReportItemHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }
}

