/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DiskDataSetCacheObject
implements IDataSetCacheObject {
    private String cacheDir;
    private static Integer count = 0;
    private int cacheCapability;

    public DiskDataSetCacheObject(String cacheDir, int cacheCapability) {
        assert (cacheCapability > 0);
        this.cacheDir = cacheDir.endsWith(File.separator) ? String.valueOf(cacheDir) + "DataSetCacheObject_" + this.hashCode() + "_" + this.getCount() : String.valueOf(cacheDir) + File.separator + "DataSetCacheObject_" + this.hashCode() + "_" + this.getCount();
        FileSecurity.fileMakeDirs(new File(this.cacheDir));
        this.cacheCapability = cacheCapability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount() {
        Integer n = count;
        synchronized (n) {
            count = (count + 1) % 100000;
            return count;
        }
    }

    public File getDataFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "data.data");
    }

    public File getMetaFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "meta.data");
    }

    @Override
    public boolean isCachedDataReusable(int requiredCapability) {
        assert (requiredCapability > 0);
        return FileSecurity.fileExist(this.getMetaFile()) && this.cacheCapability >= requiredCapability;
    }

    @Override
    public boolean needUpdateCache(int requiredCapability) {
        return !this.isCachedDataReusable(requiredCapability);
    }

    @Override
    public void release() {
        DataSetCacheUtil.deleteFile(this.cacheDir);
    }

    @Override
    public IResultClass getResultClass() throws DataException {
        FileInputStream fis1 = null;
        BufferedInputStream bis1 = null;
        try {
            fis1 = FileSecurity.createFileInputStream(this.getMetaFile());
            bis1 = new BufferedInputStream(fis1);
            IOUtil.readInt((InputStream)bis1);
            ResultClass rsClass = new ResultClass(bis1, 0);
            bis1.close();
            fis1.close();
            return rsClass;
        }
        catch (IOException e) {
            throw new DataException("data.engine.datasetcache.load.error", e);
        }
    }

    public String getCacheDir() {
        return this.cacheDir;
    }
}

