/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.model.RowsImpl;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.MultigetSubSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSubSliceQuery<K, SN, N, V>
extends AbstractSliceQuery<K, N, V, Rows<K, N, V>>
implements MultigetSubSliceQuery<K, SN, N, V> {
    private Collection<K> keys;
    private final Serializer<SN> sNameSerializer;
    private SN superColumn;

    public ThriftMultigetSubSliceQuery(Keyspace k, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(k, keySerializer, nameSerializer, valueSerializer);
        Assert.notNull(nameSerializer, "sNameSerializer can't be null");
        this.sNameSerializer = sNameSerializer;
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setKeys(Collection<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setSuperColumn(SN superColumn) {
        Assert.notNull(superColumn, "supercolumn may not be null");
        this.superColumn = superColumn;
        return this;
    }

    @Override
    public QueryResult<Rows<K, N, V>> execute() {
        Assert.noneNull(this.keys, "Keys cannot be null");
        Assert.noneNull(this.columnFamilyName, "columnFamilyName cannot be null");
        Assert.noneNull(this.superColumn, "superColumn cannot be null");
        return new QueryResultImpl<Rows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<Rows<K, N, V>>(){

            @Override
            public Rows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList keysList = new ArrayList();
                keysList.addAll(ThriftMultigetSubSliceQuery.this.keys);
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSubSliceQuery.this.columnFamilyName);
                columnParent.setSuper_column(ThriftMultigetSubSliceQuery.this.sNameSerializer.toByteBuffer(ThriftMultigetSubSliceQuery.this.superColumn));
                Map thriftRet = ThriftMultigetSubSliceQuery.this.keySerializer.fromBytesMap(ks.multigetSlice(ThriftMultigetSubSliceQuery.this.keySerializer.toBytesList(keysList), columnParent, ThriftMultigetSubSliceQuery.this.getPredicate()));
                return new RowsImpl(thriftRet, ThriftMultigetSubSliceQuery.this.columnNameSerializer, ThriftMultigetSubSliceQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSubSliceQuery(" + this.superColumn + "," + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setColumnFamily(String cf) {
        return (MultigetSubSliceQuery)super.setColumnFamily(cf);
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setRange(N start, N finish, boolean reversed, int count) {
        return (MultigetSubSliceQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setColumnNames(N ... columnNames) {
        return (MultigetSubSliceQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSubSliceQuery<K, SN, N, V> setColumnNames(Collection<N> columnNames) {
        return (MultigetSubSliceQuery)super.setColumnNames(columnNames);
    }
}

