/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;

public class ThriftFactory {
    public static <N> ColumnPath createColumnPath(String columnFamilyName, N columnName, Serializer<N> nameSerializer) {
        return ThriftFactory.createColumnPath(columnFamilyName, nameSerializer.toByteBuffer(columnName));
    }

    private static <N> ColumnPath createColumnPath(String columnFamilyName, ByteBuffer columnName) {
        Assert.notNull(columnFamilyName, "columnFamilyName cannot be null");
        ColumnPath columnPath = new ColumnPath(columnFamilyName);
        if (columnName != null) {
            columnPath.setColumn(columnName);
        }
        return columnPath;
    }

    static <N> ColumnPath createColumnPath(String columnFamilyName) {
        return ThriftFactory.createColumnPath(columnFamilyName, null);
    }

    public static <SN, N> ColumnPath createSuperColumnPath(String columnFamilyName, SN superColumnName, N columnName, Serializer<SN> superNameSerializer, Serializer<N> nameSerializer) {
        Assert.noneNull(columnFamilyName, superColumnName, superNameSerializer, nameSerializer);
        ColumnPath columnPath = ThriftFactory.createColumnPath(columnFamilyName, nameSerializer.toByteBuffer(columnName));
        columnPath.setSuper_column(superNameSerializer.toByteBuffer(superColumnName));
        return columnPath;
    }

    public static <SN> ColumnPath createSuperColumnPath(String columnFamilyName, SN superColumnName, Serializer<SN> superNameSerializer) {
        Assert.noneNull(columnFamilyName, superNameSerializer);
        ColumnPath columnPath = ThriftFactory.createColumnPath(columnFamilyName, null);
        if (superColumnName != null) {
            columnPath.setSuper_column(superNameSerializer.toByteBuffer(superColumnName));
        }
        return columnPath;
    }

    public static CounterColumn createCounterColumn(String name, long value) {
        CounterColumn cc = new CounterColumn();
        cc.setName(StringSerializer.get().toByteBuffer(name));
        cc.setValue(value);
        return cc;
    }

    public static <N> CounterColumn createCounterColumn(N name, long value, Serializer<N> ns) {
        CounterColumn cc = new CounterColumn();
        cc.setName(ns.toByteBuffer(name));
        cc.setValue(value);
        return cc;
    }
}

