/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model.xml;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.genericeditor.target.extension.model.DependencyNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.XMLElement;

public class Parser {
    private static Parser instance;
    private Node target;
    private XMLInputFactory inputFactory;

    public Parser() {
        this.initializeParser();
    }

    private void initializeParser() {
        this.inputFactory = XMLInputFactory.newInstance();
    }

    public void parse(IDocument document) throws XMLStreamException {
        this.target = null;
        Node currentParent = null;
        Node currentNode = null;
        Iterator<XMLElement> tagReaderIterator = this.createXMLTagItterator(document.get());
        while (tagReaderIterator.hasNext()) {
            XMLElement event = tagReaderIterator.next();
            if (event.isStartElement()) {
                String name = event.getName();
                if ("unit".equalsIgnoreCase(name)) {
                    String versionValue;
                    UnitNode unit = new UnitNode();
                    String unitValue = event.getAttributeValueByKey("id");
                    if (unitValue != null) {
                        unit.setId(unitValue);
                    }
                    if ((versionValue = event.getAttributeValueByKey("version")) != null) {
                        unit.setVersion(versionValue);
                    }
                    currentNode = unit;
                } else if ("location".equalsIgnoreCase(name)) {
                    currentNode = new LocationNode();
                } else if ("dependency".equalsIgnoreCase(name)) {
                    currentNode = new DependencyNode();
                } else if ("repository".equalsIgnoreCase(name)) {
                    currentNode = new Node();
                    if (currentParent instanceof LocationNode) {
                        String locationValue = event.getAttributeValueByKey("location");
                        ((LocationNode)currentParent).setRepositoryLocation(locationValue);
                    }
                } else {
                    currentNode = "target".equalsIgnoreCase(name) ? (this.target = new Node()) : new Node();
                }
                currentNode.setNodeTag(name);
                currentNode.setOffsetStart(event.getStartOffset());
                if (currentParent != null) {
                    currentParent.addChildNode(currentNode);
                }
                currentParent = currentNode;
            }
            if (!event.isEndElement() || currentNode == null) continue;
            currentNode.setOffsetEnd(event.getEndOffset());
            currentParent = currentNode = currentNode.getParentNode();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(document.get().getBytes());
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(inputStream);
        while (eventReader.hasNext()) {
            eventReader.nextEvent();
        }
    }

    private Iterator<XMLElement> createXMLTagItterator(final String document) {
        return new Iterator<XMLElement>(){
            private String tagRegex = "(?<tag><[\\w|/][^<]+?>)";
            private String commentRegex = "(<!--.*?-->)";
            private String beforeTagRegex = ".*?(?=".concat(this.tagRegex).concat(")");
            private String text;
            private Pattern tagPattern;
            private Pattern commentPattern;
            private Pattern beforeTagPattern;
            {
                this.text = string;
                this.tagPattern = Pattern.compile(this.tagRegex, 32);
                this.commentPattern = Pattern.compile(this.commentRegex, 32);
                this.beforeTagPattern = Pattern.compile(this.beforeTagRegex, 32);
            }

            @Override
            public boolean hasNext() {
                this.skipComments();
                return this.text.length() > 0 && this.beforeTagPattern.matcher(this.text).find();
            }

            @Override
            public XMLElement next() {
                this.skipComments();
                this.text = this.beforeTagPattern.matcher(this.text).replaceFirst("");
                Matcher tag = this.tagPattern.matcher(this.text);
                tag.find();
                int offset = document.length() - this.text.length();
                this.text = this.text.substring(tag.end());
                return new XMLElement(tag.group("tag"), offset);
            }

            private void skipComments() {
                Matcher comment = this.commentPattern.matcher(this.text);
                Matcher tag = this.tagPattern.matcher(this.text);
                if (comment.find() && tag.find() && comment.start() < tag.start()) {
                    this.text = this.text.substring(comment.end());
                }
            }
        };
    }

    public static Parser getDefault() {
        if (instance == null) {
            instance = new Parser();
        }
        return instance;
    }

    public Node getRootNode() {
        return this.target;
    }
}

