/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum EntityProperty {
    SIMULATION_DURATION("time"),
    INITIAL_VALUE("object"),
    PROCESSORS("entityIdRef"),
    CORES("entityIdRef"),
    SYSTEM_START_TIME("time"),
    FREQUENCY_IN_HZ("long"),
    STIMULI("entityIdRef"),
    EXECUTING_CORE("entityIdRef"),
    RUNNABLES("entityIdRef"),
    READ_SIGNALS("entityIdRef"),
    WRITTEN_SIGNALS("entityIdRef"),
    SYSTEM_STOP_TIME("time"),
    EC_ITEMS("entityIdRef"),
    EC_STIMULUS("eventIdRef"),
    EC_RESPONSE("eventIdRef"),
    EC_MIN_ITEMS_COMPLETED("long");

    public static final List<EntityProperty> eventChainProperties;
    public final String camelName;
    public final String type;

    static {
        eventChainProperties = Collections.unmodifiableList(Arrays.asList(EC_ITEMS, EC_STIMULUS, EC_RESPONSE, EC_MIN_ITEMS_COMPLETED));
    }

    private EntityProperty(String type) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.name().toLowerCase().toLowerCase().split("_");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String oneString = stringArray[n3];
            sb.append(sb.length() > 0 ? oneString.substring(0, 1).toUpperCase() : oneString.substring(0, 1));
            sb.append(oneString.substring(1));
            ++n3;
        }
        this.camelName = sb.toString();
        this.type = type;
    }

    public String toString() {
        return this.camelName;
    }
}

