/*********************************************************************************
 * Copyright (c) 2021 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */ 

package org.eclipse.app4mc.amalthea.model.editor.contribution.service.creation;

import javax.annotation.PostConstruct;

import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.editor.contribution.service.CreationService;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers.Algorithm;
import org.osgi.service.component.annotations.Component;

@Component(
		property = {
			"name = Scheduler Definition | Reservation Based Server | Deferrable Server",
			"description = Creates an DeferrableServer scheduler definition" },
		service = CreationService.class)

public class SchedulerDefinitionDeferrableServer extends AbstractSchedulerDefinitionCreationService {

	@PostConstruct
	public void create(OSModel osModel) {
		doCreate(osModel, Algorithm.DEFERRABLE_SERVER, "Create DeferrableServer scheduler definition");
	}

}
