/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.GrammarFormatter;
import org.eclipse.xtext.util.formallang.GrammarUtil2;
import org.eclipse.xtext.util.formallang.IGrammarAdapter;
import org.eclipse.xtext.util.formallang.IGrammarFactory;
import org.eclipse.xtext.util.formallang.INfaAdapter;
import org.eclipse.xtext.util.formallang.ITokenAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaToGrammar {
    protected <T> void collectStates(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            this.collectStates(out, visited);
        }
    }

    protected <T> boolean createAlternative(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        HashMultimap alternative = HashMultimap.create();
        for (StateAlias<T> stateAlias : state.getOutgoing()) {
            if (stateAlias.getOutgoing().size() != 1 || stateAlias.getIncoming().size() != 1) continue;
            for (StateAlias<T> candidate2 : state.getOutgoing()) {
                if (candidate2.getOutgoing().size() != 1 || candidate2.getIncoming().size() != 1) continue;
                for (StateAlias stateAlias2 : stateAlias.getOutgoing()) {
                    if (stateAlias == candidate2 || !candidate2.getOutgoing().contains(stateAlias2)) continue;
                    alternative.put((Object)stateAlias2, stateAlias);
                    alternative.put((Object)stateAlias2, candidate2);
                }
            }
        }
        for (StateAlias<Object> stateAlias : alternative.keySet()) {
            AlternativeAlias alt = new AlternativeAlias();
            StateAlias altState = new StateAlias(alt);
            for (StateAlias stateAlias3 : alternative.get(stateAlias)) {
                alt.addChild(stateAlias3.getElement());
                state.getOutgoing().remove(stateAlias3);
                stateAlias.getIncoming().remove(stateAlias3);
            }
            altState.getIncoming().add(state);
            altState.getOutgoing().add(stateAlias);
            state.getOutgoing().add(altState);
            stateAlias.getIncoming().add(altState);
            created = true;
        }
        for (StateAlias<Object> stateAlias : state.getOutgoing()) {
            if (!this.createAlternative(stateAlias, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createCycle(StateAlias<T> state, Set<StateAlias<T>> visited) {
        StateAlias<T> center;
        if (!visited.add(state)) {
            return false;
        }
        if (state.getOutgoing().size() == 1 && state.getIncoming().size() == 1 && (center = state.getOutgoing().iterator().next()) != state && center == state.getIncoming().iterator().next()) {
            GroupAlias<T> cycle = new GroupAlias<T>();
            cycle.addChild(state.getElement());
            cycle.addChild(center.getElement());
            cycle.setMany(true);
            cycle.setOptional(true);
            GroupAlias group = new GroupAlias();
            group.addChild(center.getElement());
            group.addChild(cycle);
            center.element = group;
            center.getOutgoing().remove(state);
            center.getIncoming().remove(state);
            return true;
        }
        boolean created = false;
        for (StateAlias out : Lists.newArrayList(state.getOutgoing())) {
            if (!this.createCycle(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> void createGroup(StateAlias<T> first, StateAlias<T> second) {
        GroupAlias group = new GroupAlias();
        if (first.getElement() instanceof GroupAlias && first.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)first.getElement()).getChildren());
        } else {
            group.addChild(first.getElement());
        }
        if (second.getElement() instanceof GroupAlias && second.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)second.getElement()).getChildren());
        } else {
            group.addChild(second.getElement());
        }
        first.element = group;
        first.getOutgoing().clear();
        first.absorbOutgoing(second);
    }

    protected <T> boolean createGroups(StateAlias<T> state, Set<StateAlias<T>> visited) {
        StateAlias<T> follower;
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().size() == 1 && state.getOutgoing().iterator().next().getIncoming().size() == 1 && state != (follower = state.getOutgoing().iterator().next())) {
            this.createGroup(state, follower);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createGroups(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createMany(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().contains(state)) {
            state.getElement().setMany(true);
            state.getOutgoing().remove(state);
            state.getIncoming().remove(state);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createMany(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createOptional(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        StateAlias<T> optional = null;
        for (StateAlias<T> stateAlias : state.getOutgoing()) {
            if (stateAlias.getIncoming().size() != 1 || stateAlias.getOutgoing().size() <= 0) continue;
            HashSet allOut = Sets.newHashSet();
            allOut.add(stateAlias);
            allOut.addAll(stateAlias.getOutgoing());
            if (!state.getOutgoing().equals(allOut)) continue;
            optional = stateAlias;
            break;
        }
        if (optional != null) {
            optional.getElement().setOptional(true);
            if (state.getElement() instanceof GroupAlias && state.getElement().isOne()) {
                GroupAlias groupAlias = (GroupAlias)state.getElement();
                groupAlias.addChild(optional.getElement());
            } else {
                GroupAlias groupAlias = new GroupAlias();
                groupAlias.addChild(state.getElement());
                groupAlias.addChild(optional.getElement());
                state.element = groupAlias;
            }
            state.getOutgoing().remove(optional);
            for (StateAlias<Object> stateAlias : optional.getOutgoing()) {
                stateAlias.getIncoming().remove(optional);
            }
            optional.getIncoming().clear();
            optional.getOutgoing().clear();
            created = true;
        }
        for (StateAlias<T> stateAlias : state.getOutgoing()) {
            if (!this.createOptional(stateAlias, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> Set<StateAlias<T>> getAllStates(StateAlias<T> state) {
        HashSet visited = Sets.newHashSet();
        this.collectStates(state, visited);
        return visited;
    }

    public <ELEMENT, STATE, TOKEN, NFA extends INfaAdapter<STATE> & ITokenAdapter<STATE, TOKEN>> ELEMENT nfaToGrammar(NFA nfa, IGrammarFactory<ELEMENT, TOKEN> grammarFactory) {
        StateAlias<Object> stop = new StateAlias<Object>(new ElementAlias<Object>(null));
        StateAlias<Object> start = new StateAlias<Object>(new ElementAlias<Object>(null));
        HashSet stops = Sets.newHashSet(nfa.getFinalStates());
        HashMap cache = Maps.newHashMap();
        for (STATE state : nfa.getStartStates()) {
            StateAlias<Object> stateAlias = this.toAlias(nfa, state, stops, stop, cache);
            start.getOutgoing().add(stateAlias);
            stateAlias.getIncoming().add(start);
        }
        boolean changed = true;
        while (!start.getOutgoing().isEmpty() && changed) {
            changed = this.createMany(start, Sets.newHashSet());
            changed |= this.createGroups(start, Sets.newHashSet());
            changed |= this.createAlternative(start, Sets.newHashSet());
            changed |= this.createOptional(start, Sets.newHashSet());
            changed |= this.createCycle(start, Sets.newHashSet());
        }
        if (start.getElement() instanceof GroupAlias) {
            GroupAlias result = (GroupAlias)start.getElement();
            result.getChildren().remove(0);
            result.getChildren().remove(result.getChildren().size() - 1);
            GrammarUtil2<AbstractElementAlias<Object>, TOKEN> util = GrammarUtil2.newUtil(new AliasGrammarProvider());
            return util.clone(start.getElement(), grammarFactory);
        }
        return null;
    }

    protected <STATE, TOKEN, NFA extends INfaAdapter<STATE> & ITokenAdapter<STATE, TOKEN>> StateAlias<TOKEN> toAlias(NFA nfa, STATE state, Set<STATE> stops, StateAlias<TOKEN> stop, Map<STATE, StateAlias<TOKEN>> cache) {
        StateAlias<TOKEN> result = cache.get(state);
        if (result != null) {
            return result;
        }
        result = new StateAlias<TOKEN>(new ElementAlias<TOKEN>(((ITokenAdapter<STATE, TOKEN>)nfa).getToken(state)));
        cache.put(state, result);
        if (stops.contains(state)) {
            stop.getIncoming().add(result);
            result.getOutgoing().add(stop);
        }
        for (STATE follower : nfa.getFollowers(state)) {
            StateAlias<TOKEN> followerState = this.toAlias(nfa, follower, stops, stop, cache);
            result.getOutgoing().add(followerState);
            followerState.getIncoming().add(result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractElementAlias<T> {
        protected boolean many = false;
        protected boolean optional = false;

        protected AbstractElementAlias() {
        }

        protected AbstractElementAlias(boolean optional, boolean many) {
            this.optional = optional;
            this.many = many;
        }

        public boolean isMany() {
            return this.many;
        }

        public boolean isOne() {
            return !this.optional && !this.many;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setMany(boolean many) {
            this.many = many;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            return GrammarFormatter.newFormatter(new AliasGrammarProvider()).format(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AliasGrammarProvider<TOKEN>
    implements IGrammarAdapter<AbstractElementAlias<TOKEN>, TOKEN> {
        protected AliasGrammarProvider() {
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getAlternativeChildren(AbstractElementAlias<TOKEN> ele) {
            return ele instanceof AlternativeAlias ? ((AlternativeAlias)ele).getChildren() : null;
        }

        @Override
        public AbstractElementAlias<TOKEN> getParent(AbstractElementAlias<TOKEN> ele) {
            return null;
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getSequentialChildren(AbstractElementAlias<TOKEN> ele) {
            return ele instanceof GroupAlias ? ((GroupAlias)ele).getChildren() : null;
        }

        @Override
        public TOKEN getToken(AbstractElementAlias<TOKEN> owner) {
            return owner instanceof ElementAlias ? (TOKEN)((ElementAlias)owner).getElement() : null;
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getUnorderedChildren(AbstractElementAlias<TOKEN> ele) {
            return null;
        }

        @Override
        public boolean isMany(AbstractElementAlias<TOKEN> ele) {
            return ele.isMany();
        }

        @Override
        public boolean isOptional(AbstractElementAlias<TOKEN> ele) {
            return ele.isOptional();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AlternativeAlias<T>
    extends AbstractElementAlias<T> {
        protected Set<AbstractElementAlias<T>> children = Sets.newHashSet();

        public AlternativeAlias() {
        }

        public AlternativeAlias(boolean optional, boolean many, AbstractElementAlias<T> ... children) {
            super(optional, many);
            Collections.addAll(this.children, children);
        }

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        public Set<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ElementAlias<T>
    extends AbstractElementAlias<T> {
        protected T element;

        public ElementAlias(boolean optional, boolean many, T element) {
            super(optional, many);
            this.element = element;
        }

        public ElementAlias(T element) {
            this.element = element;
        }

        public T getElement() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GroupAlias<T>
    extends AbstractElementAlias<T> {
        protected List<AbstractElementAlias<T>> children = Lists.newArrayList();

        public GroupAlias() {
        }

        public GroupAlias(boolean optional, boolean many, AbstractElementAlias<T> ... children) {
            super(optional, many);
            Collections.addAll(this.children, children);
        }

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        public List<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StateAlias<TOKEN> {
        protected AbstractElementAlias<TOKEN> element;
        protected Set<StateAlias<TOKEN>> incoming = Sets.newHashSet();
        protected Set<StateAlias<TOKEN>> outgoing = Sets.newHashSet();

        protected StateAlias(AbstractElementAlias<TOKEN> element) {
            this.element = element;
        }

        public void absorbIncoming(StateAlias<TOKEN> state) {
            for (StateAlias<TOKEN> in : state.incoming) {
                in.outgoing.remove(state);
                in.outgoing.add(this);
                this.incoming.add(in);
            }
        }

        public void absorbOutgoing(StateAlias<TOKEN> state) {
            for (StateAlias<TOKEN> out : state.outgoing) {
                out.incoming.remove(state);
                out.incoming.add(this);
                this.outgoing.add(out);
            }
        }

        public void addOutgoing(StateAlias<TOKEN> state) {
            this.outgoing.add(state);
            state.incoming.add(this);
        }

        protected AbstractElementAlias<TOKEN> getElement() {
            return this.element;
        }

        protected Set<StateAlias<TOKEN>> getIncoming() {
            return this.incoming;
        }

        protected Set<StateAlias<TOKEN>> getOutgoing() {
            return this.outgoing;
        }

        public String toString() {
            return "S(" + this.element + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StatesToDot<T>
    extends GraphvizDotBuilder {
        protected StatesToDot() {
        }

        @Override
        protected GraphvizDotBuilder.Props drawObject(Object obj) {
            if (obj instanceof StateAlias) {
                GraphvizDotBuilder.Digraph dg = new GraphvizDotBuilder.Digraph();
                this.drawState(dg, (StateAlias)obj, Maps.newHashMap());
                return dg;
            }
            return null;
        }

        protected GraphvizDotBuilder.Node drawState(GraphvizDotBuilder.Digraph dg, StateAlias<T> state, Map<StateAlias<T>, GraphvizDotBuilder.Node> nodes) {
            GraphvizDotBuilder.Node n = nodes.get(state);
            if (n != null) {
                return n;
            }
            n = new GraphvizDotBuilder.Node(state, state.getElement().toString());
            nodes.put(state, n);
            dg.add(n);
            for (StateAlias<T> follower : state.getOutgoing()) {
                this.drawState(dg, follower, nodes);
                GraphvizDotBuilder.Edge e = new GraphvizDotBuilder.Edge(state, follower);
                e.put("arrowhead", "onormal");
                dg.add(e);
            }
            return n;
        }
    }
}

