/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMarkersOperation
extends WorkspaceModifyOperation {
    private static final Logger log = Logger.getLogger(AddMarkersOperation.class);
    private final List<Issue> issues;
    private final IResource resource;
    private final boolean deleteMarkers;
    private final ImmutableList<String> markerIds;
    private MarkerCreator markerCreator;

    @Deprecated
    public AddMarkersOperation(IResource resource, List<Issue> issues, String markerId, boolean deleteMarkers, MarkerCreator markerCreator) {
        this(resource, issues, Collections.singleton(markerId), deleteMarkers, markerCreator);
    }

    public AddMarkersOperation(IResource resource, List<Issue> issues, Set<String> markerIds, boolean deleteMarkers, MarkerCreator markerCreator) {
        super(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource));
        this.issues = issues;
        this.markerIds = ImmutableList.copyOf(markerIds);
        this.resource = resource;
        this.deleteMarkers = deleteMarkers;
        this.markerCreator = markerCreator;
    }

    @Deprecated
    public String getMarkerId() {
        if (this.markerIds.isEmpty()) {
            return null;
        }
        return (String)this.markerIds.iterator().next();
    }

    public ImmutableList<String> getMarkerIds() {
        return this.markerIds;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (!this.resource.exists()) {
            return;
        }
        if (this.deleteMarkers) {
            for (String markerId : this.getMarkerIds()) {
                this.resource.deleteMarkers(markerId, false, 2);
            }
        }
        if (!this.issues.isEmpty()) {
            for (Issue issue : this.issues) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.markerCreator.createMarker(issue, this.resource, MarkerTypes.forCheckType(issue.getType()));
            }
        }
    }
}

