/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Widget;

class LabelRequestMonitor
extends AsynchronousRequestMonitor
implements ILabelRequestMonitor {
    private String[] fLabels;
    private ImageDescriptor[] fImageDescriptors;
    private FontData[] fFontDatas;
    private RGB[] fForegrounds;
    private RGB[] fBackgrounds;

    public LabelRequestMonitor(ModelNode node, AsynchronousModel model) {
        super(node, model);
    }

    protected void performUpdate() {
        AsynchronousViewer viewer = this.getModel().getViewer();
        Widget widget = viewer.findItem(this.getNode());
        if (widget != null && !widget.isDisposed()) {
            viewer.setLabels(widget, this.fLabels, this.fImageDescriptors);
            viewer.setColors(widget, this.fForegrounds, this.fBackgrounds);
            viewer.setFonts(widget, this.fFontDatas);
        }
    }

    protected boolean contains(AsynchronousRequestMonitor update) {
        return update instanceof LabelRequestMonitor && update.getNode() == this.getNode();
    }

    public void setLabels(String[] text) {
        this.fLabels = text;
    }

    public void setFontDatas(FontData[] fontData) {
        this.fFontDatas = fontData;
    }

    public void setImageDescriptors(ImageDescriptor[] image) {
        this.fImageDescriptors = image;
    }

    public void setForegrounds(RGB[] foreground) {
        this.fForegrounds = foreground;
    }

    public void setBackgrounds(RGB[] background) {
        this.fBackgrounds = background;
    }

    protected RGB[] getBackgrounds() {
        return this.fBackgrounds;
    }

    protected RGB[] getForegrounds() {
        return this.fForegrounds;
    }

    protected FontData[] getFontDatas() {
        return this.fFontDatas;
    }

    protected String[] getLabels() {
        return this.fLabels;
    }

    protected ImageDescriptor[] getImageDescriptors() {
        return this.fImageDescriptors;
    }
}

