/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.ascape.model.Agent;
import org.ascape.model.LocatedAgent;
import org.ascape.util.VectorSelection;
import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.ColorFeatureConcrete;
import org.ascape.util.vis.DrawFeature;
import org.ascape.util.vis.DrawFeatureSelection;
import org.ascape.util.vis.IDrawSelection;
import org.ascape.view.vis.DrawFeatureObservable;
import org.ascape.view.vis.GraphicsView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AgentView
extends GraphicsView
implements IDrawSelection,
Observer {
    private static final long serialVersionUID = 2123024822872459897L;
    private Vector<DrawFeature> viewDrawFeatures;
    private Vector<DrawFeature> allDrawFeatures;
    protected VectorSelection drawSelection;
    private DrawFeatureObservable drawFeatureObservable = new DrawFeatureObservable();
    protected ColorFeature agentColorFeature;

    public AgentView() {
        this("Base View");
    }

    public AgentView(String name) {
        super(name);
        this.viewDrawFeatures = new Vector();
    }

    protected Observable getDrawFeaturesObservable() {
        return this.drawFeatureObservable;
    }

    public void createFeatures() {
        if (this.agentColorFeature == null) {
            this.agentColorFeature = new ColorFeatureConcrete("Default Agent Color"){
                private static final long serialVersionUID = -3220486698290440285L;

                public Color getColor(Object object) {
                    return (Color)((Agent)object).getPlatformColor();
                }
            };
        }
    }

    public void addDrawFeature(DrawFeature feature) {
        for (DrawFeature drawFeature : this.viewDrawFeatures) {
            if (!drawFeature.getName().equals(feature.getName())) continue;
            return;
        }
        this.viewDrawFeatures.addElement(feature);
        this.updateDrawFeatures();
        this.drawFeatureObservable.setChanged();
        this.drawFeatureObservable.notifyObservers();
    }

    public boolean removeDrawFeature(DrawFeature feature) {
        DrawFeature found = null;
        for (DrawFeature drawFeature : this.viewDrawFeatures) {
            if (!drawFeature.getName().equals(feature.getName())) continue;
            found = feature;
        }
        if (found != null) {
            this.viewDrawFeatures.removeElement(feature);
            this.updateDrawFeatures();
            this.drawFeatureObservable.setChanged();
            this.drawFeatureObservable.notifyObservers();
            return true;
        }
        return false;
    }

    public Vector<DrawFeature> getDrawFeatures() {
        return this.allDrawFeatures;
    }

    private void updateDrawFeatures() {
        this.allDrawFeatures = new Vector(this.getScape().getDrawFeatures());
        this.allDrawFeatures.addAll(this.viewDrawFeatures);
        this.getDrawSelection().setVector(this.allDrawFeatures);
        this.getScape().requestUpdate();
    }

    @Override
    public VectorSelection getDrawSelection() {
        if (this.drawSelection == null) {
            this.drawSelection = new DrawFeatureSelection(this.getScape());
            this.getScape().getDrawFeaturesObservable().addObserver((Observer)this.drawSelection);
            this.getScape().getDrawFeaturesObservable().addObserver(this);
            this.updateDrawFeatures();
            this.drawFeatureObservable.setChanged();
            this.drawFeatureObservable.notifyObservers();
        }
        return this.drawSelection;
    }

    public ColorFeature getAgentColorFeature() {
        return this.agentColorFeature;
    }

    public void setAgentColorFeature(ColorFeature agentColorFeature) {
        this.agentColorFeature = agentColorFeature;
    }

    public Agent getAgentAtPixel(int x, int y) {
        return null;
    }

    protected void drawSelectedAgent(Graphics graphics, LocatedAgent a) {
    }

    public Dimension getPreferredSizeWithin(Dimension d) {
        int tempCellSize = this.calculateAgentSizeForViewSize(d);
        this.setAgentSize(tempCellSize);
        return this.calculateViewSizeForAgentSize(d, tempCellSize);
    }

    public Dimension getMiniumSizeWithin(Dimension d) {
        return this.calculateViewSizeForAgentSize(d, 1);
    }

    public Dimension calculateViewSizeForAgentSize(Dimension availableSize, int agentSize) {
        return new Dimension(500, 500);
    }

    public int calculateAgentSizeForViewSize(Dimension d) {
        return this.agentSize;
    }

    public int getAgentSize() {
        return this.agentSize;
    }

    public void setAgentSize(int cellSize) {
        this.agentSize = cellSize;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateDrawFeatures();
    }
}

