/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.ColorFeatureFixed;
import org.ascape.util.vis.DrawFeature;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;

public class DrawColorFeature
extends DrawFeature
implements ColorFeature {
    private static final long serialVersionUID = 1L;
    protected ColorFeature colorFeature = ColorFeatureFixed.black;

    public DrawColorFeature() {
    }

    public DrawColorFeature(String name) {
        super(name);
    }

    public DrawColorFeature(String name, ColorFeature colorFeature) {
        super(name);
        this.colorFeature = colorFeature;
    }

    public DrawColorFeature(String name, DrawFeature nestedFeature) {
        super(name, nestedFeature);
    }

    public DrawColorFeature(DrawFeature nestedFeature) {
        super(nestedFeature);
    }

    public void draw(Graphics g, Object object, int width, int height) {
        Color color = this.getColor(object);
        g.setForegroundColor(color);
        g.setBackgroundColor(color);
        this.nestedFeature.draw(g, object, width, height);
    }

    public final Color getColor(Object object) {
        return this.colorFeature.getColor(object);
    }

    public ColorFeature getColorFeature() {
        return this.colorFeature;
    }

    public void setColorFeature(ColorFeature colorFeature) {
        this.colorFeature = colorFeature;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.nestedFeature != null) {
            String candidateName = this.nestedFeature.getName();
            if (candidateName != "Unnamed") {
                return candidateName;
            }
            return this.colorFeature.getName();
        }
        if (this.colorFeature != null) {
            return this.colorFeature.getName();
        }
        return "Unnamed";
    }
}

