/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.LocatorHelper;
import org.eclipse.draw3d.PositionConstants3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class RelativeLocator3D
extends RelativeLocator {
    protected LocatorHelper m_helper;
    private static final Logger log = Logger.getLogger(RelativeLocator3D.class.getName());
    protected Vector3fImpl m_factors = new Vector3fImpl(0.0f, 0.0f, 0.0f);

    public RelativeLocator3D() {
    }

    public RelativeLocator3D(IFigure i_reference, double i_relativeX, double i_relativeY) {
        this(i_reference, i_relativeX, i_relativeY, 1.0);
    }

    public RelativeLocator3D(IFigure i_reference, double i_relativeX, double i_relativeY, double i_relativeZ) {
        super(i_reference, i_relativeX, i_relativeY);
        this.m_factors.set((float)i_relativeX, (float)i_relativeY, (float)i_relativeZ);
        this.m_helper = new LocatorHelper(i_reference);
    }

    public RelativeLocator3D(IFigure i_reference, int i_location) {
        this(i_reference, i_location, PositionConstants3D.ZMIDDLE);
    }

    public RelativeLocator3D(IFigure i_reference, int i_location, PositionConstants3D i_zlocation) {
        super(i_reference, i_location);
        switch (i_location & 5) {
            case 1: {
                this.m_factors.y = 0.0f;
                break;
            }
            case 4: {
                this.m_factors.y = 1.0f;
                break;
            }
            default: {
                this.m_factors.y = 0.5f;
            }
        }
        switch (i_location & 0x18) {
            case 8: {
                this.m_factors.x = 0.0f;
                break;
            }
            case 16: {
                this.m_factors.x = 1.0f;
                break;
            }
            default: {
                this.m_factors.x = 0.5f;
            }
        }
        switch (i_zlocation) {
            case FRONT: {
                this.m_factors.z = 1.0f;
                break;
            }
            case BACK: {
                this.m_factors.z = 0.0f;
                break;
            }
            default: {
                this.m_factors.z = 0.5f;
            }
        }
        this.m_helper = new LocatorHelper(i_reference);
    }

    public void relocate(IFigure i_target) {
        IFigure ref = this.getReferenceFigure();
        if (!(ref instanceof IFigure3D) && !(i_target instanceof IFigure3D)) {
            super.relocate(i_target);
        } else if (i_target instanceof IFigure3D) {
            Position3D targetPosition = Draw3DCache.getPosition3D();
            Vector3f location = Draw3DCache.getVector3f();
            Vector3f size = Draw3DCache.getVector3f();
            try {
                IFigure3D target3D = (IFigure3D)i_target;
                Position3D refPosition = this.m_helper.getReferencePosition3D();
                Math3D.scale((IVector3f)this.m_factors, (IVector3f)refPosition.getSize3D(), (Vector3f)location);
                Math3D.scale((float)0.5f, (IVector3f)target3D.getPreferredSize3D(), (Vector3f)size);
                Math3D.sub((IVector3f)location, (IVector3f)size, (Vector3f)location);
                Math3D.rotate((IVector3f)refPosition.getRotation3D(), (IVector3f)location, (Vector3f)location);
                Math3D.add((IVector3f)location, (IVector3f)refPosition.getLocation3D(), (Vector3f)location);
                refPosition.setLocation3D((IVector3f)location);
                refPosition.setSize3D(target3D.getPreferredSize3D());
                target3D.getPosition3D().setPosition((IPosition3D)refPosition);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{targetPosition});
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                throw throwable;
            }
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{targetPosition});
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
        } else {
            log.warning("Cannot position 2D Figure based on 3D reference, reference: " + ref + ", target: " + i_target);
        }
    }
}

