/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.Iterator;
import java.util.List;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Graph;
import org.ascape.model.space.Node;

public class GraphSmallWorld
extends Graph {
    private static final long serialVersionUID = 1L;
    private double randomEdgeRatio = 0.1;

    public GraphSmallWorld() {
    }

    public GraphSmallWorld(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public void initialize() {
        Node first;
        super.initialize();
        Iterator it = this.collection.iterator();
        Node prev = first = (Node)it.next();
        while (it.hasNext()) {
            Node cell = (Node)it.next();
            this.addNeighbor(cell, prev, false);
            if (!it.hasNext()) {
                this.addNeighbor(cell, first, false);
            }
            prev = cell;
        }
        if (this.randomEdgeRatio > 0.0) {
            for (Node cell : this.collection) {
                Node random;
                boolean tryAgain;
                if (!(this.getRandom().nextDouble() <= this.randomEdgeRatio)) continue;
                do {
                    tryAgain = false;
                    random = (Node)this.findRandom();
                    List neighbors = this.getNeighborsFor(cell);
                    if (cell == random) {
                        tryAgain = true;
                        continue;
                    }
                    if (!neighbors.contains(random)) continue;
                    tryAgain = true;
                } while (tryAgain);
                this.addNeighbor(cell, random);
            }
        }
    }

    public double getRandomEdgeRatio() {
        return this.randomEdgeRatio;
    }

    public void setRandomEdgeRatio(double randomEdgeRatio) {
        this.randomEdgeRatio = randomEdgeRatio;
    }
}

