/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.amp.agf.IPropertyChangeProvider;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class EditPartSourceProvider
implements IPropertySourceProvider {
    private Map<Object, IPropertySource> propertySources = new HashMap<Object, IPropertySource>();

    public void setPropertySources(Map<Object, IPropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    public Map<Object, IPropertySource> getPropertySources() {
        return this.propertySources;
    }

    public IPropertySource getPropertySource(Object object) {
        IPropertySource source = this.getPropertySources().get(object);
        if (source == null) {
            if (object instanceof EditPart) {
                final EditPart editPart = (EditPart)object;
                Object model = this.getSource(editPart);
                source = this.createPropertySource(model);
                ((IPropertyChangeProvider)source).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        editPart.refresh();
                    }
                });
            } else {
                source = this.createPropertySource(object);
            }
            this.getPropertySources().put(object, source);
        }
        return source;
    }

    private IPropertySource createPropertySource(Object model) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        return (IPropertySource)adapterManager.getAdapter(model, IPropertySource.class);
    }

    protected Object getSource(EditPart editPart) {
        return editPart.getModel();
    }
}

