/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionSynchronizer
implements ISelectionChangedListener {
    private List<ISelectionProvider> viewers = new ArrayList<ISelectionProvider>();
    private boolean isDispatching = false;
    private int disabled = 0;
    private ISelectionProvider pendingSelection;

    public void addViewer(ISelectionProvider viewer) {
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewers.add(viewer);
    }

    protected Object convert(ISelectionProvider viewer, Object object) {
        return object;
    }

    public void removeViewer(ISelectionProvider viewer) {
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.viewers.remove(viewer);
        if (this.pendingSelection == viewer) {
            this.pendingSelection = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        ISelectionProvider source = event.getSelectionProvider();
        if (this.disabled > 0) {
            this.pendingSelection = source;
        } else {
            ISelection selection = event.getSelection();
            this.syncSelection(source, selection);
        }
    }

    private void syncSelection(ISelectionProvider source, ISelection selection) {
        this.isDispatching = true;
        int i = 0;
        while (i < this.viewers.size()) {
            if (this.viewers.get(i) != source) {
                ISelectionProvider viewer = this.viewers.get(i);
                this.setViewerSelection(viewer, selection);
            }
            ++i;
        }
        this.isDispatching = false;
    }

    public void setEnabled(boolean value) {
        if (!value) {
            ++this.disabled;
        } else if (--this.disabled == 0 && this.pendingSelection != null) {
            this.syncSelection(this.pendingSelection, this.pendingSelection.getSelection());
            this.pendingSelection = null;
        }
    }

    private void setViewerSelection(ISelectionProvider viewer, ISelection selection) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            Object part = this.convert(viewer, iter.next());
            if (part == null) continue;
            result.add(part);
        }
        viewer.setSelection((ISelection)new StructuredSelection(result));
    }

    public void replace(SelectionSynchronizer old) {
        for (ISelectionProvider provider : old.viewers) {
            this.addViewer(provider);
            provider.removeSelectionChangedListener((ISelectionChangedListener)old);
        }
    }
}

