/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.sd.gen.builder;

import java.io.IOException;
import org.eclipse.amp.amf.sd.gen.builder.AbstractJavaSDTest;
import org.eclipse.amp.escape.runtime.extension.IAgentChild;
import org.eclipse.core.runtime.CoreException;

public class XPandCodeGenTest
extends AbstractJavaSDTest {
    private static final String SRCGEN_PATH = "/srcgen/XPandCodeGenTest/";
    private static final String MY_JAVA = "/srcgen/XPandCodeGenTest/My.java";
    private static final String AUX_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/AnAux.java";
    private static final String AUX_TO_FLOW_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/AuxToFlow.java";
    private static final String STOCK_TO_FLOW_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/StockToFlow.java";
    private static final String FLOW_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/AFlow.java";
    private static final String SD_MODEL_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/SdModel.java";
    private static final String STOCK_JAVA = "/srcgen/XPandCodeGenTest/myagent_SD/AStock.java";
    private static final String[] javaFiles = new String[]{"/srcgen/XPandCodeGenTest/My.java", "/srcgen/XPandCodeGenTest/myagent_SD/AnAux.java", "/srcgen/XPandCodeGenTest/myagent_SD/AuxToFlow.java", "/srcgen/XPandCodeGenTest/myagent_SD/AFlow.java", "/srcgen/XPandCodeGenTest/myagent_SD/SdModel.java", "/srcgen/XPandCodeGenTest/myagent_SD/AStock.java", "/srcgen/XPandCodeGenTest/myagent_SD/StockToFlow.java"};

    public XPandCodeGenTest() throws Exception {
        super("XPandCodeGenTest");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.emptyProjectDir("srcgen");
        this.emptyProjectDir("bin");
        String[] expectedFilesToBeGenerated = new String[javaFiles.length * 2];
        int i = 0;
        while (i < javaFiles.length) {
            expectedFilesToBeGenerated[i] = javaFiles[i];
            ++i;
        }
        i = 0;
        while (i < javaFiles.length) {
            expectedFilesToBeGenerated[i + XPandCodeGenTest.javaFiles.length] = javaFiles[i].replace(".java", ".class").replace("/srcgen/", "/bin/");
            ++i;
        }
        this.doGenerate(expectedFilesToBeGenerated);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.emptyProjectDir("srcgen");
        this.emptyProjectDir("bin");
    }

    public void testMy() throws IOException, CoreException {
        String text = this.getFileText(MY_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("private List<" + IAgentChild.class.getSimpleName() + "> children;"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("children = new ArrayList<" + IAgentChild.class.getSimpleName() + ">();"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("children.add(new SdModel());"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("if (timeStep == getRoot().getRunner().getEarliestPeriod()) {"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("for (" + IAgentChild.class.getSimpleName() + " tmp : children) {"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("tmp.startSimulation(timeStep);"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("for (" + IAgentChild.class.getSimpleName() + " tmp : children) {"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("tmp.calculate(timeStep);"));
        this.checkNoCompilationErrors(MY_JAVA);
        XPandCodeGenTest.assertEquals((int)22, (int)this.countGeneratedTags(MY_JAVA));
    }

    public void testAux() throws IOException, CoreException {
        String text = this.getFileText(AUX_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class AnAux extends AbstractVariable"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("private AuxToFlow varAuxToFlow"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("public Double AFlow()"));
        this.checkNoCompilationErrors(AUX_JAVA);
        XPandCodeGenTest.assertEquals((int)6, (int)this.countGeneratedTags(AUX_JAVA));
    }

    public void testStock() throws IOException, CoreException {
        String text = this.getFileText(STOCK_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class AStock extends AbstractStock"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("private StockToFlow varStockToFlow;"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("public Double AFlow()"));
        this.checkNoCompilationErrors(STOCK_JAVA);
        XPandCodeGenTest.assertEquals((int)7, (int)this.countGeneratedTags(STOCK_JAVA));
    }

    public void testFlow() throws IOException, CoreException {
        String text = this.getFileText(FLOW_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class AFlow extends AbstractVariable"));
        this.checkNoCompilationErrors(FLOW_JAVA);
        XPandCodeGenTest.assertEquals((int)4, (int)this.countGeneratedTags(FLOW_JAVA));
    }

    public void testAuxToFlowCon() throws IOException, CoreException {
        String text = this.getFileText(AUX_TO_FLOW_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class AuxToFlow extends Connector"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("setToElement(target);"));
        this.checkNoCompilationErrors(AUX_TO_FLOW_JAVA);
        XPandCodeGenTest.assertEquals((int)2, (int)this.countGeneratedTags(AUX_TO_FLOW_JAVA));
    }

    public void testStockToFlowCon() throws IOException, CoreException {
        String text = this.getFileText(STOCK_TO_FLOW_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class StockToFlow extends Connector"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("setToElement(target);"));
        this.checkNoCompilationErrors(STOCK_TO_FLOW_JAVA);
        XPandCodeGenTest.assertEquals((int)2, (int)this.countGeneratedTags(STOCK_TO_FLOW_JAVA));
    }

    public void testSdModel() throws IOException, CoreException {
        String text = this.getFileText(SD_MODEL_JAVA);
        XPandCodeGenTest.assertTrue((boolean)text.contains("public class SdModel extends AbstractSDModel"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("addVariable(new AnAux());"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("addVariable(new AStock());"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("addVariable(new AFlow());"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("for (AbstractVariable tmp : getVariable())"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("tmp.init(this);"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("public void addDataCollectors(Object scape) {"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("((Scape) scape).addStatCollector(new SDDataCollector(\"AnAux\", this,"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("((Scape) scape).addStatCollector(new SDDataCollector(\"AStock\", this,"));
        XPandCodeGenTest.assertTrue((boolean)text.contains("((Scape) scape).addStatCollector(new SDDataCollector(\"AFlow\", this,"));
        this.checkNoCompilationErrors(SD_MODEL_JAVA);
        XPandCodeGenTest.assertEquals((int)this.countGeneratedTags(SD_MODEL_JAVA), (int)8);
    }
}

