/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.query.parser;

import org.ascape.query.Validated;
import org.ascape.query.parser.BoolExprTree;
import org.ascape.query.parser.ParseException;
import org.ascape.query.parser.QTCriteriaSubNode;

public class QTValue
extends QTCriteriaSubNode
implements Validated {
    private String stringValue;
    private Object coercedValue;
    private Comparor comparor;

    public QTValue(int i) {
        super(i);
    }

    public QTValue(BoolExprTree p, int i) {
        super(p, i);
    }

    public Comparor createComparor() {
        if (this.coercedValue instanceof Integer) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((Integer)QTValue.this.coercedValue).compareTo((Integer)value);
                }
            };
        }
        if (this.coercedValue instanceof Double) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((Double)QTValue.this.coercedValue).compareTo((Double)value);
                }
            };
        }
        if (this.coercedValue instanceof Float) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((Float)QTValue.this.coercedValue).compareTo((Float)value);
                }
            };
        }
        if (this.coercedValue instanceof Long) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((Long)QTValue.this.coercedValue).compareTo((Long)value);
                }
            };
        }
        if (this.coercedValue instanceof String) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((String)QTValue.this.coercedValue).compareTo((String)value);
                }
            };
        }
        if (this.coercedValue instanceof Boolean) {
            return new Comparor(){

                @Override
                public int compareTo(Object value) {
                    return ((Boolean)QTValue.this.coercedValue).equals(value) ? 0 : -1;
                }
            };
        }
        throw new InternalError("Unexpected coerced value type for compareTo op: " + this.coercedValue.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Object object) throws ParseException {
        Class type = this.getCriteria().getProperty().getType();
        try {
            if (type == Integer.TYPE || type == Integer.class) {
                this.coercedValue = Integer.valueOf(this.stringValue);
            } else if (type == Double.TYPE || type == Double.class) {
                this.coercedValue = Double.valueOf(this.stringValue);
            } else if (type == Float.TYPE || type == Float.class) {
                this.coercedValue = Float.valueOf(this.stringValue);
            } else if (type == Long.TYPE || type == Long.class) {
                this.coercedValue = Long.valueOf(this.stringValue);
            } else if (type == Boolean.TYPE || type == Boolean.class) {
                if (!this.stringValue.equals("true") && !this.stringValue.equals("false")) throw new ParseException("Unrecognized format for field: " + this.getCriteria().getProperty().getName() + ". Can't convert " + this.stringValue + " to boolean. (Use \"true\" or \"false\".)");
                this.coercedValue = Boolean.valueOf(this.stringValue);
            } else {
                this.coercedValue = this.stringValue;
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unrecognized number format for field: " + this.getCriteria().getProperty().getName() + ". Can't convert " + this.stringValue + " to " + type + ".");
        }
        this.comparor = this.createComparor();
    }

    public String getValue() {
        return this.stringValue;
    }

    public void setValue(String value) {
        this.stringValue = value;
    }

    public Object getCoercedValue() {
        return this.coercedValue;
    }

    @Override
    public String toString() {
        return this.stringValue;
    }

    public Comparor getComparor() {
        return this.comparor;
    }

    static interface Comparor {
        public int compareTo(Object var1);
    }
}

