/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera.tracking;

import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.tracking.ICameraMove;
import org.eclipse.swt.widgets.Display;

public class TrackingShot
extends TimerTask {
    private static final Logger log = Logger.getLogger(TrackingShot.class.getName());
    long duration;
    ICamera camera;
    ICameraMove move;
    long firstRun = -1L;
    CameraPosition cameraPosition;
    float prevTick;

    public TrackingShot(long i_duration, ICamera i_camera, ICameraMove i_move) {
        this.duration = i_duration;
        this.camera = i_camera;
        this.move = i_move;
        this.cameraPosition = new CameraPosition();
    }

    public void run() {
        try {
            long delta;
            float currentTick;
            long current = System.currentTimeMillis();
            if (this.firstRun == -1L) {
                this.firstRun = current;
                this.prevTick = -1.0f;
            }
            if ((currentTick = (float)(delta = current - this.firstRun) / (float)this.duration) > 1.0f) {
                currentTick = 1.0f;
            }
            this.camera.getCameraPosition(this.cameraPosition);
            this.move.updateCameraPosition(this.cameraPosition, this.prevTick, currentTick);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TrackingShot.this.camera.setCameraPosition(TrackingShot.this.cameraPosition);
                }
            });
            if (currentTick == 1.0f) {
                this.cancel();
            }
            this.prevTick = currentTick;
        }
        catch (RuntimeException t) {
            this.cancel();
            throw t;
        }
    }
}

