/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenDeclarationHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        for (LanguageServiceAccessor.LSPDocumentInfo info : LanguageServiceAccessor.getLSPDocumentInfosFor(textViewer.getDocument(), capabilities -> Boolean.TRUE.equals(capabilities.getDefinitionProvider()))) {
            try {
                CompletionStage documentHighlight = info.getInitializedLanguageClient().thenCompose(ls -> {
                    try {
                        return ls.getTextDocumentService().definition(LSPEclipseUtils.toTextDocumentPosistionParams(info.getFileUri(), region.getOffset(), info.getDocument()));
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                        return CompletableFuture.completedFuture(Collections.emptyList());
                    }
                });
                List locations = (List)((CompletableFuture)documentHighlight).get(2L, TimeUnit.SECONDS);
                if (locations == null || locations.isEmpty()) continue;
                IRegion linkRegion = this.findWord(textViewer.getDocument(), region.getOffset());
                if (linkRegion == null) {
                    linkRegion = region;
                }
                ArrayList<LSBasedHyperlink> hyperlinks = new ArrayList<LSBasedHyperlink>(locations.size());
                for (Location responseLocation : locations) {
                    hyperlinks.add(new LSBasedHyperlink(responseLocation, linkRegion));
                }
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static class LSBasedHyperlink
    implements IHyperlink {
        private Location location;
        private IRegion highlightRegion;

        public LSBasedHyperlink(Location response, IRegion highlightRegion) {
            this.location = response;
            this.highlightRegion = highlightRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.highlightRegion;
        }

        public String getTypeLabel() {
            return Messages.hyperlinkLabel;
        }

        public String getHyperlinkText() {
            return Messages.hyperlinkLabel;
        }

        public void open() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            LSPEclipseUtils.openInEditor(this.location, page);
        }
    }
}

