/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public abstract class AbstractGenerator {
    protected Set<String> getDependencyBundleNames(IQualifiedNameQueryEnvironment queryEnvironment, Module module) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        for (Template main : AcceleoUtil.getMainTemplates((Module)module)) {
            for (Variable parameter : main.getParameters()) {
                IValidationResult validationResult = validator.validate(Collections.emptyMap(), parameter.getType());
                for (IType iType : validator.getDeclarationTypes((IReadOnlyQueryEnvironment)queryEnvironment, validationResult.getPossibleTypes(parameter.getType().getAst()))) {
                    Object type = iType.getType();
                    Class cls = type instanceof Class ? (Class)type : (type instanceof EClassifier && ((EClassifier)type).getInstanceClass() != null ? ((EClassifier)type).getInstanceClass() : null);
                    if (cls == null || !(cls.getClassLoader() instanceof BundleReference)) continue;
                    Bundle bundle = ((BundleReference)cls.getClassLoader()).getBundle();
                    res.add(bundle.getSymbolicName());
                }
            }
        }
        if (res.contains("org.eclipse.uml2.uml")) {
            res.add("org.eclipse.uml2.uml.resources");
        }
        return res;
    }

    protected void addPluginDependencies(IProject project, Set<String> dependencyBundleNames) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model instanceof IBundlePluginModelBase) {
            IBundle bundle = ((IBundlePluginModelBase)model).getBundleModel().getBundle();
            IManifestHeader manifestHeader = bundle.getManifestHeader("Require-Bundle");
            String requiredBundleString = manifestHeader != null ? manifestHeader.getValue() : null;
            if (requiredBundleString == null) {
                StringJoiner joiner = new StringJoiner(",\n  ");
                for (String dependency : dependencyBundleNames) {
                    joiner.add(dependency);
                }
                bundle.setHeader("Require-Bundle", joiner.toString());
            } else {
                StringJoiner joiner = new StringJoiner(",\n  ");
                joiner.add(requiredBundleString);
                for (String dependency : dependencyBundleNames) {
                    int lastSemiColonIndex = dependency.lastIndexOf(";");
                    String dependencyBundleName = lastSemiColonIndex >= 0 ? dependency.substring(0, lastSemiColonIndex) : dependency;
                    boolean foundInRequirement = false;
                    String[] stringArray = requiredBundleString.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String requirement = stringArray[n2];
                        if (requirement.contains(dependencyBundleName)) {
                            foundInRequirement = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!foundInRequirement) {
                        joiner.add(dependency);
                    }
                    bundle.setHeader("Require-Bundle", joiner.toString());
                }
            }
            ((IBundlePluginModelBase)model).save();
        }
    }

    protected void addExportPackages(IProject project, Set<String> packages) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model instanceof IBundlePluginModelBase) {
            IBundle bundle = ((IBundlePluginModelBase)model).getBundleModel().getBundle();
            IManifestHeader manifestHeader = bundle.getManifestHeader("Export-Package");
            String exportedPackageString = manifestHeader != null ? manifestHeader.getValue() : null;
            if (exportedPackageString == null) {
                StringJoiner joiner = new StringJoiner(",\n  ");
                for (String dependency : packages) {
                    joiner.add(dependency);
                }
                bundle.setHeader("Export-Package", joiner.toString());
            } else {
                StringJoiner joiner = new StringJoiner(",\n  ");
                joiner.add(exportedPackageString);
                for (String dependency : packages) {
                    boolean foundInExportedPacakges = false;
                    String[] stringArray = exportedPackageString.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String requirement = stringArray[n2];
                        if (requirement.contains(dependency)) {
                            foundInExportedPacakges = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!foundInExportedPacakges) {
                        joiner.add(dependency);
                    }
                    bundle.setHeader("Export-Package", joiner.toString());
                }
            }
            ((IBundlePluginModelBase)model).save();
        }
    }
}

