/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.namespace.AbstractLoader;
import org.eclipse.acceleo.query.runtime.impl.namespace.Position;
import org.eclipse.acceleo.query.runtime.impl.namespace.Range;
import org.eclipse.acceleo.query.runtime.impl.namespace.SourceLocation;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;

public class ModuleLoader
extends AbstractLoader {
    private final AcceleoEvaluator evaluator;
    private AcceleoParser parser;

    public ModuleLoader(AcceleoParser parser, AcceleoEvaluator evaluator) {
        super("::", "mtl", "mtl");
        this.parser = parser;
        this.evaluator = evaluator;
    }

    public Object load(IQualifiedNameResolver resolver, String qualifiedName) {
        Module res;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = resolver.getInputStream(this.resourceName(qualifiedName));){
                res = is != null ? this.parser.parse(is, StandardCharsets.UTF_8, qualifiedName).getModule() : null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            res = null;
        }
        return res;
    }

    public boolean canHandle(Object object) {
        return object instanceof Module;
    }

    public Set<IService<?>> getServices(IQualifiedNameLookupEngine lookupEngine, Object object, String contextQualifiedName) {
        LinkedHashSet res = new LinkedHashSet();
        Module module = (Module)object;
        for (ModuleElement element : module.getModuleElements()) {
            if (element instanceof Template) {
                res.add((IService<?>)new TemplateService((Template)element, this.evaluator, lookupEngine, contextQualifiedName));
                continue;
            }
            if (!(element instanceof Query)) continue;
            res.add((IService<?>)new QueryService((Query)element, this.evaluator, lookupEngine, contextQualifiedName));
        }
        return res;
    }

    public List<String> getImports(Object object) {
        ArrayList<String> res = new ArrayList<String>();
        Module module = (Module)object;
        for (Import imp : module.getImports()) {
            ModuleReference moduleRef = imp.getModule();
            if (moduleRef == null || moduleRef.getQualifiedName() == null) continue;
            res.add(moduleRef.getQualifiedName());
        }
        return res;
    }

    public String getExtends(Object object) {
        Module module = (Module)object;
        ModuleReference ext = module.getExtends();
        String res = ext != null ? ext.getQualifiedName() : null;
        return res;
    }

    public ISourceLocation getSourceLocation(IQualifiedNameResolver resolver, IService<?> service) {
        SourceLocation res;
        if (service.getOrigin() instanceof ModuleElement) {
            ModuleElement moduleElement = (ModuleElement)service.getOrigin();
            if (moduleElement.eContainer() instanceof Module) {
                Module module = (Module)moduleElement.eContainer();
                if (module.eResource().getURI() != null) {
                    String qualifiedName = module.eResource().getURI().toString().substring("acceleoenv::".length());
                    URI sourceURI = resolver.getSourceURI(qualifiedName);
                    int identifierStartLine = module.getAst().getIdentifierStartLine(moduleElement);
                    int identifierStartColumn = module.getAst().getIdentifierStartColumn(moduleElement);
                    int identifierStartPosition = module.getAst().getIdentifierStartPosition(moduleElement);
                    Position identifierStart = new Position(identifierStartLine, identifierStartColumn, identifierStartPosition);
                    int identifierEndLine = module.getAst().getIdentifierEndLine(moduleElement);
                    int identifierEndColumn = module.getAst().getIdentifierEndColumn(moduleElement);
                    int identifierEndPosition = module.getAst().getIdentifierEndPosition(moduleElement);
                    Position identifierEnd = new Position(identifierEndLine, identifierEndColumn, identifierEndPosition);
                    Range identifierRange = new Range((ISourceLocation.IPosition)identifierStart, (ISourceLocation.IPosition)identifierEnd);
                    int startLine = module.getAst().getStartLine(moduleElement);
                    int startColumn = module.getAst().getStartColumn(moduleElement);
                    int startPosition = module.getAst().getStartPosition(moduleElement);
                    Position start = new Position(startLine, startColumn, startPosition);
                    int endLine = module.getAst().getEndLine(moduleElement);
                    int endColumn = module.getAst().getEndColumn(moduleElement);
                    int endPosition = module.getAst().getEndPosition(moduleElement);
                    Position end = new Position(endLine, endColumn, endPosition);
                    Range range = new Range((ISourceLocation.IPosition)start, (ISourceLocation.IPosition)end);
                    res = new SourceLocation(sourceURI, (ISourceLocation.IRange)identifierRange, (ISourceLocation.IRange)range);
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    public ISourceLocation getSourceLocation(IQualifiedNameResolver resolver, String qualifiedName) {
        SourceLocation res;
        Object resolved = resolver.resolve(qualifiedName);
        if (resolved instanceof Module) {
            Module module = (Module)resolved;
            URI sourceURI = resolver.getSourceURI(qualifiedName);
            int identifierStartLine = module.getAst().getIdentifierStartLine(module);
            int identifierStartColumn = module.getAst().getIdentifierStartColumn(module);
            int identifierStartPosition = module.getAst().getIdentifierStartPosition(module);
            Position identifierStart = new Position(identifierStartLine, identifierStartColumn, identifierStartPosition);
            int identifierEndLine = module.getAst().getIdentifierEndLine(module);
            int identifierEndColumn = module.getAst().getIdentifierEndColumn(module);
            int identifierEndPosition = module.getAst().getIdentifierEndPosition(module);
            Position identifierEnd = new Position(identifierEndLine, identifierEndColumn, identifierEndPosition);
            Range identifierRange = new Range((ISourceLocation.IPosition)identifierStart, (ISourceLocation.IPosition)identifierEnd);
            int startLine = module.getAst().getStartLine(module);
            int startColumn = module.getAst().getStartColumn(module);
            int startPosition = module.getAst().getStartPosition(module);
            Position start = new Position(startLine, startColumn, startPosition);
            int endLine = module.getAst().getEndLine(module);
            int endColumn = module.getAst().getEndColumn(module);
            int endPosition = module.getAst().getEndPosition(module);
            Position end = new Position(endLine, endColumn, endPosition);
            Range range = new Range((ISourceLocation.IPosition)start, (ISourceLocation.IPosition)end);
            res = new SourceLocation(sourceURI, (ISourceLocation.IRange)identifierRange, (ISourceLocation.IRange)range);
        } else {
            res = null;
        }
        return res;
    }
}

