/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.JavaMethodServiceCompletionProposal;
import org.eclipse.acceleo.query.validation.type.AbstractJavaType;
import org.eclipse.acceleo.query.validation.type.ClassLiteralType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class JavaMethodService
extends AbstractService<Method> {
    public static final int PRIORITY = 200;
    private final Object instance;
    private IReadOnlyQueryEnvironment knwonEnvironment;
    private Set<IType> returnTypes;

    public JavaMethodService(Method method, Object serviceInstance) {
        super(method);
        this.instance = serviceInstance;
    }

    @Override
    public String getName() {
        return ((Method)this.getOrigin()).getName();
    }

    @Override
    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<IType> result = new ArrayList<IType>();
        Class<?>[] classArray = ((Method)this.getOrigin()).getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            result.add(this.getClassType(queryEnvironment, cls));
            ++n2;
        }
        return result;
    }

    protected IJavaType getClassType(IReadOnlyQueryEnvironment queryEnvironment, Type type) {
        AbstractJavaType result;
        if (type instanceof ParameterizedType) {
            Class cls = (Class)((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom(cls)) {
                IJavaType t = this.getClassType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0]);
                result = new SequenceType(queryEnvironment, t);
            } else if (Set.class.isAssignableFrom(cls)) {
                IJavaType t = this.getClassType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0]);
                result = new SetType(queryEnvironment, t);
            } else {
                result = new ClassType(queryEnvironment, cls);
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            result = new ClassType(queryEnvironment, cls);
        } else {
            result = new ClassType(queryEnvironment, Object.class);
        }
        return result;
    }

    @Override
    public int getNumberOfParameters() {
        return ((Method)this.getOrigin()).getParameterTypes().length;
    }

    @Override
    protected Object internalInvoke(Object[] arguments) throws Exception {
        return ((Method)this.getOrigin()).invoke(this.instance, arguments);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        if (this.knwonEnvironment != queryEnvironment || this.returnTypes == null) {
            this.knwonEnvironment = queryEnvironment;
            this.returnTypes = new LinkedHashSet<IType>();
            Type returnType = ((Method)this.getOrigin()).getGenericReturnType();
            this.returnTypes.addAll(this.getIType(queryEnvironment, returnType));
        }
        return this.returnTypes;
    }

    public Set<IType> getIType(IReadOnlyQueryEnvironment queryEnvironment, Type type) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (type instanceof ParameterizedType) {
            Class cls = (Class)((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SequenceType(queryEnvironment, t));
                }
            } else if (Set.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(queryEnvironment, ((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SetType(queryEnvironment, t));
                }
            } else {
                result.add(new ClassType(queryEnvironment, cls));
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            result.addAll(this.getIType(queryEnvironment, cls));
        } else {
            result.add(new ClassType(queryEnvironment, Object.class));
        }
        return result;
    }

    private Set<IType> getIType(IReadOnlyQueryEnvironment queryEnvironment, Class<?> cls) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (List.class.isAssignableFrom(cls)) {
            result.add(new SequenceType(queryEnvironment, new ClassType(queryEnvironment, Object.class)));
        } else if (Set.class.isAssignableFrom(cls)) {
            result.add(new SetType(queryEnvironment, new ClassType(queryEnvironment, Object.class)));
        } else {
            result.add(new ClassType(queryEnvironment, cls));
        }
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        IType[] classTypes = new ClassType[argumentTypes.length];
        int i = 0;
        while (i < argumentTypes.length) {
            Class cls;
            IType iType = argumentTypes[i];
            if (iType instanceof EClassifierLiteralType) {
                cls = EClass.class;
            } else if (iType instanceof EClassifierType) {
                cls = queryEnvironment.getEPackageProvider().getClass(((EClassifierType)iType).getType());
                if (cls == null) {
                    cls = iType.getType() instanceof EClass ? EObject.class : Object.class;
                }
            } else if (iType instanceof ClassLiteralType) {
                cls = Class.class;
            } else if (iType instanceof IJavaType) {
                cls = ((IJavaType)iType).getType();
            } else {
                throw new AcceleoQueryValidationException(iType.getClass().getCanonicalName());
            }
            if (cls != null) {
                if ("boolean".equals(cls.getName())) {
                    cls = Boolean.class;
                } else if ("int".equals(cls.getName())) {
                    cls = Integer.class;
                } else if ("double".equals(cls.getName())) {
                    cls = Double.class;
                }
            }
            classTypes[i] = new ClassType(queryEnvironment, cls);
            ++i;
        }
        return super.matches(queryEnvironment, classTypes);
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public String getShortSignature() {
        return this.serviceShortSignature(((Method)this.getOrigin()).getParameterTypes());
    }

    @Override
    public String getLongSignature() {
        return ((Method)this.getOrigin()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JavaMethodService && ((Method)((JavaMethodService)obj).getOrigin()).equals(this.getOrigin());
    }

    @Override
    public int hashCode() {
        return ((Method)this.getOrigin()).hashCode();
    }

    @Override
    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new JavaMethodServiceCompletionProposal(this));
        return result;
    }

    protected IType createReturnCollectionWithType(IReadOnlyQueryEnvironment queryEnvironment, IType collectionType) {
        IType result = collectionType;
        if (List.class.isAssignableFrom(((Method)this.getOrigin()).getReturnType())) {
            result = new SequenceType(queryEnvironment, collectionType);
        } else if (Set.class.isAssignableFrom(((Method)this.getOrigin()).getReturnType())) {
            result = new SetType(queryEnvironment, collectionType);
        }
        return result;
    }
}

