/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.AcceleoEnvironment;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.writer.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.debug.AbstractDSLDebugger;
import org.eclipse.acceleo.debug.DSLSource;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.util.StackFrame;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.impl.namespace.QualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.swt.widgets.Display;

public class AcceleoDebugger
extends AbstractDSLDebugger {
    public static final String MODULE = "module";
    public static final String MODEL = "model";
    public static final String DESTINATION = "destination";
    private IAcceleoEnvironment environment;
    private AcceleoAstResult astResult;
    private Resource model;
    private AcceleoDebugEvaluator evaluator;

    public AcceleoDebugger(IDSLDebugEventProcessor target) {
        super(target);
    }

    public void initialize(boolean noDebug, Map<String, Object> arguments) {
        this.setNoDebug(noDebug);
        URI moduleURI = URI.createURI((String)((String)arguments.get(MODULE)));
        URI modelURI = URI.createURI((String)((String)arguments.get(MODEL)));
        URI destination = URI.createURI((String)((String)arguments.get(DESTINATION)));
        IProject project = LSPEclipseUtils.findResourceFor((String)((String)arguments.get(MODULE))).getProject();
        IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), project, "::");
        QualifiedNameQueryEnvironment queryEnvironment = new QualifiedNameQueryEnvironment(resolver);
        this.environment = new AcceleoEnvironment(resolver, (IQualifiedNameQueryEnvironment)queryEnvironment, (IAcceleoGenerationStrategy)new DefaultGenerationStrategy(), destination);
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment()), (AcceleoEvaluator)this.evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::"));
        try {
            String moduleQualifiedName = resolver.getQualifiedName(java.net.URI.create(moduleURI.toString()).toURL());
            Object resolved = resolver.resolve(moduleQualifiedName);
            if (resolved instanceof Module) {
                this.astResult = ((Module)resolved).getAst();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        this.model = resourceSetForModels.getResource(modelURI, true);
    }

    public String getContent(InputStream stream, String charsetName) throws IOException {
        int len = 8192;
        StringBuilder res = new StringBuilder(8192);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(stream), charsetName);){
            char[] buffer = new char[8192];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
            input.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res.toString();
    }

    public void start() {
        new Thread((Runnable)new GenerateRunnable(), "Acceleo Debug Thread").start();
    }

    protected void generateNoDebug(IAcceleoEnvironment env, Module module, Resource modelResource) {
        AcceleoEvaluator noDebugEvaluator = new AcceleoEvaluator(env, env.getQueryEnvironment().getLookupEngine());
        IQualifiedNameResolver resolver = this.environment.getQueryEnvironment().getLookupEngine().getResolver();
        resolver.clearLoaders();
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment()), noDebugEvaluator));
        resolver.addLoader((ILoader)new JavaLoader("::"));
        AcceleoUtil.generate((AcceleoEvaluator)noDebugEvaluator, (IAcceleoEnvironment)env, (Module)module, (Resource)modelResource);
    }

    public void disconnect() {
    }

    public boolean canStepInto(Long threadID, EObject instruction) {
        return false;
    }

    public boolean validateVariableValue(Long threadID, String variableName, String value) {
        return false;
    }

    public Object getVariableValue(Long threadID, String stackName, String variableName, String value) {
        return null;
    }

    public void setVariableValue(Long threadID, String stackName, String variableName, Object value) {
    }

    public EObject getInstruction(String path, long line, long column) {
        EObject res;
        AcceleoAstResult moduleAstResult = null;
        try {
            Object resolved;
            IQualifiedNameResolver resolver = this.environment.getQueryEnvironment().getLookupEngine().getResolver();
            String moduleQualifiedName = resolver.getQualifiedName(new URL("file://" + path));
            if (moduleQualifiedName != null && (resolved = resolver.resolve(moduleQualifiedName)) instanceof Module) {
                moduleAstResult = ((Module)resolved).getAst();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        EObject instruction = moduleAstResult.getAstNode((int)line - 1, (int)column - 1);
        if (column == 0L) {
            while (instruction != null) {
                if (this.isAcceleoInstruction(instruction)) break;
                instruction = instruction.eContainer();
            }
            res = instruction;
        } else {
            res = instruction;
        }
        return res;
    }

    private boolean isAcceleoInstruction(EObject eObject) {
        return eObject instanceof Statement;
    }

    public DSLSource getSource(EObject instruction) {
        DSLSource res = null;
        String path = null;
        Module module = this.getModule(instruction);
        if (module != null) {
            AcceleoAstResult moduleAstResult = module.getAst();
            IQualifiedNameResolver resolver = this.environment.getQueryEnvironment().getLookupEngine().getResolver();
            String moduleQualifiedName = resolver.getQualifiedName((Object)moduleAstResult.getModule());
            URL moduleSourceURL = resolver.getSourceURL(moduleQualifiedName);
            try {
                path = URIUtil.toFile((java.net.URI)moduleSourceURL.toURI()).toString();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (instruction instanceof ASTNode) {
                int startLine = moduleAstResult.getStartLine((ASTNode)instruction);
                int startColumn = moduleAstResult.getStartColumn((ASTNode)instruction);
                int endLine = moduleAstResult.getEndLine((ASTNode)instruction);
                int endColumn = moduleAstResult.getEndColumn((ASTNode)instruction);
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else if (instruction instanceof Expression) {
                int startLine = moduleAstResult.getStartLine((ASTNode)((Expression)instruction));
                int startColumn = moduleAstResult.getStartColumn((ASTNode)((Expression)instruction));
                int endLine = moduleAstResult.getEndLine((ASTNode)((Expression)instruction));
                int endColumn = moduleAstResult.getEndColumn((ASTNode)((Expression)instruction));
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else if (instruction instanceof VariableDeclaration) {
                int startLine = moduleAstResult.getStartLine((VariableDeclaration)instruction);
                int startColumn = moduleAstResult.getStartColumn((VariableDeclaration)instruction);
                int endLine = moduleAstResult.getEndLine((VariableDeclaration)instruction);
                int endColumn = moduleAstResult.getEndColumn((VariableDeclaration)instruction);
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else {
                res = null;
            }
        }
        return res;
    }

    private Module getModule(EObject instruction) {
        Module res = null;
        EObject current = instruction;
        while (current != null) {
            if (current instanceof Module) {
                res = (Module)current;
                break;
            }
            current = current.eContainer();
        }
        return res;
    }

    private final class AcceleoDebugEvaluator
    extends AcceleoEvaluator {
        AcceleoDebugEvaluator(IAcceleoEnvironment environment, IQualifiedNameLookupEngine lookupEngine) {
            super(environment, lookupEngine);
        }

        public Object generate(ASTNode node, Map<String, Object> variables) {
            return super.generate(node, variables);
        }

        public Object doSwitch(EObject eObject) {
            if (AcceleoDebugger.this.isTerminated()) {
                return null;
            }
            if (eObject instanceof Template || eObject instanceof Query) {
                AcceleoDebugger.this.pushStackFrame(Thread.currentThread().getId(), eObject);
            }
            try {
                if (AcceleoDebugger.this.isAcceleoInstruction(eObject)) {
                    StackFrame currentFrame = AcceleoDebugger.this.peekStackFrame(Thread.currentThread().getId());
                    currentFrame.setInstruction(eObject);
                    currentFrame.setVariables(this.peekVariables());
                    if (!AcceleoDebugger.this.control(Thread.currentThread().getId(), eObject)) {
                        Thread.currentThread().interrupt();
                    }
                }
                Object object = super.doSwitch(eObject);
                return object;
            }
            finally {
                if (eObject instanceof Template || eObject instanceof Query) {
                    AcceleoDebugger.this.popStackFrame(Thread.currentThread().getId());
                }
            }
        }
    }

    private final class GenerateRunnable
    implements Runnable {
        private GenerateRunnable() {
        }

        @Override
        public void run() {
            IContainer container;
            Module module = AcceleoDebugger.this.astResult.getModule();
            long threadID = Thread.currentThread().getId();
            AcceleoDebugger.this.spawnRunningThread(threadID, Thread.currentThread().getName(), (EObject)module);
            try {
                if (AcceleoDebugger.this.isNoDebug()) {
                    AcceleoDebugger.this.generateNoDebug(AcceleoDebugger.this.environment, module, AcceleoDebugger.this.model);
                } else {
                    AcceleoDebugger.this.evaluator = new AcceleoDebugEvaluator(AcceleoDebugger.this.environment, AcceleoDebugger.this.environment.getQueryEnvironment().getLookupEngine());
                    IQualifiedNameResolver resolver = AcceleoDebugger.this.environment.getQueryEnvironment().getLookupEngine().getResolver();
                    resolver.clearLoaders();
                    resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser((IReadOnlyQueryEnvironment)AcceleoDebugger.this.environment.getQueryEnvironment()), (AcceleoEvaluator)AcceleoDebugger.this.evaluator));
                    resolver.addLoader((ILoader)new JavaLoader("::"));
                    AcceleoUtil.generate((AcceleoEvaluator)AcceleoDebugger.this.evaluator, (IAcceleoEnvironment)AcceleoDebugger.this.environment, (Module)module, (Resource)AcceleoDebugger.this.model);
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(new Runnable(threadID){
                    private final /* synthetic */ long val$threadID;
                    {
                        this.val$threadID = l;
                    }

                    @Override
                    public void run() {
                        AcceleoDebugger.this.terminate(this.val$threadID);
                        AcceleoDebugger.this.terminated(this.val$threadID);
                        AcceleoDebugger.this.terminated();
                    }
                });
                throw throwable;
            }
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null && (container = workspace.getRoot().getContainerForLocation((IPath)new Path(AcceleoDebugger.this.environment.getDestination().toFileString()))) != null) {
                try {
                    container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

