/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;

public class AcceleoWorkspace {
    private final String name;
    private final List<AcceleoProject> projects = new ArrayList<AcceleoProject>();
    private AcceleoLanguageServer owner;

    public AcceleoWorkspace(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public void setOwner(AcceleoLanguageServer newOwner) {
        this.owner = newOwner;
    }

    public AcceleoLanguageServer getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public List<AcceleoProject> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    public void addProject(AcceleoProject projectToAdd) {
        Objects.requireNonNull(projectToAdd);
        if (this.projects.contains(projectToAdd)) {
            throw new IllegalArgumentException("Workspace \"" + this.name + "\" already contains project " + projectToAdd.toString() + " so we cannot add it to it.");
        }
        projectToAdd.setWorkspace(this);
        this.projects.add(projectToAdd);
    }

    public void removeProject(AcceleoProject projectToRemove) {
        Objects.requireNonNull(projectToRemove);
        if (!this.projects.contains(projectToRemove)) {
            throw new IllegalArgumentException("Workspace \"" + this.name + "\" does not contain project " + projectToRemove.toString() + " so it cannot be removed from it.");
        }
        this.projects.remove(projectToRemove);
    }

    public List<AcceleoTextDocument> getAllTextDocuments() {
        return this.projects.stream().map(AcceleoProject::getTextDocuments).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public AcceleoTextDocument getTextDocument(URI uri) {
        for (AcceleoProject acceleoProject : this.projects) {
            AcceleoTextDocument textDocument = acceleoProject.getTextDocument(uri);
            if (textDocument == null) continue;
            return textDocument;
        }
        return null;
    }

    public void documentSaved(AcceleoTextDocument savedAcceleoTextDocument) {
        this.getProjects().stream().filter(project -> !project.getTextDocuments().contains(savedAcceleoTextDocument)).forEach(project -> project.documentSaved(savedAcceleoTextDocument));
    }

    public void documentRemoved(AcceleoTextDocument removedAcceleoTextDocument) {
        this.getProjects().stream().forEach(acceleoProject -> acceleoProject.documentRemoved(removedAcceleoTextDocument));
    }
}

