/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.lookup.basic.ServiceStore;
import org.eclipse.acceleo.query.validation.type.IType;

public class BasicLookupEngine
implements ILookupEngine {
    protected IReadOnlyQueryEnvironment queryEnvironment;
    private final ServiceStore services;

    public BasicLookupEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
        this.services = new ServiceStore(queryEnvironment);
    }

    protected ServiceStore getServices() {
        return this.services;
    }

    @Override
    public Set<IService<?>> getRegisteredServices() {
        Set<IService<?>> result = this.services.getServices();
        return result;
    }

    @Override
    public IService<?> lookup(String name, IType[] argumentTypes) {
        List<IService<?>> multiMethod = this.services.getMultiService(name, argumentTypes.length);
        if (multiMethod == null) {
            return null;
        }
        IService<?> result = null;
        for (IService<?> service : multiMethod) {
            if (!service.matches(this.queryEnvironment, argumentTypes) || result != null && service.getPriority() <= result.getPriority() && (service.getPriority() != result.getPriority() || !service.isLowerOrEqualParameterTypes(this.queryEnvironment, result))) continue;
            result = service;
        }
        return result;
    }

    public ServiceRegistrationResult registerService(IService<?> service) {
        ServiceRegistrationResult result = this.services.add(service);
        return result;
    }

    public IService<?> removeService(IService<?> service) {
        IService<?> result = this.services.remove(service);
        return result;
    }

    @Override
    public Set<IService<?>> getServices(Set<IType> receiverTypes) {
        LinkedHashSet result = new LinkedHashSet();
        Set<IService<?>> storedServices = this.services.getServices();
        for (IType type : receiverTypes) {
            if (type == null) continue;
            for (IService<?> service : storedServices) {
                if (!service.getParameterTypes(this.queryEnvironment).get(0).isAssignableFrom(type)) continue;
                result.add(service);
            }
        }
        return result;
    }

    @Override
    public boolean isRegisteredService(IService<?> service) {
        return this.services.isRegistered(service);
    }
}

