/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.NewLineStatement;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.impl.NullValue;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;

public class AcceleoEvaluator
extends AcceleoSwitch<Object> {
    private static final String ID = "org.eclipse.acceleo.aql";
    private static final String EMPTY_RESULT = "";
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final IQueryEvaluationEngine aqlEngine;
    private final Deque<Map<String, Object>> variablesStack = new ArrayDeque<Map<String, Object>>();
    private final Deque<String> indentationStack = new ArrayDeque<String>();
    private final Deque<Map<String, String>> protectedAreaContentStack = new ArrayDeque<Map<String, String>>();
    private String lastLineOfLastStatement;
    private boolean keepIndentation;
    private final IQualifiedNameLookupEngine lookupEngine;
    private Deque<Boolean> inlinedBlock = new ArrayDeque<Boolean>();
    private URI destination;
    private final Deque<IAcceleoWriter> writers = new ArrayDeque<IAcceleoWriter>();
    private final Deque<Set<String>> protectedAreaIDs = new ArrayDeque<Set<String>>();
    private IAcceleoGenerationStrategy generationStrategy;
    private GenerationResult generationResult;
    private String newLine;

    public AcceleoEvaluator(IQualifiedNameLookupEngine lookupEngine, String newLine) {
        this.aqlEngine = QueryEvaluation.newEngine((IQueryEnvironment)((IQueryEnvironment)lookupEngine.getQueryEnvironment()));
        this.lookupEngine = lookupEngine;
        this.newLine = newLine;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public Object generate(AcceleoASTNode node, Map<String, Object> variables, IAcceleoGenerationStrategy strategy, URI destinationURI) {
        Object res;
        this.destination = destinationURI;
        this.generationStrategy = strategy;
        String savedLastLineOfLastStatement = this.lastLineOfLastStatement;
        this.lastLineOfLastStatement = EMPTY_RESULT;
        boolean keepIndentationSave = this.keepIndentation;
        this.keepIndentation = false;
        if (this.generationResult == null) {
            this.generationResult = new GenerationResult();
        }
        this.inlinedBlock.addLast(false);
        this.pushVariables(variables);
        try {
            res = this.doSwitch(node);
        }
        finally {
            this.popVariables();
            this.inlinedBlock.removeLast();
            this.lastLineOfLastStatement = savedLastLineOfLastStatement;
            this.keepIndentation = keepIndentationSave;
        }
        return res;
    }

    protected void pushVariables(Map<String, Object> variables) {
        this.variablesStack.addLast(variables);
    }

    protected Map<String, Object> peekVariables() {
        return this.variablesStack.peekLast();
    }

    protected Map<String, Object> popVariables() {
        return this.variablesStack.removeLast();
    }

    protected Deque<Map<String, Object>> getVariablesStack() {
        return this.variablesStack;
    }

    protected boolean peekInlinedBlock() {
        return this.inlinedBlock.peekLast();
    }

    protected void pushIndentation(Block block, String indentation) {
        if (block.isInlined()) {
            this.inlinedBlock.addLast(true);
            this.indentationStack.addLast(EMPTY_RESULT);
        } else {
            this.inlinedBlock.addLast(false);
            if (this.keepIndentation && indentation.isEmpty()) {
                String currentIndentation = this.peekIndentation();
                if (currentIndentation != null) {
                    this.indentationStack.addLast(currentIndentation);
                } else {
                    this.indentationStack.addLast(indentation);
                }
                this.keepIndentation = false;
            } else {
                this.indentationStack.addLast(indentation);
            }
        }
    }

    protected String peekIndentation() {
        return this.indentationStack.peekLast();
    }

    protected String popIndentation() {
        this.inlinedBlock.removeLast();
        return this.indentationStack.removeLast();
    }

    protected void pushProtectedAreaContent() {
        this.protectedAreaContentStack.addLast(new HashMap());
    }

    protected void putProtectedAreaContent(String id, String useCode) {
        this.protectedAreaContentStack.peekLast().put(id, useCode);
    }

    protected Map<String, String> popProtectedAreaContent() {
        return this.protectedAreaContentStack.removeLast();
    }

    protected IQueryEvaluationEngine getAqlEngine() {
        return this.aqlEngine;
    }

    @Override
    public Object caseExpression(Expression expression) {
        Object res;
        EvaluationResult evalResult;
        AstResult ast = expression.getAst();
        if (ast.getDiagnostic().getSeverity() == 4) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "AQL parsing issue", new Object[]{expression});
            diagnostic.addAll(ast.getDiagnostic());
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
        }
        if ((evalResult = this.aqlEngine.eval(ast, this.peekVariables())).getDiagnostic().getSeverity() != 0) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(evalResult.getDiagnostic().getSeverity(), ID, 0, "AQL evaluation issue", new Object[]{expression, new HashMap<String, Object>(this.peekVariables())});
            diagnostic.addAll(evalResult.getDiagnostic());
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
        }
        if (evalResult.getResult() == null) {
            LinkedHashSet<IType> types = new LinkedHashSet<IType>();
            types.add(evalResult.getNullType());
            res = new NullValue(types);
        } else {
            res = evalResult.getResult();
        }
        return res;
    }

    @Override
    public String caseExpressionStatement(ExpressionStatement expressionStatement) {
        Object res;
        String indentation = this.peekInlinedBlock() ? EMPTY_RESULT : (this.lastLineOfLastStatement.isEmpty() ? this.peekIndentation() : this.lastLineOfLastStatement);
        String expressionValue = this.toString(this.doSwitch(expressionStatement.getExpression()));
        boolean endsWithNewLine = expressionValue.endsWith(this.newLine);
        if (!indentation.isEmpty()) {
            expressionValue = expressionValue.replace(this.newLine, this.newLine + indentation);
            if (endsWithNewLine) {
                expressionValue = expressionValue.substring(0, expressionValue.length() - indentation.length());
            }
        }
        if (expressionStatement.isNewLineNeeded() && !endsWithNewLine) {
            res = this.lastLineOfLastStatement.isEmpty() ? indentation + expressionValue + this.newLine : expressionValue + this.newLine;
            this.lastLineOfLastStatement = EMPTY_RESULT;
        } else {
            res = this.lastLineOfLastStatement.isEmpty() ? indentation + expressionValue : expressionValue;
            int lastIndexOfNewLine = ((String)res).lastIndexOf(this.newLine);
            this.lastLineOfLastStatement = lastIndexOfNewLine != -1 ? ((String)res).substring(lastIndexOfNewLine + this.newLine.length(), ((String)res).length()) : String.valueOf(this.lastLineOfLastStatement) + (String)res;
        }
        return res;
    }

    @Override
    public Void caseModule(Module module) {
        for (ModuleElement element : module.getModuleElements()) {
            if (!(element instanceof Template) || !((Template)element).isMain()) continue;
            String start = this.lookupEngine.getResolver().getQualifiedName((Object)module);
            this.lookupEngine.pushImportsContext(start, start);
            try {
                this.doSwitch(element);
            }
            finally {
                this.lookupEngine.popContext(start);
            }
        }
        return null;
    }

    @Override
    public String caseTemplate(Template template) {
        String res;
        block7: {
            this.pushIndentation(template.getBody(), this.lastLineOfLastStatement);
            try {
                String templateText = (String)this.doSwitch(template.getBody());
                if (template.getPost() != null) {
                    HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
                    variables.put(AcceleoUtil.getTemplateImplicitVariableName(), templateText);
                    this.pushVariables(variables);
                    try {
                        res = this.toString(this.doSwitch(template.getPost()));
                        break block7;
                    }
                    finally {
                        this.popVariables();
                    }
                }
                res = templateText;
            }
            finally {
                this.popIndentation();
            }
        }
        return res;
    }

    @Override
    public Object caseQuery(Query query) {
        Object res = this.doSwitch(query.getBody());
        return res;
    }

    @Override
    public String caseTextStatement(TextStatement textStatement) {
        Object res;
        if (textStatement.isNewLineNeeded()) {
            if (this.lastLineOfLastStatement.isEmpty()) {
                res = !textStatement.getValue().isEmpty() ? this.peekIndentation() + textStatement.getValue() + this.newLine : EMPTY_RESULT;
            } else {
                res = textStatement.getValue() + this.newLine;
                this.lastLineOfLastStatement = EMPTY_RESULT;
            }
        } else if (this.lastLineOfLastStatement.isEmpty()) {
            this.lastLineOfLastStatement = res = this.peekIndentation() + textStatement.getValue();
        } else {
            res = textStatement.getValue();
            this.lastLineOfLastStatement = String.valueOf(this.lastLineOfLastStatement) + (String)res;
        }
        return res;
    }

    @Override
    public String caseNewLineStatement(NewLineStatement newLineStatement) {
        Object res = newLineStatement.isIndentationNeeded() && this.lastLineOfLastStatement.isEmpty() ? this.peekIndentation() + this.newLine : this.newLine;
        this.lastLineOfLastStatement = EMPTY_RESULT;
        this.keepIndentation = true;
        return res;
    }

    @Override
    public String caseBlock(Block block) {
        List<String> texts = this.createBlockTextsList(block);
        boolean lastIsEmptyBlock = false;
        String lastRemovedIndentation = null;
        for (Statement statement : block.getStatements()) {
            String newText;
            int lastNewLineIndex;
            String lastText;
            String text = (String)this.doSwitch(statement);
            if (!text.isEmpty()) {
                if (lastIsEmptyBlock) {
                    Object suffix;
                    lastText = !texts.isEmpty() ? texts.remove(texts.size() - 1) : EMPTY_RESULT;
                    lastNewLineIndex = lastText.lastIndexOf(this.newLine);
                    String prefix = lastNewLineIndex >= 0 ? lastText.substring(0, lastNewLineIndex + this.newLine.length()) : EMPTY_RESULT;
                    if (text.startsWith(this.newLine)) {
                        suffix = text.substring(this.newLine.length());
                    } else if (lastRemovedIndentation != null) {
                        suffix = lastRemovedIndentation + text;
                        lastRemovedIndentation = null;
                    } else {
                        suffix = text;
                    }
                    String newText2 = prefix + (String)suffix;
                    if (!newText2.isEmpty()) {
                        texts.add(newText2);
                    }
                } else {
                    texts.add(text);
                }
                lastIsEmptyBlock = false;
                continue;
            }
            lastIsEmptyBlock = statement.isMultiLines();
            if (!lastIsEmptyBlock) continue;
            lastText = !texts.isEmpty() ? texts.remove(texts.size() - 1) : EMPTY_RESULT;
            lastNewLineIndex = lastText.lastIndexOf(this.newLine);
            if (lastNewLineIndex >= 0) {
                int index = lastNewLineIndex + this.newLine.length();
                newText = lastText.substring(0, index);
                lastRemovedIndentation = lastText.substring(index, lastText.length());
            } else {
                newText = EMPTY_RESULT;
                lastRemovedIndentation = lastText;
            }
            if (newText.isEmpty()) continue;
            texts.add(newText);
        }
        StringBuilder builder = new StringBuilder();
        for (String text : texts) {
            builder.append(text);
        }
        return builder.toString();
    }

    protected List<String> createBlockTextsList(Block block) {
        return new ArrayList<String>();
    }

    @Override
    public String caseComment(Comment comment) {
        return EMPTY_RESULT;
    }

    @Override
    public String caseLetStatement(LetStatement letStatement) {
        String res;
        HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
        for (Binding binding : letStatement.getVariables()) {
            String name = binding.getName();
            Object value = this.doSwitch(binding.getInitExpression());
            variables.put(name, value);
        }
        this.pushVariables(variables);
        this.pushIndentation(letStatement.getBody(), this.lastLineOfLastStatement);
        try {
            res = (String)this.doSwitch(letStatement.getBody());
        }
        finally {
            this.popIndentation();
            this.popVariables();
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String caseFileStatement(FileStatement fileStatement) {
        uriObject = this.doSwitch(fileStatement.getUrl());
        if (uriObject == null) {
            diagnostic = new BasicDiagnostic(4, "org.eclipse.acceleo.aql", 0, "The URL can't be null", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
            res = "";
        } else {
            mode = fileStatement.getMode();
            charset = this.getCharset(fileStatement);
            try {
                uri = URI.createURI((String)this.toString(uriObject), (boolean)true).resolve(this.destination);
                this.openWriter(uri, mode, charset, this.newLine);
                this.lastLineOfLastStatement = "";
                this.pushIndentation(fileStatement.getBody(), this.lastLineOfLastStatement);
                this.pushProtectedAreaContent();
                content = "";
                try {
                    content = (String)this.doSwitch(fileStatement.getBody());
                }
                finally {
                    ** for (entry : this.popProtectedAreaContent().entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    protectedAreaContentsRegex = IAcceleoGenerationStrategy.USER_CODE_START + " " + Pattern.quote(entry.getKey()) + this.newLine + "((?!" + IAcceleoGenerationStrategy.USER_CODE_END + ").|" + this.newLine + ")*" + IAcceleoGenerationStrategy.USER_CODE_END + this.newLine;
                    content = content.replaceFirst(protectedAreaContentsRegex, Matcher.quoteReplacement(entry.getValue()));
                    continue;
                }
lbl24:
                // 1 sources

                this.write(content);
                this.popIndentation();
                this.closeWriter(fileStatement);
            }
            catch (IOException e) {
                diagnostic = new BasicDiagnostic(4, "org.eclipse.acceleo.aql", 0, e.getMessage(), new Object[]{fileStatement, new HashMap<String, Object>(this.peekVariables())});
                this.generationResult.addDiagnostic((Diagnostic)diagnostic);
            }
            catch (IllegalArgumentException e) {
                diagnostic = new BasicDiagnostic(4, "org.eclipse.acceleo.aql", 0, e.getMessage() + " " + String.valueOf(this.destination) + " " + String.valueOf(uriObject), new Object[]{fileStatement, new HashMap<String, Object>(this.peekVariables())});
                this.generationResult.addDiagnostic((Diagnostic)diagnostic);
            }
            res = "";
        }
        return res;
    }

    private void openWriter(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
        IAcceleoWriter writer = this.generationStrategy.createWriterFor(uri, openMode, charset, lineDelimiter);
        this.writers.addLast(writer);
        this.protectedAreaIDs.addLast(new HashSet());
        this.generationResult.getGeneratedFiles().add(writer.getTargetURI());
    }

    private void closeWriter(FileStatement fileStatement) throws IOException {
        IAcceleoGenerationStrategy strategy = this.getGenerationStrategy();
        this.writeLostFiles(fileStatement, strategy);
        IAcceleoWriter writer = this.writers.removeLast();
        strategy.closeWriter(writer);
        this.protectedAreaIDs.removeLast();
    }

    private void writeLostFiles(FileStatement fileStatement, IAcceleoGenerationStrategy strategy) throws IOException {
        URI targetURI = this.getTargetURI();
        Charset targetCharset = this.getTargetCharset();
        Map<String, List<String>> remainingProtectedAreas = strategy.consumeAllProtectedAreas(targetURI);
        for (Map.Entry<String, List<String>> entry : remainingProtectedAreas.entrySet()) {
            String lostID = entry.getKey();
            IAcceleoWriter lostWriter = strategy.createWriterForLostContent(targetURI, lostID, targetCharset, this.newLine);
            try {
                for (String lostContent : entry.getValue()) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, "Lost file generated: " + String.valueOf(lostWriter.getTargetURI()), new Object[]{fileStatement, new HashMap<String, Object>(this.peekVariables())});
                    this.generationResult.addDiagnostic((Diagnostic)diagnostic);
                    lostWriter.append(FORMAT.format(new Date()) + " - Lost user content " + lostID + this.newLine);
                    lostWriter.append(lostContent + this.newLine);
                    this.generationResult.getLostFiles().add(lostWriter.getTargetURI());
                }
            }
            finally {
                strategy.closeWriter(lostWriter);
            }
        }
    }

    private void write(String text) throws IOException {
        IAcceleoWriter writer = this.writers.peekLast();
        writer.append(text);
    }

    private Charset getCharset(FileStatement fileStatement) {
        Charset charset;
        if (fileStatement.getCharset() != null) {
            Object charsetValue = this.doSwitch(fileStatement.getCharset());
            if (charsetValue != null && charsetValue.getClass() != NullValue.class) {
                String charsetString = this.toString(charsetValue);
                Charset defaultCharset = StandardCharsets.UTF_8;
                try {
                    defaultCharset = Charset.forName(charsetString);
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, e.getMessage() + " fallback to UTF-8", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
                    this.generationResult.addDiagnostic((Diagnostic)diagnostic);
                }
                charset = defaultCharset;
            } else {
                BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, "The Charset can't be null, fallback to UTF-8", new Object[]{fileStatement.getUrl(), new HashMap<String, Object>(this.peekVariables())});
                this.generationResult.addDiagnostic((Diagnostic)diagnostic);
                charset = StandardCharsets.UTF_8;
            }
        } else {
            charset = StandardCharsets.UTF_8;
        }
        return charset;
    }

    @Override
    public String caseIfStatement(IfStatement ifStatement) {
        String res;
        Object condition = this.doSwitch(ifStatement.getCondition());
        if (condition instanceof Boolean) {
            if (Boolean.TRUE.equals(condition)) {
                this.pushIndentation(ifStatement.getThen(), this.lastLineOfLastStatement);
                try {
                    res = (String)this.doSwitch(ifStatement.getThen());
                }
                finally {
                    this.popIndentation();
                }
            } else if (ifStatement.getElse() != null) {
                this.pushIndentation(ifStatement.getElse(), this.lastLineOfLastStatement);
                try {
                    res = (String)this.doSwitch(ifStatement.getElse());
                }
                finally {
                    this.popIndentation();
                }
            } else {
                res = EMPTY_RESULT;
            }
        } else {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "The expression must be evaluated to a boolean not: " + this.toString(condition), new Object[]{ifStatement.getCondition(), new HashMap<String, Object>(this.peekVariables())});
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
            res = EMPTY_RESULT;
        }
        return res;
    }

    @Override
    public String caseForStatement(ForStatement forStatement) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> iteration = new ArrayList<Object>();
        Object value = this.doSwitch(forStatement.getBinding().getInitExpression());
        if (value instanceof Collection) {
            iteration.addAll((Collection)value);
        } else if (value != null && value.getClass() != NullValue.class) {
            iteration.add(value);
        } else {
            BasicDiagnostic diagnostic = new BasicDiagnostic(2, ID, 0, "The expression should not be null", new Object[]{forStatement.getBinding().getInitExpression(), new HashMap<String, Object>(this.peekVariables())});
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
        }
        if (!iteration.isEmpty()) {
            HashMap<String, Object> variables = new HashMap<String, Object>(this.peekVariables());
            String name = forStatement.getBinding().getName();
            this.pushVariables(variables);
            this.pushIndentation(forStatement.getBody(), this.lastLineOfLastStatement);
            try {
                Object firstValue = iteration.remove(0);
                int index = 1;
                variables.put(name, firstValue);
                variables.put(name + "Index", index++);
                builder.append(this.doSwitch(forStatement.getBody()));
                for (Object e : iteration) {
                    variables.put(name, e);
                    variables.put(name + "Index", index++);
                    if (forStatement.getSeparator() != null) {
                        builder.append(this.toString(this.doSwitch(forStatement.getSeparator())));
                    }
                    builder.append(this.doSwitch(forStatement.getBody()));
                }
            }
            finally {
                this.popIndentation();
                this.popVariables();
            }
        }
        return builder.toString();
    }

    @Override
    public String caseProtectedArea(ProtectedArea protectedArea) {
        String res;
        Object idObject = this.doSwitch(protectedArea.getId());
        String id = this.toString(idObject);
        if (id.isEmpty()) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "The protected area id can't be empty.", new Object[]{protectedArea.getId(), new HashMap<String, Object>(this.peekVariables())});
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
            res = EMPTY_RESULT;
        } else {
            res = this.getProtectedAreaContent(protectedArea, id);
        }
        return res;
    }

    private String getProtectedAreaContent(ProtectedArea protectedArea, String id) {
        URI uri;
        String protectedAreaContent;
        StringBuilder res = new StringBuilder();
        this.checkProtectedAreaIdUniqueness(protectedArea, id);
        if (protectedArea.getStartTagPrefix() != null) {
            Object startTagPrefixObject = this.doSwitch(protectedArea.getStartTagPrefix());
            res.append(this.toString(startTagPrefixObject));
        }
        if ((protectedAreaContent = this.generationStrategy.consumeProtectedAreaContent(uri = this.getTargetURI(), id)) != null) {
            this.putProtectedAreaContent(id, protectedAreaContent);
            res.append(IAcceleoGenerationStrategy.USER_CODE_START + " " + id + this.newLine);
            res.append(IAcceleoGenerationStrategy.USER_CODE_END + this.newLine);
        } else {
            this.pushIndentation(protectedArea.getBody(), this.lastLineOfLastStatement);
            try {
                res.append(IAcceleoGenerationStrategy.USER_CODE_START + " " + id + this.newLine);
                this.lastLineOfLastStatement = EMPTY_RESULT;
                this.keepIndentation = true;
                String text = (String)this.doSwitch(protectedArea.getBody());
                res.append(text);
                if (this.lastLineOfLastStatement.isEmpty()) {
                    res.append(this.peekIndentation());
                }
            }
            finally {
                this.popIndentation();
            }
            if (protectedArea.getEndTagPrefix() != null) {
                Object endTagPrefixObject = this.doSwitch(protectedArea.getEndTagPrefix());
                res.append(this.toString(endTagPrefixObject));
            }
            res.append(IAcceleoGenerationStrategy.USER_CODE_END + this.newLine);
        }
        this.lastLineOfLastStatement = EMPTY_RESULT;
        this.keepIndentation = true;
        return res.toString();
    }

    private URI getTargetURI() {
        return this.writers.peekLast().getTargetURI();
    }

    private Charset getTargetCharset() {
        return this.writers.peekLast().getCharset();
    }

    private void checkProtectedAreaIdUniqueness(ProtectedArea protectedArea, String id) {
        if (!this.protectedAreaIDs.peekLast().add(id)) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "Duplicated protected area ID: " + id, new Object[]{protectedArea.getId(), new HashMap<String, Object>(this.peekVariables())});
            this.generationResult.addDiagnostic((Diagnostic)diagnostic);
        }
    }

    @Override
    public String caseError(Error error) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, ID, 0, "Acceleo parsing error see validation for more details", new Object[]{error});
        this.generationResult.addDiagnostic((Diagnostic)diagnostic);
        return EMPTY_RESULT;
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null && object.getClass() != NullValue.class) {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    public URI getDestination() {
        return this.destination;
    }

    public IAcceleoGenerationStrategy getGenerationStrategy() {
        return this.generationStrategy;
    }

    public GenerationResult getGenerationResult() {
        return this.generationResult;
    }
}

