/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorEClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.acceleo.query.parser.QueryBaseListener;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;

public class AstBuilderListener
extends QueryBaseListener {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query";
    public static final String FEATURE_ACCESS_SERVICE_NAME = "aqlFeatureAccess";
    public static final String OCL_IS_KIND_OF_SERVICE_NAME = "oclIsKindOf";
    public static final String OCL_IS_TYPE_OF_SERVICE_NAME = "oclIsTypeOf";
    public static final String CONDITIONAL_OPERATOR = "if";
    public static final String NOT_SERVICE_NAME = "not";
    public static final String NOT_OPERATOR = "not";
    public static final String LET_OPERATOR = "let";
    public static final String DIFFERS_SERVICE_NAME = "differs";
    public static final String DIFFERS_OPERATOR = "<>";
    public static final String DIFFERS_JAVA_OPERATOR = "!=";
    public static final String EQUALS_SERVICE_NAME = "equals";
    public static final String EQUALS_OPERATOR = "=";
    public static final String EQUALS_JAVA_OPERATOR = "==";
    public static final String GREATER_THAN_EQUAL_SERVICE_NAME = "greaterThanEqual";
    public static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    public static final String GREATER_THAN_SERVICE_NAME = "greaterThan";
    public static final String GREATER_THAN_OPERATOR = ">";
    public static final String LESS_THAN_EQUAL_SERVICE_NAME = "lessThanEqual";
    public static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    public static final String LESS_THAN_SERVICE_NAME = "lessThan";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String DIV_SERVICE_NAME = "divOp";
    public static final String DIV_OPERATOR = "/";
    public static final String MULT_SERVICE_NAME = "mult";
    public static final String MULT_OPERATOR = "*";
    public static final String SUB_SERVICE_NAME = "sub";
    public static final String SUB_OPERATOR = "-";
    public static final String ADD_SERVICE_NAME = "add";
    public static final String ADD_OPERATOR = "+";
    public static final String UNARY_MIN_SERVICE_NAME = "unaryMin";
    public static final String UNARY_MIN_OPERATOR = "-";
    public static final String AND_SERVICE_NAME = "and";
    public static final String AND_OPERATOR = "and";
    public static final String OR_SERVICE_NAME = "or";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_SERVICE_NAME = "xor";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_SERVICE_NAME = "implies";
    public static final String IMPLIES_OPERATOR = "implies";
    public static final Set<String> OPERATOR_SERVICE_NAMES = AstBuilderListener.initOperatorServiceNames();
    public static final String INVALID_TYPE_LITERAL = "invalid type literal %s";
    private static final String THIS_SHOULDN_T_HAPPEN = "This shouldn't happen.";
    private static final String INVALID_ENUM_LITERAL = "invalid enum literal: %s";
    private static final int CONDITIONAL_CONTEXT_CHILD_COUNT = 7;
    public static final String SUPER_CALL = "super:";
    private static final int NO_ERROR = -1;
    private static final String INTERNAL_ERROR_MSG = "Internal exception occured while evaluating an expression";
    private Deque<Object> stack = new ArrayDeque<Object>();
    private int errorRule = -1;
    private Positions<ASTNode> positions = new Positions();
    private List<Error> errors = new ArrayList<Error>();
    private Deque<Diagnostic> diagnosticStack = new ArrayDeque<Diagnostic>();
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private final ANTLRErrorListener errorListener = new QueryErrorListener();
    private final AstBuilder builder = new AstBuilder();
    private Deque<Expression> lambdaVariableExpression = new ArrayDeque<Expression>();
    private boolean lastArgumentIsLambda;

    public AstBuilderListener(IReadOnlyQueryEnvironment environment) {
        this();
    }

    public AstBuilderListener() {
    }

    private static Set<String> initOperatorServiceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(ADD_SERVICE_NAME);
        result.add("and");
        result.add(DIFFERS_SERVICE_NAME);
        result.add(DIV_SERVICE_NAME);
        result.add(EQUALS_SERVICE_NAME);
        result.add(GREATER_THAN_EQUAL_SERVICE_NAME);
        result.add(GREATER_THAN_SERVICE_NAME);
        result.add("implies");
        result.add(LESS_THAN_EQUAL_SERVICE_NAME);
        result.add(LESS_THAN_SERVICE_NAME);
        result.add(MULT_SERVICE_NAME);
        result.add("not");
        result.add("or");
        result.add(SUB_SERVICE_NAME);
        result.add(UNARY_MIN_SERVICE_NAME);
        result.add("xor");
        return result;
    }

    private void setIdentifierPositions(ASTNode node, int position, int line, int column) {
        this.positions.setIdentifierStartPositions(node, position);
        this.positions.setIdentifierStartLines(node, line);
        this.positions.setIdentifierStartColumns(node, column);
        this.positions.setIdentifierEndPositions(node, position);
        this.positions.setIdentifierEndLines(node, line);
        this.positions.setIdentifierEndColumns(node, column);
    }

    private void setPositions(ASTNode node, int position, int line, int column) {
        this.positions.setStartPositions(node, position);
        this.positions.setStartLines(node, line);
        this.positions.setStartColumns(node, column);
        this.positions.setEndPositions(node, position);
        this.positions.setEndLines(node, line);
        this.positions.setEndColumns(node, column);
    }

    private void setIdentifierPositions(ASTNode node, Token identifierToken) {
        this.positions.setIdentifierStartPositions(node, identifierToken.getStartIndex());
        this.positions.setIdentifierStartLines(node, identifierToken.getLine() - 1);
        this.positions.setIdentifierStartColumns(node, identifierToken.getCharPositionInLine());
        this.positions.setIdentifierEndPositions(node, identifierToken.getStopIndex() + 1);
        this.positions.setIdentifierEndLines(node, identifierToken.getLine() - 1);
        this.positions.setIdentifierEndColumns(node, identifierToken.getCharPositionInLine() + identifierToken.getText().length());
    }

    private void setPositions(ASTNode node, Token start, Token end) {
        this.positions.setStartPositions(node, start.getStartIndex());
        this.positions.setStartLines(node, start.getLine() - 1);
        this.positions.setStartColumns(node, start.getCharPositionInLine());
        this.positions.setEndPositions(node, end.getStopIndex() + 1);
        this.positions.setEndLines(node, end.getLine() - 1);
        this.positions.setEndColumns(node, end.getCharPositionInLine() + end.getText().length());
    }

    private void setIdentifierPositions(ASTNode node, Token start, Token end) {
        this.positions.setIdentifierStartPositions(node, start.getStartIndex());
        this.positions.setIdentifierStartLines(node, start.getLine() - 1);
        this.positions.setIdentifierStartColumns(node, start.getCharPositionInLine());
        this.positions.setIdentifierEndPositions(node, end.getStopIndex() + 1);
        this.positions.setIdentifierEndLines(node, end.getLine() - 1);
        this.positions.setIdentifierEndColumns(node, end.getCharPositionInLine() + end.getText().length());
    }

    private void setPositions(ASTNode node, ASTNode astNodeStart, ASTNode astNodeEnd) {
        this.positions.setStartPositions(node, this.positions.getStartPositions(astNodeStart));
        this.positions.setStartLines(node, this.positions.getStartLines(astNodeStart));
        this.positions.setStartColumns(node, this.positions.getStartColumns(astNodeStart));
        this.positions.setEndPositions(node, this.positions.getEndPositions(astNodeEnd));
        this.positions.setEndLines(node, this.positions.getEndLines(astNodeEnd));
        this.positions.setEndColumns(node, this.positions.getEndColumns(astNodeEnd));
    }

    private void setIdentifierPositions(ASTNode node, ASTNode astNodeStart, ASTNode astNodeEnd) {
        this.positions.setIdentifierStartPositions(node, this.positions.getStartPositions(astNodeStart));
        this.positions.setIdentifierStartLines(node, this.positions.getStartLines(astNodeStart));
        this.positions.setIdentifierStartColumns(node, this.positions.getStartColumns(astNodeStart));
        this.positions.setIdentifierEndPositions(node, this.positions.getEndPositions(astNodeEnd));
        this.positions.setIdentifierEndLines(node, this.positions.getEndLines(astNodeEnd));
        this.positions.setIdentifierEndColumns(node, this.positions.getEndColumns(astNodeEnd));
    }

    private void setPositions(ASTNode node, ASTNode astNodeStart, Token end) {
        this.positions.setStartPositions(node, this.positions.getStartPositions(astNodeStart));
        this.positions.setStartLines(node, this.positions.getStartLines(astNodeStart));
        this.positions.setStartColumns(node, this.positions.getStartColumns(astNodeStart));
        this.positions.setEndPositions(node, end.getStopIndex() + 1);
        this.positions.setEndLines(node, end.getLine() - 1);
        this.positions.setEndColumns(node, end.getCharPositionInLine() + end.getText().length());
    }

    public AstResult getAstResult() {
        Expression ast = this.popExpression();
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        for (Diagnostic diag : this.diagnostics) {
            diagnostic.add(diag);
        }
        Positions<ASTNode> resultPositions = this.positions;
        this.positions = new Positions();
        List<Error> resultErrors = this.errors;
        this.errors = new ArrayList<Error>();
        return new AstResult(ast, resultPositions, resultErrors, (Diagnostic)diagnostic);
    }

    private Expression popExpression() {
        try {
            List data;
            Expression expression = (Expression)this.pop();
            if (!this.diagnosticStack.isEmpty() && (data = this.diagnosticStack.getLast().getData()).get(0).equals(this.positions.getStartPositions(expression)) && data.get(1).equals(this.positions.getEndPositions(expression))) {
                Diagnostic tmpDiagnostic = this.diagnosticStack.removeLast();
                this.diagnostics.add((Diagnostic)new BasicDiagnostic(tmpDiagnostic.getSeverity(), tmpDiagnostic.getSource(), tmpDiagnostic.getCode(), tmpDiagnostic.getMessage(), new Object[]{expression}));
            }
            return expression;
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException cce) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, cce);
        }
    }

    private Binding popBinding() {
        try {
            return (Binding)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private VariableDeclaration popVariableDeclaration() {
        try {
            return (VariableDeclaration)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private TypeLiteral popTypeLiteral() {
        try {
            return (TypeLiteral)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Call peekCall() {
        return (Call)this.stack.getLast();
    }

    private void push(Object obj) {
        this.stack.addLast(obj);
    }

    protected Object pop() {
        Object element = this.stack.removeLast();
        return element;
    }

    private void pushError(Error error, String msg) {
        this.errors.add(error);
        this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, PLUGIN_ID, 0, msg, new Object[]{error}));
        this.push(error);
    }

    private void popErrorExpression() {
        if (!this.stack.isEmpty() && this.stack.getLast() instanceof ErrorExpression) {
            ErrorExpression error = (ErrorExpression)this.pop();
            this.errors.remove(error);
            this.positions.remove(error);
            this.diagnostics.remove(this.diagnostics.size() - 1);
        }
    }

    @Override
    public void exitIntType(QueryParser.IntTypeContext ctx) {
        ClassTypeLiteral typeLiteral = this.builder.typeLiteral(Integer.class);
        this.setPositions((ASTNode)typeLiteral, ctx.start, ctx.stop);
        this.push(typeLiteral);
    }

    @Override
    public void exitFalseLit(QueryParser.FalseLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(false);
        this.setPositions((ASTNode)booleanLiteral, ctx.start, ctx.stop);
        this.push(booleanLiteral);
    }

    @Override
    public void exitRealType(QueryParser.RealTypeContext ctx) {
        ClassTypeLiteral realLiteral = this.builder.typeLiteral(Double.class);
        this.setPositions((ASTNode)realLiteral, ctx.start, ctx.stop);
        this.push(realLiteral);
    }

    @Override
    public void exitTrueLit(QueryParser.TrueLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(true);
        this.setPositions((ASTNode)booleanLiteral, ctx.start, ctx.stop);
        this.push(booleanLiteral);
    }

    @Override
    public void exitSeqType(QueryParser.SeqTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(List.class, elementType);
        this.setPositions((ASTNode)collectionTypeLiteral, ctx.start, ctx.stop);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitSetType(QueryParser.SetTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(Set.class, elementType);
        this.setPositions((ASTNode)collectionTypeLiteral, ctx.start, ctx.stop);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitNot(QueryParser.NotContext ctx) {
        Call callService = this.builder.callService("not", this.popExpression());
        this.setIdentifierPositions((ASTNode)callService, ctx.start, ctx.stop);
        this.setPositions((ASTNode)callService, ctx.start, ctx.stop);
        this.push(callService);
    }

    @Override
    public void exitStringLit(QueryParser.StringLitContext ctx) {
        String text = ctx.getText();
        StringLiteral stringLiteral = this.builder.stringLiteral(text.substring(1, text.length() - 1));
        this.setPositions((ASTNode)stringLiteral, ctx.start, ctx.stop);
        this.push(stringLiteral);
    }

    @Override
    public void exitErrorStringLit(QueryParser.ErrorStringLitContext ctx) {
        String text = ctx.getText();
        ErrorStringLiteral errorStringLiteral = this.builder.errorStringLiteral(text.substring(1, text.length()));
        this.setPositions((ASTNode)errorStringLiteral, ctx.start, ctx.stop);
        this.pushError(errorStringLiteral, "String literal is not properly closed by a simple-quote.");
    }

    @Override
    public void exitRealLit(QueryParser.RealLitContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.valueOf(ctx.getText()));
        this.setPositions((ASTNode)realLiteral, ctx.start, ctx.stop);
        this.push(realLiteral);
    }

    @Override
    public void exitStrType(QueryParser.StrTypeContext ctx) {
        ClassTypeLiteral typeLiteral = this.builder.typeLiteral(String.class);
        this.setPositions((ASTNode)typeLiteral, ctx.start, ctx.stop);
        this.push(typeLiteral);
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Or callService = this.builder.callOrService(op1, op2);
        this.setIdentifierPositions(callService, (Token)ctx.getChild(1).getPayload());
        this.setPositions((ASTNode)callService, (ASTNode)op1, op2);
        this.push(callService);
    }

    @Override
    public void exitXor(QueryParser.XorContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Call callService = this.builder.callService("xor", op1, op2);
        this.setIdentifierPositions(callService, (Token)ctx.getChild(1).getPayload());
        this.setPositions((ASTNode)callService, (ASTNode)op1, op2);
        this.push(callService);
    }

    @Override
    public void exitImplies(QueryParser.ImpliesContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Implies callService = this.builder.callImpliesService(op1, op2);
        this.setIdentifierPositions((ASTNode)callService, op1, op2);
        this.setPositions((ASTNode)callService, (ASTNode)op1, op2);
        this.push(callService);
    }

    @Override
    public void exitBooleanType(QueryParser.BooleanTypeContext ctx) {
        ClassTypeLiteral typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.setPositions((ASTNode)typeLiteral, ctx.start, ctx.stop);
        this.push(typeLiteral);
    }

    @Override
    public void exitIntegerLit(QueryParser.IntegerLitContext ctx) {
        IntegerLiteral integerLiteral = this.builder.integerLiteral(Integer.valueOf(ctx.getText()));
        this.setPositions((ASTNode)integerLiteral, ctx.start, ctx.stop);
        this.push(integerLiteral);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        And callService = this.builder.callAndService(op1, op2);
        this.setIdentifierPositions((ASTNode)callService, op1, op2);
        this.setPositions((ASTNode)callService, (ASTNode)op1, op2);
        this.push(callService);
    }

    @Override
    public void exitVarRef(QueryParser.VarRefContext ctx) {
        VarRef varRef = this.builder.varRef(ctx.getText());
        this.setIdentifierPositions(varRef, ctx.start);
        this.setPositions((ASTNode)varRef, ctx.start, ctx.stop);
        this.push(varRef);
    }

    @Override
    public void exitFeature(QueryParser.FeatureContext ctx) {
        Expression receiver = this.popExpression();
        String featureName = AstBuilder.stripUnderscore(ctx.getChild(1).getText());
        StringLiteral featureNameLiteral = this.builder.stringLiteral(featureName);
        Call call = this.builder.callService(FEATURE_ACCESS_SERVICE_NAME, receiver, featureNameLiteral);
        call.setType(CallType.CALLORAPPLY);
        this.setPositions((ASTNode)featureNameLiteral, ctx.stop, ctx.stop);
        this.setIdentifierPositions(call, (Token)ctx.getChild(1).getPayload());
        this.setPositions((ASTNode)call, (ASTNode)receiver, featureNameLiteral);
        this.push(call);
    }

    private void pushBinary(String service, ParserRuleContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Call callService = this.builder.callService(service, op1, op2);
        this.setIdentifierPositions((ASTNode)callService, op1, op2);
        this.setPositions((ASTNode)callService, (ASTNode)op1, op2);
        this.push(callService);
    }

    @Override
    public void exitServiceCall(QueryParser.ServiceCallContext ctx) {
        if (this.errorRule != 5) {
            Call call;
            boolean isSuperCall;
            String serviceName;
            boolean missinEndParenthesis;
            boolean bl = missinEndParenthesis = ctx.getChild(ctx.getChildCount() - 1) instanceof ErrorNode || !")".equals(ctx.getChild(ctx.getChildCount() - 1).getText());
            if (missinEndParenthesis && this.lastArgumentIsLambda) {
                this.popErrorExpression();
            }
            int argc = this.getNumberOfArgs(ctx.getChild(2).getChildCount());
            Expression[] args = new Expression[argc];
            int i = argc - 1;
            while (i >= 0) {
                args[i] = this.popExpression();
                --i;
            }
            if (SUPER_CALL.equals(ctx.getChild(0).getText())) {
                serviceName = ctx.getChild(1).getText().replace("::", ".");
                isSuperCall = true;
            } else {
                serviceName = ctx.getChild(0).getText().replace("::", ".");
                isSuperCall = false;
            }
            if (missinEndParenthesis) {
                call = this.builder.errorCall(serviceName, true, args);
                this.pushError((Error)((Object)call), "missing ')'");
            } else {
                call = this.builder.callService(serviceName, args);
                this.push(call);
            }
            call.setSuperCall(isSuperCall);
            this.setIdentifierPositions(call, (Token)ctx.getChild(0).getPayload());
            this.setPositions((ASTNode)call, (ASTNode)args[0], ctx.stop);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void enterArguments(QueryParser.ArgumentsContext ctx) {
        this.lastArgumentIsLambda = false;
        this.lambdaVariableExpression.addLast((Expression)this.stack.getLast());
    }

    @Override
    public void exitArguments(QueryParser.ArgumentsContext ctx) {
        this.lastArgumentIsLambda = this.stack.getLast() instanceof Lambda;
        this.lambdaVariableExpression.removeLast();
    }

    private int getNumberOfArgs(int childCount) {
        int result = childCount == 0 ? 1 : 2 + childCount / 2;
        return result;
    }

    @Override
    public void exitMin(QueryParser.MinContext ctx) {
        Call callService = this.builder.callService(UNARY_MIN_SERVICE_NAME, this.popExpression());
        this.setIdentifierPositions((ASTNode)callService, ctx.start, ctx.stop);
        this.setPositions((ASTNode)callService, ctx.start, ctx.stop);
        this.push(callService);
    }

    @Override
    public void exitAdd(QueryParser.AddContext ctx) {
        String op = ctx.getChild(1).getText();
        if (ADD_OPERATOR.equals(op)) {
            this.pushBinary(ADD_SERVICE_NAME, ctx);
        } else if ("-".equals(op)) {
            this.pushBinary(SUB_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitMult(QueryParser.MultContext ctx) {
        String op = ctx.getChild(1).getText();
        if (MULT_OPERATOR.equals(op)) {
            this.pushBinary(MULT_SERVICE_NAME, ctx);
        } else if (DIV_OPERATOR.equals(op)) {
            this.pushBinary(DIV_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitComp(QueryParser.CompContext ctx) {
        String op = ctx.getChild(1).getText();
        if (LESS_THAN_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_SERVICE_NAME, ctx);
        } else if (LESS_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (EQUALS_OPERATOR.equals(op) || EQUALS_JAVA_OPERATOR.equals(op)) {
            this.pushBinary(EQUALS_SERVICE_NAME, ctx);
        } else if (DIFFERS_OPERATOR.equals(op) || DIFFERS_JAVA_OPERATOR.equals(op)) {
            this.pushBinary(DIFFERS_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitCollectionCall(QueryParser.CollectionCallContext ctx) {
        this.peekCall().setType(CallType.COLLECTIONCALL);
    }

    @Override
    public void exitCallOrApply(QueryParser.CallOrApplyContext ctx) {
        this.peekCall().setType(CallType.CALLORAPPLY);
    }

    @Override
    public void exitVariableDefinition(QueryParser.VariableDefinitionContext ctx) {
        if (this.errorRule == -1) {
            Token stop;
            VariableDeclaration variableDeclaration;
            if (ctx.getChildCount() == 4) {
                TypeLiteral typeLiteral = this.popTypeLiteral();
                Expression variableExpression = this.lambdaVariableExpression.getLast();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), typeLiteral, variableExpression);
                stop = ((ParserRuleContext)ctx.getChild((int)2)).stop;
            } else {
                Expression variableExpression = this.lambdaVariableExpression.getLast();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), variableExpression);
                stop = ((TerminalNode)ctx.getChild(0)).getSymbol();
            }
            this.setIdentifierPositions(variableDeclaration, (Token)ctx.getChild(0).getPayload());
            this.setPositions((ASTNode)variableDeclaration, ctx.start, stop);
            this.push(variableDeclaration);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitLambda(QueryParser.LambdaContext ctx) {
        Expression expression = this.popExpression();
        this.popErrorExpression();
        VariableDeclaration declaration = this.popVariableDeclaration();
        Lambda lambda = this.builder.lambda(expression, declaration);
        this.setIdentifierPositions((ASTNode)lambda, declaration, declaration);
        this.setPositions((ASTNode)lambda, (ASTNode)declaration, expression);
        this.push(lambda);
    }

    @Override
    public void exitEnumLit(QueryParser.EnumLitContext ctx) {
        if (ctx.getChildCount() >= 5) {
            EnumLiteral toPush;
            String ePackageName = ctx.getChild(0).getText();
            String eEnumName = ctx.getChild(2).getText();
            String eEnumLiteralName = ctx.getChild(4).getText();
            if (ctx.getChild(4) instanceof ErrorNode) {
                toPush = this.builder.errorEnumLiteral(false, ePackageName, eEnumName);
                this.pushError((Error)((Object)toPush), String.format(INVALID_ENUM_LITERAL, "missing literal name"));
            } else {
                toPush = this.builder.enumLiteral(ePackageName, eEnumName, eEnumLiteralName);
                this.push(toPush);
            }
            this.setIdentifierPositions((ASTNode)toPush, ctx.start, ctx.stop);
            this.setPositions((ASTNode)toPush, ctx.start, ctx.stop);
        }
    }

    @Override
    public void exitErrorEnumLit(QueryParser.ErrorEnumLitContext ctx) {
        if (this.errorRule == -1) {
            String ePackageName = ctx.getChild(0).getText();
            String eEnumName = ctx.getChild(2).getText();
            ErrorEnumLiteral errorEnumLiteral = this.builder.errorEnumLiteral(true, ePackageName, eEnumName);
            this.pushError(errorEnumLiteral, String.format(INVALID_ENUM_LITERAL, "':' instead of '::'"));
            this.setIdentifierPositions((ASTNode)errorEnumLiteral, ctx.start, ctx.stop);
            this.setPositions((ASTNode)errorEnumLiteral, ctx.start, ctx.stop);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitClassifierType(QueryParser.ClassifierTypeContext ctx) {
        if (this.errorRule == -1) {
            EClassifierTypeLiteral toPush;
            String ePackageName = ctx.getChild(0).getText();
            if (ctx.getChild(2) == null || ctx.getChild(2) instanceof ErrorNode) {
                toPush = this.builder.errorEClassifierTypeLiteral(false, ePackageName);
                this.pushError((Error)((Object)toPush), String.format(INVALID_TYPE_LITERAL, ctx.getText()));
            } else {
                String eClassName = ctx.getChild(2).getText();
                toPush = this.builder.eClassifierTypeLiteral(ePackageName, eClassName);
                this.push(toPush);
            }
            this.setIdentifierPositions((ASTNode)toPush, ctx.start, ctx.stop);
            this.setPositions((ASTNode)toPush, ctx.start, ctx.stop);
        }
    }

    @Override
    public void exitErrorClassifierType(QueryParser.ErrorClassifierTypeContext ctx) {
        String ePackageName = ctx.getChild(0).getText();
        ErrorEClassifierTypeLiteral errorTypeLiteral = this.builder.errorEClassifierTypeLiteral(true, ePackageName);
        this.pushError(errorTypeLiteral, String.format(INVALID_TYPE_LITERAL, ctx.getText()));
        this.setIdentifierPositions((ASTNode)errorTypeLiteral, ctx.start, ctx.stop);
        this.setPositions((ASTNode)errorTypeLiteral, ctx.start, ctx.stop);
    }

    public ANTLRErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void exitNullLit(QueryParser.NullLitContext ctx) {
        NullLiteral nullLiteral = this.builder.nullLiteral();
        this.setPositions((ASTNode)nullLiteral, ctx.start, ctx.stop);
        this.push(nullLiteral);
    }

    @Override
    public void exitExplicitSetLit(QueryParser.ExplicitSetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.setPositions((ASTNode)setInExtension, ctx.start, ctx.stop);
        this.push(setInExtension);
    }

    private List<Expression> getExpressions(QueryParser.LiteralContext ctx) {
        int nbExpressions = (ctx.getChild(1).getChildCount() + 1) / 2;
        Expression[] expressions = new Expression[nbExpressions];
        int i = nbExpressions - 1;
        while (i >= 0) {
            expressions[i] = this.popExpression();
            --i;
        }
        return Arrays.asList(expressions);
    }

    @Override
    public void exitExplicitSeqLit(QueryParser.ExplicitSeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.setPositions((ASTNode)sequenceInExtension, ctx.start, ctx.stop);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitConditional(QueryParser.ConditionalContext ctx) {
        Conditional conditional;
        Expression falseBranch;
        Expression trueBranch;
        Expression predicate;
        int count = ctx.getChildCount();
        if (count <= 3) {
            predicate = this.popExpression();
            trueBranch = null;
            falseBranch = null;
        } else if (count <= 5) {
            trueBranch = this.popExpression();
            predicate = this.popExpression();
            falseBranch = null;
        } else {
            falseBranch = this.popExpression();
            trueBranch = this.popExpression();
            predicate = this.popExpression();
        }
        if (this.errorRule == 1 || count == 7 && ctx.getChild(6) instanceof ErrorNode) {
            conditional = this.builder.errorConditional(predicate, trueBranch, falseBranch);
            this.errorRule = -1;
            this.pushError((Error)((Object)conditional), "incomplet conditional");
        } else {
            conditional = this.builder.conditional(predicate, trueBranch, falseBranch);
            this.push(conditional);
        }
        this.setPositions((ASTNode)conditional, ctx.start, ctx.stop);
    }

    @Override
    public void exitBinding(QueryParser.BindingContext ctx) {
        if (this.errorRule != 2) {
            String variable = ctx.getChild(0).getText();
            Expression expression = this.popExpression();
            TypeLiteral type = ctx.getChildCount() == 5 ? this.popTypeLiteral() : null;
            Binding binding = this.builder.binding(variable, type, expression);
            this.setIdentifierPositions(binding, (Token)ctx.getChild(0).getPayload());
            this.setPositions((ASTNode)binding, ctx.start, ctx.stop);
            this.push(binding);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitLetExpr(QueryParser.LetExprContext ctx) {
        Binding[] bindings;
        Expression body;
        if (!(ctx.getChild(ctx.getChildCount() - 1) instanceof QueryParser.ExpressionContext)) {
            this.popErrorExpression();
            body = this.builder.errorExpression();
            int position = ctx.stop.getStopIndex() + 1;
            int line = ctx.stop.getLine() - 1;
            int column = ctx.stop.getCharPositionInLine() + ctx.stop.getText().length();
            this.setPositions(body, position, line, column);
            ArrayList<Binding> bindingList = new ArrayList<Binding>();
            while (!this.stack.isEmpty() && this.stack.getLast() instanceof Binding) {
                bindingList.add(this.popBinding());
            }
            bindings = bindingList.toArray(new Binding[bindingList.size()]);
        } else {
            body = this.popExpression();
            int bindingNumber = 1 + (ctx.getChildCount() - 3) / 2;
            bindings = new Binding[bindingNumber];
            int i = bindingNumber - 1;
            while (i >= 0) {
                bindings[i] = this.popBinding();
                --i;
            }
        }
        Let let = this.builder.let(body, bindings);
        this.setPositions((ASTNode)let, ctx.start, ctx.stop);
        this.push(let);
    }

    @Override
    public void exitClassifierSetType(QueryParser.ClassifierSetTypeContext ctx) {
        int nbTypes = (ctx.getChildCount() + 1) / 2 - 1;
        TypeLiteral[] types = new TypeLiteral[nbTypes];
        int i = nbTypes - 1;
        while (i >= 0) {
            types[i] = this.popTypeLiteral();
            --i;
        }
        TypeSetLiteral classifierSetType = this.builder.typeSetLiteral(Arrays.asList(types));
        this.setPositions((ASTNode)classifierSetType, ctx.start, ctx.stop);
        this.push(classifierSetType);
    }

    private final class QueryErrorListener
    extends BaseErrorListener {
        private static final String MISSING_EXPRESSION = "missing expression";

        private QueryErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (e != null) {
                if (e.getCtx() instanceof QueryParser.ArgumentsContext) {
                    this.argumentsContextError(e);
                } else if (e.getCtx() instanceof QueryParser.TypeLiteralContext) {
                    this.typeLiteralContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.LiteralContext) {
                    this.literalContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.ClassifierTypeRuleContext) {
                    this.classifierTypeRuleContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.VariableDefinitionContext) {
                    this.variableDefinitionContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.ServiceCallContext) {
                    this.serviceCallContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.NavigationSegmentContext) {
                    this.navigationSegmentContextError(offendingSymbol);
                } else if (e.getCtx() instanceof QueryParser.BindingContext) {
                    this.bindingContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.ConditionalContext) {
                    AstBuilderListener.this.errorRule = 1;
                } else if (!(e.getCtx() instanceof QueryParser.ParenContext)) {
                    this.defaultError(offendingSymbol, msg, e);
                }
            } else if (recognizer instanceof QueryParser) {
                this.noRecognitionException(recognizer, offendingSymbol, msg);
            } else {
                QueryParser parser = (QueryParser)recognizer;
                Integer startPosition = ((QueryParser.EnumLitContext)parser.getContext()).start.getStartIndex();
                Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
                AstBuilderListener.this.diagnosticStack.addLast((Diagnostic)new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }

        private void classifierTypeRuleContextError(Object offendingSymbol, String msg, RecognitionException e) {
            QueryParser.ClassifierTypeRuleContext ctx = (QueryParser.ClassifierTypeRuleContext)e.getCtx();
            if (e.getCtx().getParent().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorEClassifierTypeLiteral errorEClassifierTypeLiteral = ctx.getChildCount() > 0 ? AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, ctx.getChild(0).getText()) : AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, null);
                AstBuilderListener.this.setPositions((ASTNode)errorEClassifierTypeLiteral, ctx.start, (Token)offendingSymbol);
                AstBuilderListener.this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, ctx.getText()), new Object[]{errorEClassifierTypeLiteral}));
                AstBuilderListener.this.errors.add(errorEClassifierTypeLiteral);
                Expression variableExpression = AstBuilderListener.this.lambdaVariableExpression.getLast();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, errorEClassifierTypeLiteral, variableExpression);
                AstBuilderListener.this.setPositions((ASTNode)variableDeclaration, ctx.start, (Token)offendingSymbol);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                AstBuilderListener.this.setPositions((ASTNode)errorExpression, (Token)offendingSymbol, (Token)offendingSymbol);
            } else {
                AstBuilderListener.this.errorRule = 14;
                Error error = ctx.getParent() instanceof QueryParser.ClassifierSetTypeContext ? (ctx.getChildCount() > 0 ? AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, ctx.getChild(0).getText()) : AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, null)) : AstBuilderListener.this.builder.errorTypeLiteral();
                AstBuilderListener.this.setPositions((ASTNode)error, ctx.start, (Token)offendingSymbol);
                AstBuilderListener.this.pushError(error, "missing classifier literal");
            }
        }

        private void argumentsContextError(RecognitionException e) {
            AstBuilderListener.this.errorRule = 1;
            ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
            AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
            QueryParser.ArgumentsContext ctx = (QueryParser.ArgumentsContext)e.getCtx();
            Token lastToken = ((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol();
            int position = lastToken.getStartIndex() + lastToken.getText().length();
            int line = lastToken.getLine() - 1;
            int column = lastToken.getCharPositionInLine() + lastToken.getText().length();
            AstBuilderListener.this.setIdentifierPositions(errorExpression, position, line, column);
            AstBuilderListener.this.setPositions(errorExpression, position, line, column);
        }

        private void typeLiteralContextError(Object offendingSymbol, String msg, RecognitionException e) {
            if (e.getCtx().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorTypeLiteral type = AstBuilderListener.this.builder.errorTypeLiteral();
                AstBuilderListener.this.setPositions((ASTNode)type, ((QueryParser.TypeLiteralContext)e.getCtx()).start, (Token)offendingSymbol);
                AstBuilderListener.this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg), new Object[]{type}));
                AstBuilderListener.this.errors.add(type);
                Expression variableExpression = AstBuilderListener.this.lambdaVariableExpression.getLast();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.setPositions((ASTNode)variableDeclaration, ((QueryParser.TypeLiteralContext)e.getCtx()).start, (Token)offendingSymbol);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                AstBuilderListener.this.setPositions((ASTNode)errorExpression, ((QueryParser.TypeLiteralContext)e.getCtx()).start, (Token)offendingSymbol);
            } else if (AstBuilderListener.this.stack.isEmpty() || !(AstBuilderListener.this.stack.getLast() instanceof TypeLiteral)) {
                AstBuilderListener.this.errorRule = 13;
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral();
                AstBuilderListener.this.setPositions((ASTNode)errorTypeLiteral, ((QueryParser.TypeLiteralContext)e.getCtx()).start, (Token)offendingSymbol);
                AstBuilderListener.this.pushError(errorTypeLiteral, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg));
            } else {
                AstBuilderListener.this.diagnosticStack.addLast((Diagnostic)new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{((QueryParser.TypeLiteralContext)e.getCtx()).start.getStartIndex(), ((Token)offendingSymbol).getStopIndex() + 1}));
            }
        }

        private void literalContextError(Object offendingSymbol, String msg, RecognitionException e) {
            QueryParser.LiteralContext ctx = (QueryParser.LiteralContext)e.getCtx();
            Token start = ctx.start;
            Token end = (Token)offendingSymbol;
            String ePackage = ctx.getParent().getStart().getText();
            AstBuilderListener.this.errorRule = 13;
            if (ctx.getChildCount() == 4) {
                String eEnumName = ctx.getChild(2).getText();
                ErrorEnumLiteral errorEnumLiteral = AstBuilderListener.this.builder.errorEnumLiteral(false, ePackage, eEnumName);
                AstBuilderListener.this.setPositions((ASTNode)errorEnumLiteral, start, end);
                AstBuilderListener.this.pushError(errorEnumLiteral, String.format(AstBuilderListener.INVALID_ENUM_LITERAL, msg));
            } else {
                ErrorEClassifierTypeLiteral errorEClassifierTypeLiteral = AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, ePackage);
                AstBuilderListener.this.setPositions((ASTNode)errorEClassifierTypeLiteral, start, end);
                AstBuilderListener.this.pushError(errorEClassifierTypeLiteral, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg));
            }
        }

        private void variableDefinitionContextError(Object offendingSymbol, RecognitionException e) {
            if (e.getCtx().getChildCount() > 0) {
                TypeLiteral type;
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getChild(0).getText();
                if (e.getCtx().getChildCount() > 2) {
                    type = AstBuilderListener.this.popTypeLiteral();
                    int position = ((Token)offendingSymbol).getStopIndex() + 1;
                    int line = ((Token)offendingSymbol).getLine() - 1;
                    int column = ((Token)offendingSymbol).getCharPositionInLine() + ((Token)offendingSymbol).getText().length();
                    AstBuilderListener.this.positions.setEndPositions(type, position);
                    AstBuilderListener.this.positions.setEndLines(type, line);
                    AstBuilderListener.this.positions.setEndColumns(type, column);
                } else {
                    type = null;
                }
                Expression variableExpression = AstBuilderListener.this.lambdaVariableExpression.getLast();
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.setIdentifierPositions(errorVariableDeclaration, (Token)e.getCtx().getChild(0).getPayload());
                AstBuilderListener.this.setPositions((ASTNode)errorVariableDeclaration, ((QueryParser.VariableDefinitionContext)e.getCtx()).start, (Token)offendingSymbol);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "incomplete variable definition");
            } else {
                Expression variableExpression = AstBuilderListener.this.lambdaVariableExpression.getLast();
                AstBuilderListener.this.errorRule = 11;
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(null, null, variableExpression);
                AstBuilderListener.this.setIdentifierPositions(errorVariableDeclaration, ((QueryParser.VariableDefinitionContext)e.getCtx()).start);
                AstBuilderListener.this.setPositions((ASTNode)errorVariableDeclaration, ((QueryParser.VariableDefinitionContext)e.getCtx()).start, (Token)offendingSymbol);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "missing variable declaration");
            }
            if (((Token)offendingSymbol).getText().isEmpty() || ")".equals(((Token)offendingSymbol).getText())) {
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                if (((Token)offendingSymbol).getStartIndex() == ((Token)offendingSymbol).getStopIndex()) {
                    int position = ((Token)offendingSymbol).getStopIndex();
                    int line = ((Token)offendingSymbol).getLine() - 1;
                    int column = ((Token)offendingSymbol).getCharPositionInLine() + ((Token)offendingSymbol).getText().length() - 1;
                    AstBuilderListener.this.setIdentifierPositions(errorExpression, position, line, column);
                    AstBuilderListener.this.setPositions(errorExpression, position, line, column);
                } else {
                    int position = ((Token)offendingSymbol).getStopIndex() + 1;
                    int line = ((Token)offendingSymbol).getLine() - 1;
                    int column = ((Token)offendingSymbol).getCharPositionInLine() + ((Token)offendingSymbol).getText().length();
                    AstBuilderListener.this.setIdentifierPositions(errorExpression, position, line, column);
                    AstBuilderListener.this.setPositions(errorExpression, position, line, column);
                }
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
            }
        }

        private void serviceCallContextError(Object offendingSymbol, RecognitionException e) {
            ErrorCall errorCollectionCall;
            Expression receiver;
            AstBuilderListener.this.errorRule = 5;
            String name = e.getCtx().getChildCount() > 0 ? e.getCtx().getChild(0).getText() : null;
            if (e.getCtx().getChildCount() == 3) {
                int argc = AstBuilderListener.this.getNumberOfArgs(e.getCtx().getChild(2).getChildCount());
                Expression[] args = new Expression[argc];
                int i = argc - 1;
                while (i >= 0) {
                    args[i] = AstBuilderListener.this.popExpression();
                    --i;
                }
                receiver = args[0];
                errorCollectionCall = AstBuilderListener.this.builder.errorCall(name, false, args);
            } else {
                receiver = AstBuilderListener.this.popExpression();
                errorCollectionCall = AstBuilderListener.this.builder.errorCall(null, false, receiver);
            }
            if (e.getCtx().getChildCount() > 0) {
                AstBuilderListener.this.setIdentifierPositions(errorCollectionCall, (Token)e.getCtx().getChild(0).getPayload());
            } else {
                AstBuilderListener.this.setIdentifierPositions(errorCollectionCall, (Token)offendingSymbol);
            }
            AstBuilderListener.this.setPositions((ASTNode)errorCollectionCall, (ASTNode)receiver, (Token)offendingSymbol);
            AstBuilderListener.this.pushError(errorCollectionCall, "missing collection service call");
        }

        private void navigationSegmentContextError(Object offendingSymbol) {
            Expression receiver = AstBuilderListener.this.popExpression();
            ErrorCall errorCall = AstBuilderListener.this.builder.errorCall(AstBuilderListener.FEATURE_ACCESS_SERVICE_NAME, false, receiver);
            errorCall.setType(CallType.CALLORAPPLY);
            AstBuilderListener.this.setIdentifierPositions(errorCall, (Token)offendingSymbol);
            AstBuilderListener.this.setPositions((ASTNode)errorCall, (ASTNode)receiver, (Token)offendingSymbol);
            AstBuilderListener.this.pushError(errorCall, "missing feature access or service call");
        }

        private void bindingContextError(Object offendingSymbol, RecognitionException e) {
            TypeLiteral type;
            String name;
            AstBuilderListener.this.errorRule = 2;
            if (e.getCtx().getChildCount() > 0 && !"in".equals(e.getCtx().getChild(0).getText())) {
                name = e.getCtx().getChild(0).getText();
                type = e.getCtx().getChildCount() == 3 ? AstBuilderListener.this.popTypeLiteral() : null;
            } else {
                name = null;
                type = null;
            }
            ErrorBinding errorBinding = AstBuilderListener.this.builder.errorBinding(name, type);
            int position = ((Token)offendingSymbol).getStopIndex() + 1;
            int line = ((Token)offendingSymbol).getLine() - 1;
            int column = ((Token)offendingSymbol).getCharPositionInLine() + ((Token)offendingSymbol).getText().length();
            AstBuilderListener.this.setIdentifierPositions(errorBinding, position, line, column);
            AstBuilderListener.this.setPositions(errorBinding, position, line, column);
            AstBuilderListener.this.pushError(errorBinding, "invalid variable declaration in let");
        }

        private void defaultError(Object offendingSymbol, String msg, RecognitionException e) {
            if (offendingSymbol == null && e.getCtx() == null) {
                AstBuilderListener.this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[0]));
            } else {
                switch (e.getCtx().getRuleIndex()) {
                    case 1: {
                        AstBuilderListener.this.errorRule = 1;
                        ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                        int position = ((ParserRuleContext)e.getCtx()).start.getStartIndex();
                        int line = ((ParserRuleContext)e.getCtx()).start.getLine() - 1;
                        int column = ((ParserRuleContext)e.getCtx()).start.getCharPositionInLine();
                        AstBuilderListener.this.setIdentifierPositions(errorExpression, position, line, column);
                        AstBuilderListener.this.setPositions(errorExpression, position, line, column);
                        AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                        break;
                    }
                }
            }
        }

        private void noRecognitionException(Recognizer<?, ?> recognizer, Object offendingSymbol, String msg) {
            QueryParser parser = (QueryParser)recognizer;
            Integer startPosition = parser.getContext().start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            AstBuilderListener.this.diagnosticStack.addLast((Diagnostic)new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
        }
    }
}

