/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.anydsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Group implements Enumerator
{
    WATER(0, "Water", "Water"),
    DAIRY(1, "Dairy", "Dairy"),
    FRUIT(2, "Fruit", "Fruit"),
    GRAIN(3, "Grain", "Grain"),
    PROTEIN(4, "Protein", "Protein"),
    SWEET(5, "Sweet", "Sweet"),
    VEGETABLE(6, "Vegetable", "Vegetable"),
    ALCOHOL(7, "Alcohol", "Alcohol");

    public static final int WATER_VALUE = 0;
    public static final int DAIRY_VALUE = 1;
    public static final int FRUIT_VALUE = 2;
    public static final int GRAIN_VALUE = 3;
    public static final int PROTEIN_VALUE = 4;
    public static final int SWEET_VALUE = 5;
    public static final int VEGETABLE_VALUE = 6;
    public static final int ALCOHOL_VALUE = 7;
    private static final Group[] VALUES_ARRAY;
    public static final List<Group> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Group[]{WATER, DAIRY, FRUIT, GRAIN, PROTEIN, SWEET, VEGETABLE, ALCOHOL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Group get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Group result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Group getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Group result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Group get(int value) {
        switch (value) {
            case 0: {
                return WATER;
            }
            case 1: {
                return DAIRY;
            }
            case 2: {
                return FRUIT;
            }
            case 3: {
                return GRAIN;
            }
            case 4: {
                return PROTEIN;
            }
            case 5: {
                return SWEET;
            }
            case 6: {
                return VEGETABLE;
            }
            case 7: {
                return ALCOHOL;
            }
        }
        return null;
    }

    private Group(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

