/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.anydsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Caliber implements Enumerator
{
    S(0, "S", "S"),
    M(1, "M", "M"),
    L(2, "L", "L"),
    XL(3, "XL", "XL");

    public static final int S_VALUE = 0;
    public static final int M_VALUE = 1;
    public static final int L_VALUE = 2;
    public static final int XL_VALUE = 3;
    private static final Caliber[] VALUES_ARRAY;
    public static final List<Caliber> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Caliber[]{S, M, L, XL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Caliber get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Caliber result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Caliber getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Caliber result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Caliber get(int value) {
        switch (value) {
            case 0: {
                return S;
            }
            case 1: {
                return M;
            }
            case 2: {
                return L;
            }
            case 3: {
                return XL;
            }
        }
        return null;
    }

    private Caliber(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

