/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ide.ui.Activator;
import org.eclipse.acceleo.aql.ls.IAcceleoLanguageServerContext;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.workspace.Synchronizer;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverProvider;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryProject;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class EclipseAcceleoLanguageServerContext
implements IAcceleoLanguageServerContext {
    private static final int BUFFER_SIZE = 8192;
    private final IWorkspace clientWorkspace;
    private final AcceleoSynchronizer synchronizer;

    public EclipseAcceleoLanguageServerContext(IWorkspace clientWorkspace) {
        this.clientWorkspace = Objects.requireNonNull(clientWorkspace);
        AcceleoWorkspace acceleoWorkspace = new AcceleoWorkspace(EclipseAcceleoLanguageServerContext.getAcceleoWorkspaceName(clientWorkspace), (IAcceleoLanguageServerContext)this);
        this.synchronizer = new AcceleoSynchronizer(clientWorkspace, (IQueryWorkspace<AcceleoProject>)acceleoWorkspace);
        this.synchronizer.synchronize();
    }

    public void dispose() {
        this.synchronizer.dispose();
    }

    public AcceleoWorkspace getWorkspace() {
        return this.synchronizer.getAcceleoWorkspace();
    }

    public String getResourceContents(URI resource) {
        IFile file = this.clientWorkspace.getRoot().getFileForLocation((IPath)new Path(resource.getPath().toString()));
        try {
            int length;
            InputStream inputStream = file.getContents();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            inputStream.close();
            return result.toString(file.getCharset());
        }
        catch (IOException | CoreException exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.ui", "There was an issue while reading the contents of file " + file.getLocation().toString(), exception));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcceleoProject getProject(AcceleoWorkspace workspace, URI resource) {
        AcceleoProject res;
        AcceleoSynchronizer acceleoSynchronizer = this.synchronizer;
        synchronized (acceleoSynchronizer) {
            IFile file = this.clientWorkspace.getRoot().getFileForLocation((IPath)new Path(resource.getPath().toString()));
            IProject eclipseProject = file.getProject();
            AcceleoProject existingProject = (AcceleoProject)this.synchronizer.getProject(eclipseProject);
            if (existingProject != null) {
                res = existingProject;
            } else {
                this.synchronizer.add((IResource)file.getProject());
                res = (AcceleoProject)this.synchronizer.getProject(eclipseProject);
            }
        }
        return res;
    }

    public IQueryWorkspaceQualifiedNameResolver createResolver(AcceleoProject acceleoProject) {
        Objects.nonNull(acceleoProject);
        IProject eclipseProject = this.synchronizer.getOrCreateProject((IQueryProject)acceleoProject);
        IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), eclipseProject, "::", true);
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), null));
        resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", true));
        return QueryPlugin.getPlugin().createWorkspaceQualifiedNameResolver(eclipseProject, resolver, (IWorkspaceResolverProvider)this.synchronizer);
    }

    private static String getAcceleoWorkspaceName(IWorkspace clientWorkspace) {
        return "AcceleoWorkspace[" + clientWorkspace.getRoot().getLocationURI().toString() + "]";
    }

    private static class AcceleoSynchronizer
    extends Synchronizer<AcceleoProject> {
        AcceleoSynchronizer(IWorkspace eclipseWorkspace, IQueryWorkspace<AcceleoProject> queryWorkspace) {
            super(eclipseWorkspace, queryWorkspace);
        }

        protected AcceleoProject createProject(IQueryWorkspace<AcceleoProject> acceleoWorkspace, IProject eclipseProject) {
            return new AcceleoProject(eclipseProject.getName(), (AcceleoWorkspace)acceleoWorkspace);
        }

        public AcceleoWorkspace getAcceleoWorkspace() {
            return (AcceleoWorkspace)this.getQueryWorkspace();
        }
    }
}

