/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.aql.ide.ui.module.main.EclipseUIProjectGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.main.StandaloneGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateEclipseUIProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Iterator it = selection.iterator();
        LinkedHashMap<IProject, List> projectToFiles = new LinkedHashMap<IProject, List>();
        while (it.hasNext()) {
            Object selected = it.next();
            if (!(selected instanceof IFile)) continue;
            IFile file = (IFile)selected;
            projectToFiles.computeIfAbsent(file.getProject(), p -> new ArrayList()).add(file);
        }
        for (Map.Entry entry : projectToFiles.entrySet()) {
            for (IFile file : (List)entry.getValue()) {
                StandaloneGenerator standaloneGenerator = new StandaloneGenerator(file);
                standaloneGenerator.generate();
            }
            EclipseUIProjectGenerator eclipseUIProjectGenerator = new EclipseUIProjectGenerator((List)entry.getValue());
            eclipseUIProjectGenerator.generate();
        }
        return null;
    }
}

