/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.ui.test;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ide.ui.ProposalLabelProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EEnumLiteralCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.JavaMethodServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.TextCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableCompletionProposal;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProposalLabelProviderTests {
    private TestProposalLabelProvider labelProvider;

    @Before
    public void before() {
        this.labelProvider = new TestProposalLabelProvider();
    }

    @After
    public void after() {
        this.labelProvider.dispose();
    }

    @Test
    public void eClassifierCompletionProposalEClass() {
        EClassifierCompletionProposal completionProposal = new EClassifierCompletionProposal((EClassifier)AnydslPackage.eINSTANCE.getCompany());
        Assert.assertEquals((Object)"anydsl::Company", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getELabelProvider().getImage((Object)AnydslPackage.eINSTANCE.getCompany()), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void eClassifierCompletionProposalEDataType() {
        EClassifierCompletionProposal completionProposal = new EClassifierCompletionProposal((EClassifier)AnydslPackage.eINSTANCE.getCountryData());
        Assert.assertEquals((Object)"anydsl::CountryData", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getELabelProvider().getImage((Object)AnydslPackage.eINSTANCE.getCountryData()), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void eClassifierCompletionProposalEEnum() {
        EClassifierCompletionProposal completionProposal = new EClassifierCompletionProposal((EClassifier)AnydslPackage.eINSTANCE.getColor());
        Assert.assertEquals((Object)"anydsl::Color", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getELabelProvider().getImage((Object)AnydslPackage.eINSTANCE.getColor()), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void eEnumLiteralCompletionProposal() {
        EEnumLiteralCompletionProposal completionProposal = new EEnumLiteralCompletionProposal(AnydslPackage.eINSTANCE.getColor().getEEnumLiteral(0));
        Assert.assertEquals((Object)"anydsl::Color::black", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getELabelProvider().getImage((Object)AnydslPackage.eINSTANCE.getColor().getEEnumLiteral(0)), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void eFeatureCompletionProposal() {
        EFeatureCompletionProposal completionProposal = new EFeatureCompletionProposal((EStructuralFeature)AnydslPackage.eINSTANCE.getCompany().getEAllStructuralFeatures().get(0));
        Assert.assertEquals((Object)"name", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getELabelProvider().getImage(AnydslPackage.eINSTANCE.getCompany().getEAllStructuralFeatures().get(0)), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void serviceCompletionProposal() throws NoSuchMethodException, SecurityException {
        JavaMethodServiceCompletionProposal completionProposal = new JavaMethodServiceCompletionProposal((JavaMethodService)new TestService());
        Assert.assertEquals((Object)"testService(java.lang.String,java.lang.String)", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getServiceImage(), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void textCompletionProposal() {
        TextCompletionProposal completionProposal = new TextCompletionProposal("someThing", 0);
        Assert.assertEquals((Object)"someThing", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getTextImage(), this.labelProvider.getImage(completionProposal));
    }

    @Test
    public void variableCompletionProposal() {
        VariableCompletionProposal completionProposal = new VariableCompletionProposal("aVariable");
        Assert.assertEquals((Object)"aVariable", (Object)this.labelProvider.getText(completionProposal));
        this.assertImagesEquals(this.labelProvider.getVariableImage(), this.labelProvider.getImage(completionProposal));
    }

    public void assertImagesEquals(Image expected, Image actual) {
        Assert.assertEquals((long)expected.getBounds().x, (long)expected.getBounds().x);
        Assert.assertEquals((long)expected.getBounds().y, (long)expected.getBounds().y);
        int x = 0;
        while (x < expected.getBounds().x) {
            int y = 0;
            while (y < expected.getBounds().y) {
                Assert.assertEquals((long)expected.getImageData().getPixel(x, y), (long)actual.getImageData().getPixel(x, y));
                ++y;
            }
            ++x;
        }
    }

    public String testService(String a, String b) {
        return "";
    }

    private static final class TestProposalLabelProvider
    extends ProposalLabelProvider {
        private TestProposalLabelProvider() {
        }

        public Image getServiceImage() {
            return this.service;
        }

        public Image getVariableImage() {
            return this.service;
        }

        public Image getTextImage() {
            return this.service;
        }

        public ILabelProvider getELabelProvider() {
            return this.eLabelProvider;
        }
    }

    private final class TestService
    extends JavaMethodService {
        public TestService() throws NoSuchMethodException, SecurityException {
            super(ProposalLabelProviderTests.this.getClass().getMethod("testService", String.class, String.class), (Object)ProposalLabelProviderTests.this, false);
        }

        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            result.add((IType)new ClassType(queryEnvironment, String.class));
            return result;
        }

        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                result.addAll((Collection<IType>)entry.getValue());
            }
            return result;
        }

        public Method getServiceMethod() {
            Method result = null;
            try {
                result = ProposalLabelProviderTests.this.getClass().getMethod("testService", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            return result;
        }

        public Object getServiceInstance() {
            return ProposalLabelProviderTests.this;
        }
    }
}

