/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoFactory;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.BlockComment;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.migration.IModuleResolver;
import org.eclipse.acceleo.aql.migration.MigrationException;
import org.eclipse.acceleo.aql.migration.converters.AbstractConverter;
import org.eclipse.acceleo.aql.migration.converters.AmbiguousServiceMethodRefactorVisitor;
import org.eclipse.acceleo.aql.migration.converters.ExpressionConverter;
import org.eclipse.acceleo.aql.migration.converters.utils.TypeUtils;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.utilities.PredefinedType;

public final class ModuleConverter
extends AbstractConverter {
    private ExpressionConverter expressionConverter;
    private IModuleResolver moduleResolver;
    private final List<String> serviceClassToCopy = new ArrayList<String>();
    private final Path targetFolderPath;
    private final String newLine;
    private int forImpliciteIteratorIndex;
    private final Deque<ImpliciteSelfFrame> implicitSelfStack = new ArrayDeque<ImpliciteSelfFrame>();

    public ModuleConverter(IModuleResolver moduleResolver, Path targetFolderPath, String newLine) {
        this.moduleResolver = moduleResolver;
        this.targetFolderPath = targetFolderPath;
        this.expressionConverter = new ExpressionConverter(targetFolderPath);
        this.newLine = newLine;
    }

    protected void pushImplicitSelf(Object input, String selfName) {
        this.implicitSelfStack.addLast(new ImpliciteSelfFrame(input, selfName));
    }

    protected ImpliciteSelfFrame peekImplicitSelf() {
        return this.implicitSelfStack.peekLast();
    }

    protected ImpliciteSelfFrame popIndentation() {
        return this.implicitSelfStack.removeLast();
    }

    @Override
    public Object convert(EObject input) {
        Object res;
        switch (input.eClass().getClassifierID()) {
            case 0: {
                res = this.caseModule((org.eclipse.acceleo.model.mtl.Module)input);
                break;
            }
            case 5: {
                res = this.caseTemplate((org.eclipse.acceleo.model.mtl.Template)input);
                break;
            }
            case 7: {
                res = this.caseQuery((org.eclipse.acceleo.model.mtl.Query)input);
                break;
            }
            case 19: 
            case 22: 
            case 23: {
                res = this.caseDocumentation((org.eclipse.acceleo.model.mtl.Documentation)input);
                break;
            }
            case 18: {
                res = this.caseComment((org.eclipse.acceleo.model.mtl.Comment)input);
                break;
            }
            case 13: {
                res = this.caseFileBlock((FileBlock)input);
                break;
            }
            case 10: {
                res = this.caseForBlock((ForBlock)input);
                break;
            }
            case 11: {
                res = this.caseIfBlock((IfBlock)input);
                break;
            }
            case 12: {
                res = this.caseLetBlock((LetBlock)input);
                break;
            }
            case 9: {
                res = this.caseProtectedAreaBlock((ProtectedAreaBlock)input);
                break;
            }
            case 51: {
                res = this.caseVariable((org.eclipse.ocl.ecore.Variable)input);
                break;
            }
            case 46: {
                res = this.caseText((StringLiteralExp)input);
                break;
            }
            case 17: {
                res = this.caseTypedModel((TypedModel)input);
                break;
            }
            default: {
                if (input instanceof OCLExpression) {
                    res = this.expressionConverter.convertToStatement((OCLExpression)input, this.implicitSelfStack);
                    break;
                }
                throw new MigrationException(input);
            }
        }
        if (res instanceof Module) {
            TreeIterator it = ((Module)res).eAllContents();
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                if (!(current instanceof ProtectedArea)) continue;
                this.setTagPrefixes((ProtectedArea)current);
            }
        }
        return res;
    }

    private void setTagPrefixes(ProtectedArea protectedArea) {
        TextStatement lastText;
        TextStatement previousText = this.getPreviousTextStatement(protectedArea);
        if (previousText != null && !previousText.isNewLineNeeded()) {
            protectedArea.setStartTagPrefix(this.extractPrefix(previousText));
        }
        if ((lastText = this.getLastText(protectedArea)) != null && !lastText.isNewLineNeeded()) {
            protectedArea.setEndTagPrefix(this.extractPrefix(lastText));
            EcoreUtil.remove((EObject)lastText);
        }
    }

    private TextStatement getPreviousTextStatement(ProtectedArea protectedArea) {
        TextStatement res;
        EStructuralFeature containingFeature = protectedArea.eContainingFeature();
        EObject container = protectedArea.eContainer();
        if (containingFeature != null && container != null) {
            Object values = container.eGet(containingFeature);
            if (values instanceof Collection) {
                EObject previous = null;
                for (Object value : (Collection)values) {
                    if (value == protectedArea || !(value instanceof EObject)) break;
                    previous = (EObject)value;
                }
                res = previous instanceof TextStatement ? (TextStatement)previous : null;
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    private TextStatement getLastText(ProtectedArea protectedArea) {
        Statement lastStatement;
        TextStatement res = !protectedArea.getBody().getStatements().isEmpty() ? ((lastStatement = (Statement)protectedArea.getBody().getStatements().get(protectedArea.getBody().getStatements().size() - 1)) instanceof TextStatement ? (TextStatement)lastStatement : null) : null;
        return res;
    }

    private Expression extractPrefix(TextStatement textStatement) {
        Expression res;
        String text = textStatement.getValue();
        int index = Math.max(text.lastIndexOf(this.newLine), 0);
        while (index < text.length() && Character.isWhitespace(text.charAt(index))) {
            ++index;
        }
        if (index < text.length()) {
            String startPrefix = text.substring(index);
            textStatement.setValue(text.substring(0, index));
            StringLiteral stringLiteral = AstPackage.eINSTANCE.getAstFactory().createStringLiteral();
            stringLiteral.setValue(startPrefix);
            res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
            res.setAst(new AstResult((org.eclipse.acceleo.query.ast.Expression)stringLiteral, null, null, Diagnostic.OK_INSTANCE));
        } else {
            res = null;
        }
        return res;
    }

    private Object caseModule(org.eclipse.acceleo.model.mtl.Module inputModule) {
        Module outputModule = AcceleoFactory.eINSTANCE.createModule();
        outputModule.setName(this.getModuleName(inputModule.getName()));
        this.map((Collection<? extends EObject>)inputModule.getInput(), (List)outputModule.getMetamodels());
        this.map((Collection<? extends EObject>)inputModule.getOwnedModuleElement(), (List)outputModule.getModuleElements());
        if (!inputModule.getExtends().isEmpty()) {
            ModuleReference moduleReference = AcceleoFactory.eINSTANCE.createModuleReference();
            org.eclipse.acceleo.model.mtl.Module extendedModule = (org.eclipse.acceleo.model.mtl.Module)inputModule.getExtends().get(0);
            if (extendedModule.getNsURI() != null) {
                moduleReference.setQualifiedName(this.getModuleName(extendedModule.getNsURI()));
            } else {
                moduleReference.setQualifiedName(this.getModuleName(this.moduleResolver.getQualifiedName(inputModule, extendedModule)));
            }
            outputModule.setExtends(moduleReference);
        }
        for (org.eclipse.acceleo.model.mtl.Module importedModule : inputModule.getImports()) {
            Import outputImport = AcceleoFactory.eINSTANCE.createImport();
            ModuleReference moduleReference = AcceleoFactory.eINSTANCE.createModuleReference();
            if (importedModule.getNsURI() != null) {
                moduleReference.setQualifiedName(this.getModuleName(importedModule.getNsURI()));
            } else {
                moduleReference.setQualifiedName(this.getModuleName(this.moduleResolver.getQualifiedName(inputModule, importedModule)));
            }
            outputImport.setModule(moduleReference);
            outputModule.getImports().add((Object)outputImport);
        }
        this.addInvokeImports(inputModule, outputModule);
        this.addCalledMetamodelImports(inputModule, outputModule);
        for (Map.Entry<Call, String> entry : this.expressionConverter.getJavaServiceCalls().entrySet()) {
            if (!this.isAmbiguousJavaServiceCall(outputModule, entry.getKey())) continue;
            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
            File javaFile = new File(String.valueOf(this.targetFolderPath) + FileSystems.getDefault().getSeparator() + entry.getValue().replace(".", FileSystems.getDefault().getSeparator()) + ".java");
            if (!javaFile.exists()) continue;
            try {
                Document document = new Document(new String(Files.readAllBytes(javaFile.toPath())));
                parser.setSource(document.get().toCharArray());
                parser.setKind(8);
                CompilationUnit cu = (CompilationUnit)parser.createAST(null);
                cu.accept((ASTVisitor)new AmbiguousServiceMethodRefactorVisitor((IDocument)document, entry.getKey()));
                Files.write(javaFile.toPath(), document.get().getBytes(), StandardOpenOption.CREATE);
                entry.getKey().setServiceName(entry.getKey().getServiceName() + "JavaService");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputModule;
    }

    private void addCalledMetamodelImports(org.eclipse.acceleo.model.mtl.Module inputModule, Module outputModule) {
        HashSet<String> knownNsURIs = new HashSet<String>();
        for (Metamodel metamodel : outputModule.getMetamodels()) {
            knownNsURIs.add(metamodel.getReferencedPackage().getNsURI());
        }
        LinkedHashMap<String, EPackage> missingEPackages = new LinkedHashMap<String, EPackage>();
        TreeIterator it = inputModule.eAllContents();
        while (it.hasNext()) {
            EPackage ePackage;
            EClassifier eClassifier;
            TemplateInvocation invocation;
            EObject eObject = (EObject)it.next();
            if (eObject instanceof TemplateInvocation) {
                invocation = (TemplateInvocation)eObject;
                for (org.eclipse.ocl.ecore.Variable parameter : invocation.getDefinition().getParameter()) {
                    eClassifier = parameter.getEGenericType().getEClassifier();
                    if (eClassifier instanceof PredefinedType || knownNsURIs.contains((ePackage = eClassifier.getEPackage()).getNsURI())) continue;
                    knownNsURIs.add(ePackage.getNsURI());
                    missingEPackages.put(ePackage.getNsURI(), ePackage);
                }
                continue;
            }
            if (!(eObject instanceof QueryInvocation)) continue;
            invocation = (QueryInvocation)eObject;
            for (org.eclipse.ocl.ecore.Variable parameter : invocation.getDefinition().getParameter()) {
                eClassifier = parameter.getEGenericType().getEClassifier();
                if (eClassifier instanceof PredefinedType || knownNsURIs.contains((ePackage = eClassifier.getEPackage()).getNsURI())) continue;
                knownNsURIs.add(ePackage.getNsURI());
                missingEPackages.put(ePackage.getNsURI(), ePackage);
            }
        }
        for (EPackage missingEPackage : missingEPackages.values()) {
            Metamodel metamodel = AcceleoPackage.eINSTANCE.getAcceleoFactory().createMetamodel();
            metamodel.setReferencedPackage(missingEPackage);
            outputModule.getMetamodels().add((Object)metamodel);
        }
    }

    private String getModuleName(String name) {
        int start;
        StringBuilder res = new StringBuilder();
        int lastColonIndex = name.lastIndexOf("::");
        if (lastColonIndex >= 0) {
            start = lastColonIndex + 2;
            res.append(name.substring(0, start));
        } else {
            start = 0;
        }
        char charAt = name.charAt(start);
        if (Character.isJavaIdentifierStart(charAt)) {
            res.append(charAt);
        } else {
            res.append('_');
        }
        int i = start + 1;
        while (i < name.length()) {
            charAt = name.charAt(i);
            if (Character.isJavaIdentifierPart(charAt)) {
                res.append(charAt);
            } else {
                res.append('_');
            }
            ++i;
        }
        return res.toString();
    }

    private boolean isAmbiguousJavaServiceCall(Module module, Call call) {
        boolean res = false;
        for (ModuleElement element : module.getModuleElements()) {
            if (element instanceof Template) {
                res = call.getServiceName().equals(((Template)element).getName()) && this.parameterMatch((EList<org.eclipse.acceleo.query.ast.Expression>)call.getArguments(), (EList<Variable>)((Template)element).getParameters());
            } else if (element instanceof Query) {
                boolean bl = res = call.getServiceName().equals(((Query)element).getName()) && this.parameterMatch((EList<org.eclipse.acceleo.query.ast.Expression>)call.getArguments(), (EList<Variable>)((Query)element).getParameters());
            }
            if (res) break;
        }
        return res;
    }

    private boolean parameterMatch(EList<org.eclipse.acceleo.query.ast.Expression> arguments, EList<Variable> parameters) {
        boolean res = true;
        res = arguments.size() == parameters.size();
        return res;
    }

    private void addInvokeImports(org.eclipse.acceleo.model.mtl.Module inputModule, Module outputModule) {
        HashSet<String> knownImports = new HashSet<String>();
        for (Import imp : outputModule.getImports()) {
            knownImports.add(imp.getModule().getQualifiedName());
        }
        ArrayList<String> imports = new ArrayList<String>();
        TreeIterator it = inputModule.eAllContents();
        while (it.hasNext()) {
            String serviceClassName;
            String toImport;
            OperationCallExp call;
            EObject eObj = (EObject)it.next();
            if (!(eObj instanceof OperationCallExp) || !this.expressionConverter.isInvokeCall((OperationCallExp)eObj) || !((call = (OperationCallExp)eObj).getArgument().get(0) instanceof StringLiteralExp) || knownImports.contains(toImport = (serviceClassName = ((org.eclipse.ocl.expressions.StringLiteralExp)call.getArgument().get(0)).getStringSymbol()).replace(".", "::"))) continue;
            knownImports.add(toImport);
            this.serviceClassToCopy.add(serviceClassName);
            imports.add(toImport);
        }
        Collections.sort(imports);
        for (String toImport : imports) {
            Import imp = AcceleoFactory.eINSTANCE.createImport();
            ModuleReference moduleRef = AcceleoFactory.eINSTANCE.createModuleReference();
            imp.setModule(moduleRef);
            moduleRef.setQualifiedName(toImport);
            outputModule.getImports().add((Object)imp);
        }
    }

    private Object caseTemplate(org.eclipse.acceleo.model.mtl.Template inputTemplate) {
        ArrayList<Object> res = new ArrayList<Object>();
        Template outputTemplate = AcceleoFactory.eINSTANCE.createTemplate();
        if (inputTemplate.getDocumentation() != null) {
            outputTemplate.setDocumentation((Documentation)this.convert((EObject)inputTemplate.getDocumentation()));
        }
        outputTemplate.setName(inputTemplate.getName());
        outputTemplate.setMain(inputTemplate.isMain());
        outputTemplate.setVisibility(VisibilityKind.getByName((String)inputTemplate.getVisibility().getName().toLowerCase()));
        this.map((Collection<? extends EObject>)inputTemplate.getParameter(), (List)outputTemplate.getParameters());
        if (inputTemplate.getPost() != null) {
            outputTemplate.setPost(this.expressionConverter.convertToExpression(inputTemplate.getPost(), null));
        }
        if (inputTemplate.getGuard() != null) {
            outputTemplate.setGuard(this.expressionConverter.convertToExpression(inputTemplate.getGuard(), null));
        }
        if (inputTemplate.isMain()) {
            Comment mainComment = AcceleoFactory.eINSTANCE.createComment();
            CommentBody commentBody = AcceleoFactory.eINSTANCE.createCommentBody();
            commentBody.setValue("@main");
            mainComment.setBody(commentBody);
            res.add(mainComment);
        }
        res.add(outputTemplate);
        this.pushImplicitSelf(inputTemplate, ((org.eclipse.ocl.ecore.Variable)inputTemplate.getParameter().get(0)).getName());
        try {
            Block body = this.createBlock((AcceleoASTNode)outputTemplate, (List<OCLExpression>)inputTemplate.getBody());
            outputTemplate.setBody(body);
        }
        finally {
            this.popIndentation();
        }
        return res;
    }

    private Object caseQuery(org.eclipse.acceleo.model.mtl.Query inputQuery) {
        Query outputQuery = AcceleoFactory.eINSTANCE.createQuery();
        if (inputQuery.getDocumentation() != null) {
            outputQuery.setDocumentation((Documentation)this.convert((EObject)inputQuery.getDocumentation()));
        }
        outputQuery.setName(inputQuery.getName());
        outputQuery.setVisibility(VisibilityKind.getByName((String)inputQuery.getVisibility().getName().toLowerCase()));
        this.map((Collection<? extends EObject>)inputQuery.getParameter(), (List)outputQuery.getParameters());
        this.pushImplicitSelf(inputQuery, ((org.eclipse.ocl.ecore.Variable)inputQuery.getParameter().get(0)).getName());
        try {
            outputQuery.setBody(this.expressionConverter.convertToExpression(inputQuery.getExpression(), this.implicitSelfStack));
        }
        finally {
            this.popIndentation();
        }
        outputQuery.setType(ModuleConverter.createAstResult((org.eclipse.acceleo.query.ast.Expression)TypeUtils.createTypeLiteral(inputQuery.getType())));
        return outputQuery;
    }

    private Object caseFileBlock(FileBlock input) {
        FileStatement output = AcceleoFactory.eINSTANCE.createFileStatement();
        if (input.getCharset() != null) {
            output.setCharset(this.expressionConverter.convertToExpression(input.getCharset(), this.implicitSelfStack));
        }
        output.setUrl(this.expressionConverter.convertToExpression(input.getFileUrl(), this.implicitSelfStack));
        output.setMode(OpenModeKind.getByName((String)input.getOpenMode().getName().toLowerCase()));
        Block body = this.createBlock((AcceleoASTNode)output, (List<OCLExpression>)input.getBody());
        output.setBody(body);
        return Arrays.asList(output, this.newLineAfterEndBlock());
    }

    private Object caseLetBlock(LetBlock input) {
        if (!input.getElseLet().isEmpty()) {
            throw new MigrationException(input.getElseLet().get(0));
        }
        LetStatement output = AcceleoFactory.eINSTANCE.createLetStatement();
        Binding binding = AcceleoFactory.eINSTANCE.createBinding();
        output.getVariables().add((Object)binding);
        binding.setName(input.getLetVariable().getName());
        if (!TypeUtils.containsOclAny((EClassifier)input.getLetVariable().getType())) {
            binding.setType(ModuleConverter.createAstResult((org.eclipse.acceleo.query.ast.Expression)TypeUtils.createTypeLiteral((EClassifier)input.getLetVariable().getType())));
        }
        binding.setInitExpression(this.expressionConverter.convertToExpression((OCLExpression)input.getLetVariable().getInitExpression(), this.implicitSelfStack));
        Block body = this.createBlock((AcceleoASTNode)output, (List<OCLExpression>)input.getBody());
        output.setBody(body);
        return Arrays.asList(output, this.newLineAfterEndBlock());
    }

    private TextStatement newLineAfterEndBlock() {
        TextStatement res = AcceleoFactory.eINSTANCE.createTextStatement();
        res.setValue("");
        res.setNewLineNeeded(true);
        return res;
    }

    private Object caseForBlock(ForBlock input) {
        ForStatement output = AcceleoFactory.eINSTANCE.createForStatement();
        Binding binding = AcceleoFactory.eINSTANCE.createBinding();
        output.setBinding(binding);
        org.eclipse.ocl.ecore.Variable loopVariable = input.getLoopVariable();
        if (loopVariable != null) {
            binding.setName(loopVariable.getName());
            binding.setType(ModuleConverter.createAstResult((org.eclipse.acceleo.query.ast.Expression)TypeUtils.createTypeLiteral((EClassifier)loopVariable.getType())));
        } else {
            binding.setName("iterator" + this.forImpliciteIteratorIndex++);
        }
        binding.setInitExpression(this.getInitExpression(input));
        this.pushImplicitSelf(input, binding.getName());
        try {
            Block body = this.createBlock((AcceleoASTNode)output, (List<OCLExpression>)input.getBody());
            output.setBody(body);
        }
        finally {
            this.popIndentation();
        }
        OCLExpression each = input.getEach();
        if (each != null) {
            output.setSeparator(this.expressionConverter.convertToExpression(each, this.implicitSelfStack));
        }
        return Arrays.asList(output, this.newLineAfterEndBlock());
    }

    private Expression getInitExpression(ForBlock input) {
        Expression res;
        Expression initExpression = this.expressionConverter.convertToExpression(input.getIterSet(), this.implicitSelfStack);
        if (input.getGuard() != null) {
            Call selectCall = AstFactory.eINSTANCE.createCall();
            selectCall.setType(CallType.COLLECTIONCALL);
            selectCall.setServiceName("select");
            selectCall.getArguments().add((Object)initExpression.getAst().getAst());
            Lambda lambda = AstFactory.eINSTANCE.createLambda();
            VariableDeclaration varDeclaration = AstFactory.eINSTANCE.createVariableDeclaration();
            varDeclaration.setName(input.getLoopVariable().getName());
            lambda.getParameters().add((Object)varDeclaration);
            Expression guardExpression = this.expressionConverter.convertToExpression(input.getGuard(), this.implicitSelfStack);
            lambda.setExpression(guardExpression.getAst().getAst());
            selectCall.getArguments().add((Object)lambda);
            res = AcceleoFactory.eINSTANCE.createExpression();
            res.setAst(new AstResult((org.eclipse.acceleo.query.ast.Expression)selectCall, null, null, Diagnostic.OK_INSTANCE));
        } else {
            res = initExpression;
        }
        return res;
    }

    private List<Statement> caseIfBlock(IfBlock input) {
        IfStatement output = AcceleoFactory.eINSTANCE.createIfStatement();
        output.setCondition(this.expressionConverter.convertToExpression(input.getIfExpr(), this.implicitSelfStack));
        Block thenBlock = this.createBlock((AcceleoASTNode)output, (List<OCLExpression>)input.getBody());
        output.setThen(thenBlock);
        ArrayList<org.eclipse.acceleo.model.mtl.Block> inputElseBlocks = new ArrayList<org.eclipse.acceleo.model.mtl.Block>();
        inputElseBlocks.addAll((Collection<org.eclipse.acceleo.model.mtl.Block>)input.getElseIf());
        if (input.getElse() != null) {
            inputElseBlocks.add(input.getElse());
        }
        if (!inputElseBlocks.isEmpty()) {
            IfStatement current = output;
            for (org.eclipse.acceleo.model.mtl.Block inputElseBlock : inputElseBlocks) {
                Block elseBlock;
                if (inputElseBlock instanceof IfBlock) {
                    elseBlock = AcceleoFactory.eINSTANCE.createBlock();
                    current.setElse(elseBlock);
                    current = (IfStatement)this.caseIfBlock((IfBlock)inputElseBlock).get(0);
                    elseBlock.getStatements().add((Object)current);
                    continue;
                }
                elseBlock = this.createBlock((AcceleoASTNode)current, (List<OCLExpression>)inputElseBlock.getBody());
                current.setElse(elseBlock);
            }
        }
        return Arrays.asList(output, this.newLineAfterEndBlock());
    }

    private Object caseText(StringLiteralExp input) {
        int endOfText;
        ArrayList<TextStatement> outputs = new ArrayList<TextStatement>();
        String text = input.getStringSymbol().replace("[", "['['/]");
        int textLength = text.length();
        int startOfText = 0;
        do {
            String value;
            TextStatement output;
            if ((endOfText = AcceleoParser.nextNewLineIndex((String)text, (int)textLength, (int)startOfText)) < 0) {
                endOfText = text.length();
                output = AcceleoFactory.eINSTANCE.createTextStatement();
                value = StringServices.NEW_LINE_PATTERN.matcher(text.substring(startOfText, endOfText)).replaceAll(this.newLine);
                output.setValue(value);
                output.setNewLineNeeded(false);
                outputs.add(output);
            } else {
                output = AcceleoFactory.eINSTANCE.createTextStatement();
                value = StringServices.NEW_LINE_PATTERN.matcher(text.substring(startOfText, endOfText)).replaceAll(this.newLine);
                output.setValue(value);
                output.setNewLineNeeded(true);
                outputs.add(output);
            }
            startOfText = endOfText + AcceleoParser.newLineAt((String)text, (int)textLength, (int)endOfText);
        } while (endOfText < textLength && startOfText < textLength);
        return outputs;
    }

    private Object caseTypedModel(TypedModel input) {
        ArrayList<Metamodel> res = new ArrayList<Metamodel>();
        for (EPackage ePackage : input.getTakesTypesFrom()) {
            Metamodel metamodel = AcceleoFactory.eINSTANCE.createMetamodel();
            if (ePackage.eIsProxy()) {
                EPackage dummy = EcoreFactory.eINSTANCE.createEPackage();
                dummy.setNsURI(EcoreUtil.getURI((EObject)ePackage).toString().split("#")[0]);
                metamodel.setReferencedPackage(dummy);
            } else {
                metamodel.setReferencedPackage(ePackage);
            }
            res.add(metamodel);
        }
        return res;
    }

    private Object caseVariable(org.eclipse.ocl.ecore.Variable inputVariable) {
        Variable outputVariable = AcceleoFactory.eINSTANCE.createVariable();
        outputVariable.setName(inputVariable.getName());
        outputVariable.setType(ModuleConverter.createAstResult((org.eclipse.acceleo.query.ast.Expression)TypeUtils.createTypeLiteral((EClassifier)inputVariable.getType())));
        return outputVariable;
    }

    private Object caseDocumentation(org.eclipse.acceleo.model.mtl.Documentation input) {
        ModuleElementDocumentation output = AcceleoFactory.eINSTANCE.createModuleElementDocumentation();
        CommentBody body = AcceleoFactory.eINSTANCE.createCommentBody();
        StringBuilder formatValue = new StringBuilder();
        formatValue.append(this.newLine);
        String[] stringArray = StringServices.NEW_LINE_PATTERN.split(input.getBody().getValue());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                formatValue.append(" * " + line + this.newLine);
            }
            ++n2;
        }
        formatValue.append("*");
        body.setValue(formatValue.toString());
        output.setBody(body);
        return output;
    }

    private Object caseComment(org.eclipse.acceleo.model.mtl.Comment inputComment) {
        String commentValue;
        BlockComment outputComment;
        if (inputComment.getBody().getValue().contains("/]")) {
            outputComment = AcceleoFactory.eINSTANCE.createBlockComment();
            commentValue = inputComment.getBody().getValue();
        } else {
            outputComment = AcceleoFactory.eINSTANCE.createComment();
            commentValue = inputComment.getBody().getValue().substring(1);
        }
        CommentBody commentBody = AcceleoFactory.eINSTANCE.createCommentBody();
        commentBody.setValue(commentValue);
        outputComment.setBody(commentBody);
        return outputComment;
    }

    private Object caseProtectedAreaBlock(ProtectedAreaBlock input) {
        ProtectedArea output = AcceleoFactory.eINSTANCE.createProtectedArea();
        output.setId(this.expressionConverter.convertToExpression(input.getMarker(), this.implicitSelfStack));
        Block body = this.createBlock((AcceleoASTNode)output, (List<OCLExpression>)input.getBody());
        output.setBody(body);
        return Arrays.asList(output, this.newLineAfterEndBlock());
    }

    private Block createBlock(AcceleoASTNode node, List<OCLExpression> inputStatements) {
        Block res = AcceleoFactory.eINSTANCE.createBlock();
        this.map(inputStatements, (List)res.getStatements());
        if (node instanceof Template || node instanceof File) {
            res.setInlined(false);
        } else if (node instanceof ProtectedArea) {
            res.setInlined(false);
            res.getStatements().remove(0);
        } else {
            boolean inlined = true;
            for (Statement statement : res.getStatements()) {
                if (!(statement instanceof TextStatement) || !((TextStatement)statement).isNewLineNeeded()) continue;
                inlined = false;
                break;
            }
            res.setInlined(inlined);
        }
        if (res.getStatements().isEmpty()) {
            res.setInlined(false);
        }
        return res;
    }

    public List<String> getServiceClassToCopy() {
        return this.serviceClassToCopy;
    }

    public static class ImpliciteSelfFrame {
        private final Object input;
        private final String implicitSelfName;

        private ImpliciteSelfFrame(Object input, String implicitSelfName) {
            this.input = input;
            this.implicitSelfName = implicitSelfName;
        }

        public Object getInput() {
            return this.input;
        }

        public String getImplicitSelfName() {
            return this.implicitSelfName;
        }
    }
}

