/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.acceleo.query.services.tests.AbstractEngineInitializationWithCrossReferencer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XPathServicesTest
extends AbstractEngineInitializationWithCrossReferencer {
    public XPathServices xPathServices;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.xPathServices = new XPathServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment());
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsNull() {
        this.xPathServices.ancestors(null);
    }

    @Test
    public void ancestorsNoAncestors() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.ancestors((EObject)ePkg);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void ancestorsOneAncestor() {
        EPackage parentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        parentEPkg.getESubpackages().add((Object)ePkg);
        List result = this.xPathServices.ancestors((EObject)ePkg);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)parentEPkg, result.get(0));
    }

    @Test
    public void ancestorsTwoAncestor() {
        EPackage grandParentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage parentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        grandParentEPkg.getESubpackages().add((Object)parentEPkg);
        parentEPkg.getESubpackages().add((Object)ePkg);
        List result = this.xPathServices.ancestors((EObject)ePkg);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)parentEPkg, result.get(0));
        Assert.assertEquals((Object)grandParentEPkg, result.get(1));
    }

    @Test
    public void ancestorsThreeAncestor() {
        EPackage grandGrandParentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage grandParentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage parentEPkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        grandGrandParentEPkg.getESubpackages().add((Object)grandParentEPkg);
        grandParentEPkg.getESubpackages().add((Object)parentEPkg);
        parentEPkg.getESubpackages().add((Object)ePkg);
        List result = this.xPathServices.ancestors((EObject)ePkg);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)parentEPkg, result.get(0));
        Assert.assertEquals((Object)grandParentEPkg, result.get(1));
        Assert.assertEquals((Object)grandGrandParentEPkg, result.get(2));
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFilterNullNull() {
        this.xPathServices.ancestors(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFilterNullEClass() {
        this.xPathServices.ancestors(null, EcorePackage.eINSTANCE.getEPackage());
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFilterEObjectNull() {
        this.xPathServices.ancestors((EObject)EcorePackage.eINSTANCE.getEPackage(), null);
    }

    @Test
    public void ancestorsFilter() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EAttribute eAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        ePkg.getEClassifiers().add((Object)eCls);
        eCls.getEStructuralFeatures().add((Object)eAttr);
        List result = this.xPathServices.ancestors((EObject)eAttr, EcorePackage.eINSTANCE.getEClassifier());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)eCls, result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFiltersNullNull() {
        this.xPathServices.ancestors(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFiltersNullEClass() {
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        this.xPathServices.ancestors(null, filters);
    }

    @Test(expected=NullPointerException.class)
    public void ancestorsFiltersEObjectNull() {
        this.xPathServices.ancestors((EObject)EcorePackage.eINSTANCE.getEPackage(), null);
    }

    @Test
    public void ancestorsFilters() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EAttribute eAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        ePkg.getEClassifiers().add((Object)eCls);
        eCls.getEStructuralFeatures().add((Object)eAttr);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClassifier());
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.ancestors((EObject)eAttr, filters);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)eCls, result.get(0));
        Assert.assertEquals((Object)ePkg, result.get(1));
    }

    @Test(expected=NullPointerException.class)
    public void siblingsNull() {
        this.xPathServices.siblings(null);
    }

    @Test
    public void siblingsNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.siblings((EObject)ePkg);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void siblingsResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        List result = this.xPathServices.siblings((EObject)ePkgB);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
        Assert.assertEquals((Object)ePkgC, result.get(1));
    }

    @Test
    public void siblingsResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        ePkgD.getESubpackages().add((Object)ePkgC);
        List result = this.xPathServices.siblings((EObject)ePkgB);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void siblingsEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        List result = this.xPathServices.siblings((EObject)feature2);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)eOperation1, result.get(0));
        Assert.assertEquals((Object)eOperation2, result.get(1));
        Assert.assertEquals((Object)eOperation3, result.get(2));
        Assert.assertEquals((Object)feature1, result.get(3));
        Assert.assertEquals((Object)feature3, result.get(4));
    }

    @Test
    public void siblingsEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.siblings((EObject)upperBound);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFilterNullNull() {
        this.xPathServices.siblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFilterEObjectNull() {
        this.xPathServices.siblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFilterNullEClass() {
        this.xPathServices.siblings(null, EcorePackage.eINSTANCE.getEClass());
    }

    @Test
    public void siblingsFilterNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.siblings((EObject)ePkg, EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void siblingsFilterResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        List result = this.xPathServices.siblings((EObject)ePkgB, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
        Assert.assertEquals((Object)ePkgC, result.get(1));
    }

    @Test
    public void siblingsFilterResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        ePkgD.getESubpackages().add((Object)ePkgC);
        List result = this.xPathServices.siblings((EObject)ePkgB, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void siblingsFilterEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.siblings((EObject)feature2, EcorePackage.eINSTANCE.getEStructuralFeature());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)feature1, result.get(0));
        Assert.assertEquals((Object)feature3, result.get(1));
    }

    @Test
    public void siblingsFilterEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.siblings((EObject)upperBound, EcorePackage.eINSTANCE.getEGenericType());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test
    public void siblingsFilterEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.siblings((EObject)upperBound, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFiltersNullNull() {
        this.xPathServices.siblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFiltersEObjectNull() {
        this.xPathServices.siblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test
    public void siblingsFiltersEObjectContainsNull() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<Object> filters = new LinkedHashSet<Object>();
        filters.add(null);
        List result = this.xPathServices.siblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void siblingsFiltersNullEClass() {
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        this.xPathServices.siblings(null, filters);
    }

    @Test
    public void siblingsFiltersNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.xPathServices.siblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void siblingsFiltersResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.siblings((EObject)ePkgB, filters);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
        Assert.assertEquals((Object)ePkgC, result.get(1));
    }

    @Test
    public void siblingsFiltersResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        ePkgD.getESubpackages().add((Object)ePkgC);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.siblings((EObject)ePkgB, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void siblingsFiltersEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEStructuralFeature());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.siblings((EObject)feature2, filters);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)feature1, result.get(0));
        Assert.assertEquals((Object)feature3, result.get(1));
    }

    @Test
    public void siblingsFiltersEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEGenericType());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.siblings((EObject)upperBound, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test
    public void siblingsFiltersEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.siblings((EObject)upperBound, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsNull() {
        this.xPathServices.precedingSiblings(null);
    }

    @Test
    public void precedingSiblingsNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.precedingSiblings((EObject)ePkg);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void precedingSiblingsResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        List result = this.xPathServices.precedingSiblings((EObject)ePkgB);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        ePkgD.getESubpackages().add((Object)ePkgB);
        List result = this.xPathServices.precedingSiblings((EObject)ePkgC);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        List result = this.xPathServices.precedingSiblings((EObject)feature2);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)eOperation1, result.get(0));
        Assert.assertEquals((Object)eOperation2, result.get(1));
        Assert.assertEquals((Object)eOperation3, result.get(2));
        Assert.assertEquals((Object)feature1, result.get(3));
    }

    @Test
    public void precedingSiblingsEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.precedingSiblings((EObject)lowerBound);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)upperBound, result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFilterNullNull() {
        this.xPathServices.precedingSiblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFilterEObjectNull() {
        this.xPathServices.precedingSiblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFilterNullEClass() {
        this.xPathServices.precedingSiblings(null, EcorePackage.eINSTANCE.getEClass());
    }

    @Test
    public void precedingSiblingsFilterNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.precedingSiblings((EObject)ePkg, EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void precedingSiblingsFilterResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)eCls);
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        List result = this.xPathServices.precedingSiblings((EObject)ePkgB, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsFilterResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)eCls);
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        ePkgD.getESubpackages().add((Object)ePkgB);
        List result = this.xPathServices.precedingSiblings((EObject)ePkgC, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsFilterEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.precedingSiblings((EObject)feature2, EcorePackage.eINSTANCE.getEOperation());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)eOperation1, result.get(0));
        Assert.assertEquals((Object)eOperation2, result.get(1));
        Assert.assertEquals((Object)eOperation3, result.get(2));
    }

    @Test
    public void precedingSiblingsFilterEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.precedingSiblings((EObject)lowerBound, EcorePackage.eINSTANCE.getEGenericType());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)upperBound, result.get(0));
    }

    @Test
    public void precedingSiblingsFilterEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.precedingSiblings((EObject)upperBound, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFiltersNullNull() {
        this.xPathServices.precedingSiblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFiltersEObjectNull() {
        this.xPathServices.precedingSiblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test
    public void precedingSiblingsFiltersEObjectContainsNull() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<Object> filters = new LinkedHashSet<Object>();
        filters.add(null);
        List result = this.xPathServices.precedingSiblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void precedingSiblingsFiltersNullEClass() {
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        this.xPathServices.precedingSiblings(null, filters);
    }

    @Test
    public void precedingSiblingsFiltersNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.xPathServices.precedingSiblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void precedingSiblingsFiltersResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)eCls);
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.precedingSiblings((EObject)ePkgB, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsFiltersResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)eCls);
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        ePkgD.getESubpackages().add((Object)ePkgB);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.precedingSiblings((EObject)ePkgC, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgA, result.get(0));
    }

    @Test
    public void precedingSiblingsFiltersEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEOperation());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.precedingSiblings((EObject)feature2, filters);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)eOperation1, result.get(0));
        Assert.assertEquals((Object)eOperation2, result.get(1));
        Assert.assertEquals((Object)eOperation3, result.get(2));
    }

    @Test
    public void precedingSiblingsFiltersEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEGenericType());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.precedingSiblings((EObject)lowerBound, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)upperBound, result.get(0));
    }

    @Test
    public void precedingSiblingsFiltersEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.precedingSiblings((EObject)upperBound, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsNull() {
        this.xPathServices.followingSiblings(null);
    }

    @Test
    public void followingSiblingsNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.followingSiblings((EObject)ePkg);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void followingSiblingsResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        List result = this.xPathServices.followingSiblings((EObject)ePkgB);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgC, result.get(0));
    }

    @Test
    public void followingSiblingsResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        ePkgD.getESubpackages().add((Object)ePkgC);
        List result = this.xPathServices.followingSiblings((EObject)ePkgA);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgB, result.get(0));
    }

    @Test
    public void followingSiblingsEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        List result = this.xPathServices.followingSiblings((EObject)eOperation2);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)eOperation3, result.get(0));
        Assert.assertEquals((Object)feature1, result.get(1));
        Assert.assertEquals((Object)feature2, result.get(2));
        Assert.assertEquals((Object)feature3, result.get(3));
    }

    @Test
    public void followingSiblingsEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.followingSiblings((EObject)upperBound);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFilterNullNull() {
        this.xPathServices.followingSiblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFilterEObjectNull() {
        this.xPathServices.followingSiblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFilterNullEClass() {
        this.xPathServices.followingSiblings(null, EcorePackage.eINSTANCE.getEClass());
    }

    @Test
    public void followingSiblingsFilterNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        List result = this.xPathServices.followingSiblings((EObject)ePkg, EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void followingSiblingsFilterResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        List result = this.xPathServices.followingSiblings((EObject)ePkgB, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgC, result.get(0));
    }

    @Test
    public void followingSiblingsFilterResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgE = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)ePkgE);
        resource.getContents().add((Object)eCls);
        ePkgD.getESubpackages().add((Object)ePkgC);
        List result = this.xPathServices.followingSiblings((EObject)ePkgB, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgE, result.get(0));
    }

    @Test
    public void followingSiblingsFilterEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.followingSiblings((EObject)eOperation2, EcorePackage.eINSTANCE.getEStructuralFeature());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)feature1, result.get(0));
        Assert.assertEquals((Object)feature2, result.get(1));
        Assert.assertEquals((Object)feature3, result.get(2));
    }

    @Test
    public void followingSiblingsFilterEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.followingSiblings((EObject)upperBound, EcorePackage.eINSTANCE.getEGenericType());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test
    public void followingSiblingsFilterEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        List result = this.xPathServices.followingSiblings((EObject)upperBound, EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFiltersNullNull() {
        this.xPathServices.followingSiblings(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFiltersEObjectNull() {
        this.xPathServices.followingSiblings((EObject)EcorePackage.eINSTANCE.getEClass(), null);
    }

    @Test
    public void followingSiblingsFiltersEObjectContainsNull() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<Object> filters = new LinkedHashSet<Object>();
        filters.add(null);
        List result = this.xPathServices.followingSiblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void followingSiblingsFiltersNullEClass() {
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        this.xPathServices.followingSiblings(null, filters);
    }

    @Test
    public void followingSiblingsFiltersNoContainer() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.xPathServices.followingSiblings((EObject)ePkg, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void followingSiblingsFiltersResourceContainer() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)eCls);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.followingSiblings((EObject)ePkgB, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgC, result.get(0));
    }

    @Test
    public void followingSiblingsFiltersResourceContainerFragment() {
        EPackage ePkgA = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgB = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgC = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgD = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EPackage ePkgE = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        ResourceImpl resource = new ResourceImpl();
        resource.getContents().add((Object)ePkgA);
        resource.getContents().add((Object)ePkgB);
        resource.getContents().add((Object)ePkgC);
        resource.getContents().add((Object)ePkgE);
        resource.getContents().add((Object)eCls);
        ePkgD.getESubpackages().add((Object)ePkgC);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.followingSiblings((EObject)ePkgB, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ePkgE, result.get(0));
    }

    @Test
    public void followingSiblingsFiltersEObjectContainerMultiValuedEReference() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EOperation eOperation1 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation2 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EOperation eOperation3 = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        EAttribute feature1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        EAttribute feature3 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eCls.getEOperations().add((Object)eOperation1);
        eCls.getEOperations().add((Object)eOperation2);
        eCls.getEOperations().add((Object)eOperation3);
        eCls.getEStructuralFeatures().add((Object)feature1);
        eCls.getEStructuralFeatures().add((Object)feature2);
        eCls.getEStructuralFeatures().add((Object)feature3);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEStructuralFeature());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.followingSiblings((EObject)eOperation2, filters);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)feature1, result.get(0));
        Assert.assertEquals((Object)feature2, result.get(1));
        Assert.assertEquals((Object)feature3, result.get(2));
    }

    @Test
    public void followingSiblingsFiltersEObjectContainerMonoValuedEReference() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEGenericType());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        List result = this.xPathServices.followingSiblings((EObject)upperBound, filters);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)lowerBound, result.get(0));
    }

    @Test
    public void followingSiblingsFiltersEObjectContainerMonoValuedEReferenceEmptyResult() {
        EGenericType eGenType = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType lowerBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        EGenericType upperBound = EcorePackage.eINSTANCE.getEcoreFactory().createEGenericType();
        eGenType.setELowerBound(lowerBound);
        eGenType.setEUpperBound(upperBound);
        LinkedHashSet<EClass> filters = new LinkedHashSet<EClass>();
        filters.add(EcorePackage.eINSTANCE.getEPackage());
        List result = this.xPathServices.followingSiblings((EObject)upperBound, filters);
        Assert.assertEquals((long)0L, (long)result.size());
    }
}

