/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.junit.Test;

public class BooleanServicesTest
extends AbstractServicesTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), BooleanServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test(expected=NullPointerException.class)
    public void testOrNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("or", Boolean.TRUE, new Boolean[2]);
    }

    @Test(expected=NullPointerException.class)
    public void testOrFalseNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.FALSE;
        this.runTest("or", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testOrTrueNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.TRUE;
        this.runTest("or", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testOrNullFalse() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.FALSE;
        this.runTest("or", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testOrNullTrue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.TRUE;
        this.runTest("or", Boolean.TRUE, objectArray);
    }

    @Test
    public void testOr() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("or", Boolean.TRUE, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.runTest("or", Boolean.TRUE, new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        this.runTest("or", Boolean.TRUE, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        this.runTest("or", Boolean.FALSE, new Boolean[]{Boolean.FALSE, Boolean.FALSE});
    }

    @Test(expected=NullPointerException.class)
    public void testAndNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("and", Boolean.TRUE, new Boolean[2]);
    }

    @Test(expected=NullPointerException.class)
    public void testAndFalseNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.FALSE;
        this.runTest("and", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testAndTrueNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.TRUE;
        this.runTest("and", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testAndNullFalse() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.FALSE;
        this.runTest("and", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testAndNullTrue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.TRUE;
        this.runTest("and", Boolean.TRUE, objectArray);
    }

    @Test
    public void testAnd() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("and", Boolean.FALSE, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.runTest("and", Boolean.FALSE, new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        this.runTest("and", Boolean.TRUE, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        this.runTest("and", Boolean.FALSE, new Boolean[]{Boolean.FALSE, Boolean.FALSE});
    }

    @Test(expected=NullPointerException.class)
    public void testNotNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("not", Boolean.FALSE, new Boolean[1]);
    }

    @Test
    public void testNot() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("not", Boolean.FALSE, new Boolean[]{Boolean.TRUE});
        this.runTest("not", Boolean.TRUE, new Boolean[]{Boolean.FALSE});
    }

    @Test(expected=NullPointerException.class)
    public void testImpliesNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("implies", Boolean.TRUE, new Boolean[2]);
    }

    @Test(expected=NullPointerException.class)
    public void testImpliesFalseNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.FALSE;
        this.runTest("implies", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testImpliesTrueNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.TRUE;
        this.runTest("implies", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testImpliesNullFalse() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.FALSE;
        this.runTest("implies", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testImpliesNullTrue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.TRUE;
        this.runTest("implies", Boolean.TRUE, objectArray);
    }

    @Test
    public void testImplies() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("implies", Boolean.FALSE, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.runTest("implies", Boolean.TRUE, new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        this.runTest("implies", Boolean.TRUE, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        this.runTest("implies", Boolean.TRUE, new Boolean[]{Boolean.FALSE, Boolean.FALSE});
    }

    @Test(expected=NullPointerException.class)
    public void testXorNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("xor", Boolean.TRUE, new Boolean[2]);
    }

    @Test(expected=NullPointerException.class)
    public void testXorFalseNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.FALSE;
        this.runTest("xor", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testXorTrueNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[0] = Boolean.TRUE;
        this.runTest("xor", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testXorNullFalse() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.FALSE;
        this.runTest("xor", Boolean.TRUE, objectArray);
    }

    @Test(expected=NullPointerException.class)
    public void testXorNullTrue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Boolean[2];
        objectArray[1] = Boolean.TRUE;
        this.runTest("xor", Boolean.TRUE, objectArray);
    }

    @Test
    public void testXor() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.runTest("xor", Boolean.TRUE, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.runTest("xor", Boolean.TRUE, new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        this.runTest("xor", Boolean.FALSE, new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        this.runTest("xor", Boolean.FALSE, new Boolean[]{Boolean.FALSE, Boolean.FALSE});
    }
}

