/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class AnyServicesValidationTest
extends AbstractServicesValidationTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (Object)new AnyServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment()));
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test
    public void testEqualsPrimitive() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.TYPE), this.classType(Boolean.TYPE)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "equals", parameterTypes);
    }

    @Test
    public void testEquals() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.class), this.classType(Boolean.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "equals", parameterTypes);
    }

    @Test
    public void testDiffersPrimitive() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.TYPE), this.classType(Boolean.TYPE)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "differs", parameterTypes);
    }

    @Test
    public void testDiffers() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.class), this.classType(Boolean.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "differs", parameterTypes);
    }

    @Test
    public void testAddAnyObjectStringPrimitive() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.TYPE), this.classType(String.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddAnyObjectString() {
        IType[] parameterTypes = new IType[]{this.classType(Object.class), this.classType(String.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddAnyStringObjectPrimitive() {
        IType[] parameterTypes = new IType[]{this.classType(String.class), this.classType(Boolean.TYPE)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddAnyStringObject() {
        IType[] parameterTypes = new IType[]{this.classType(String.class), this.classType(Object.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testOCLIsKindOfClass() {
        IType[] parameterTypes = new IType[]{this.classType(Object.class), this.classType(Class.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "oclIsKindOf", parameterTypes);
    }

    @Test
    public void testOCLIsKindOfEClass() {
        IType[] parameterTypes = new IType[]{this.classType(Object.class), this.classType(EClass.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "oclIsKindOf", parameterTypes);
    }

    @Test
    public void testOCLIsKindOfEDataType() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.class), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean())};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "oclIsKindOf", parameterTypes);
    }

    @Test
    public void testOCLIsTypeOfClass() {
        IType[] parameterTypes = new IType[]{this.classType(Object.class), this.classType(Class.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "oclIsTypeOf", parameterTypes);
    }

    @Test
    public void testOCLIsTypeOfEClass() {
        IType[] parameterTypes = new IType[]{this.classType(Object.class), this.classType(EClass.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "oclIsTypeOf", parameterTypes);
    }

    @Test
    public void testOCLAsTypeClass() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), Integer.class});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.classType(Integer.class));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        Assert.assertEquals((Object)this.classType(Integer.class), it.next());
        LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        Assert.assertEquals((Object)this.classType(Integer.class), it.next());
    }

    @Test
    public void testOCLAsTypeEClassClass() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), EcorePackage.eINSTANCE.getEClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.classType(EClass.class));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        Assert.assertEquals((Object)this.classType(EClass.class), it.next());
        LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        Assert.assertEquals((Object)this.classType(EClass.class), it.next());
    }

    @Test
    public void testOCLAsTypeEClassEClassifier() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), EcorePackage.eINSTANCE.getEClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        Assert.assertEquals((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()), it.next());
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        Assert.assertEquals((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()), it.next());
    }

    @Test
    public void testOCLAsTypeEClassEClassifierUnregistered() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), EcorePackage.eINSTANCE.getEClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String message = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)message.contains("EClass"));
        Assert.assertTrue((boolean)message.endsWith("is not registered within the current environment."));
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String allTypesMesg = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)allTypesMesg.startsWith("Nothing will be left after calling oclAsType:"));
        Assert.assertTrue((boolean)allTypesMesg.contains("EClass"));
        Assert.assertTrue((boolean)allTypesMesg.endsWith("is not registered within the current environment."));
    }

    @Test
    public void testOCLAsTypeObjectToEInt() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), EcorePackage.eINSTANCE.getEInt()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        Assert.assertEquals((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()), it.next());
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        Assert.assertEquals((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()), it.next());
    }

    @Test
    public void testOCLAsTypeObjectToEIntUnregistered() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{new Object(), EcorePackage.eINSTANCE.getEInt()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.classType(Object.class));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String message = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)message.contains("EInt"));
        Assert.assertTrue((boolean)message.endsWith("is not registered within the current environment."));
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String allTypesMesg = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)allTypesMesg.startsWith("Nothing will be left after calling oclAsType:"));
        Assert.assertTrue((boolean)allTypesMesg.contains("EInt"));
        Assert.assertTrue((boolean)allTypesMesg.endsWith("is not registered within the current environment."));
    }

    @Test
    public void oclAsTypeCommonSubTypes() {
        EPackage ePackage = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePackage.setName("test");
        ePackage.setNsURI("test");
        ePackage.setNsPrefix("test");
        EClass a = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        a.setName("A");
        EClass x = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        x.setName("X");
        EClass b = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        b.setName("B");
        b.getESuperTypes().add((Object)a);
        b.getESuperTypes().add((Object)x);
        ePackage.getEClassifiers().add((Object)a);
        ePackage.getEClassifiers().add((Object)x);
        ePackage.getEClassifiers().add((Object)b);
        this.getQueryEnvironment().registerEPackage(ePackage);
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{EcoreUtil.create((EClass)a), x});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)a));
        argTypes.add(this.eClassifierType((EClassifier)x));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)2L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        Assert.assertEquals((Object)"EClassifier=A is not compatible with type EClassifier=X", (Object)((NothingType)next).getMessage());
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof EClassifierType));
        Assert.assertEquals((Object)b, (Object)((EClassifierType)next).getType());
    }

    @Test
    public void testOCLAsTypeEIntToObject() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{EcorePackage.eINSTANCE.getEInt(), new Object()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()));
        argTypes.add(this.classType(Object.class));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        Assert.assertEquals((Object)this.classType(Object.class), it.next());
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        Assert.assertEquals((Object)this.classType(Object.class), it.next());
    }

    @Test
    public void testOCLAsTypeEIntToObjectUnregistered() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{EcorePackage.eINSTANCE.getEInt(), new Object()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()));
        argTypes.add(this.classType(Object.class));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String message = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)message.contains("EInt"));
        Assert.assertTrue((boolean)message.endsWith("is not registered within the current environment."));
        LinkedHashMap<ArrayList<Object>, Set> allTypes = new LinkedHashMap<ArrayList<Object>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String allTypesMesg = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)allTypesMesg.startsWith("Nothing will be left after calling oclAsType:"));
        Assert.assertTrue((boolean)allTypesMesg.contains("EInt"));
        Assert.assertTrue((boolean)allTypesMesg.endsWith("is not registered within the current environment."));
    }

    @Test
    public void testOCLAsTypeIncompatibleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String message = ((NothingType)next).getMessage();
        Assert.assertEquals((Object)(String.valueOf(argTypes.get(0)) + " is not compatible with type " + String.valueOf(argTypes.get(1))), (Object)message);
        LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String allTypesMesg = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)allTypesMesg.startsWith("Nothing will be left after calling oclAsType:"));
        Assert.assertTrue((boolean)allTypesMesg.endsWith(String.valueOf(argTypes.get(0)) + " is not compatible with type " + String.valueOf(argTypes.get(1))));
    }

    @Test
    public void testOCLAsTypeIncompatibleTypesUnregistered() {
        IService<?> service = this.serviceLookUp("oclAsType", new Object[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()));
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String message = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)message.contains("EClass"));
        Assert.assertTrue((boolean)message.endsWith("is not registered within the current environment."));
        LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
        allTypes.put(argTypes, types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)1L, (long)types.size());
        it = types.iterator();
        next = (IType)it.next();
        Assert.assertTrue((boolean)(next instanceof NothingType));
        String allTypesMesg = ((NothingType)next).getMessage();
        Assert.assertTrue((boolean)allTypesMesg.startsWith("Nothing will be left after calling oclAsType:"));
        Assert.assertTrue((boolean)allTypesMesg.contains("EClass"));
        Assert.assertTrue((boolean)allTypesMesg.endsWith("is not registered within the current environment."));
    }

    @Test
    public void testToStringPrimitive() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.TYPE)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "toString", parameterTypes);
    }

    @Test
    public void testToString() {
        IType[] parameterTypes = new IType[]{this.classType(Boolean.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "toString", parameterTypes);
    }
}

