/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.junit.Assert;
import org.junit.Test;

public class LexerTest {
    private TokenStream getLexer(String expression) {
        UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
        QueryLexer lexer = new QueryLexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
        return tokens;
    }

    private void checkToken(String input, int type) {
        Assert.assertEquals((Object)input, (Object)this.getLexer(input).get(0).getText());
        Assert.assertEquals((long)type, (long)this.getLexer(input).get(0).getType());
    }

    private void checkIncorectToken(String input) {
        this.getLexer(input).get(0);
    }

    @Test
    public void testCorrectIdent() {
        this.checkToken("name", 50);
        this.checkToken("ruleName", 50);
        this.checkToken("rule0", 50);
        this.checkToken("_rule", 50);
        this.checkToken("any_rule", 50);
    }

    @Test
    public void testIncorrectIdent() {
        this.checkIncorectToken("rule);name");
    }

    @Test
    public void testInteger() {
        this.checkToken("1", 46);
        this.checkToken("10", 46);
        this.checkToken("123", 46);
        this.checkToken("9999", 46);
        this.checkToken("0", 46);
    }

    @Test
    public void testReal() {
        this.checkToken("0.0", 47);
        this.checkToken("0.1", 47);
        this.checkToken("10.0", 47);
        this.checkToken("12.123", 47);
        this.checkToken("0.9999", 47);
    }

    @Test
    public void testIncorrectReal() {
        this.checkIncorectToken(".1");
        this.checkIncorectToken("1.");
    }
}

