/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ast.test;

import java.util.List;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.junit.Assert;
import org.junit.Test;

public class AstBuilderTest {
    @Test
    public void testIntegerLiteral() {
        IntegerLiteral literal = new AstBuilder().integerLiteral(2);
        Assert.assertEquals((long)2L, (long)literal.getValue());
    }

    @Test
    public void testRealLiteral() {
        RealLiteral literal = new AstBuilder().realLiteral(1.0);
        Assert.assertTrue((1.0 == literal.getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testStringLiteral() {
        StringLiteral literal = new AstBuilder().stringLiteral("str");
        Assert.assertEquals((Object)"str", (Object)literal.getValue());
    }

    @Test
    public void testStringLiteralEscaped() {
        StringLiteral literal = new AstBuilder().stringLiteral("\\n");
        Assert.assertEquals((Object)"\n", (Object)literal.getValue());
    }

    @Test
    public void testBooleanLiteralBoolean() {
        BooleanLiteral literal = new AstBuilder().booleanLiteral(true);
        Assert.assertTrue((boolean)literal.isValue());
    }

    @Test
    public void testCollectionTypeLiteral() {
        AstBuilder builder = new AstBuilder();
        CollectionTypeLiteral literal = builder.collectionTypeLiteral(List.class, (TypeLiteral)builder.typeLiteral(Integer.class));
        Assert.assertEquals(Integer.class, (Object)((ClassTypeLiteral)literal.getElementType()).getValue());
        Assert.assertEquals(List.class, (Object)literal.getValue());
    }

    @Test
    public void testTypeLiteral() {
        Assert.assertEquals(Integer.class, (Object)new AstBuilder().typeLiteral(Integer.class).getValue());
    }

    @Test
    public void testCallService() {
        Call call = new AstBuilder().callService("myService", new Expression[]{new AstBuilder().integerLiteral(0)});
        call.setType(CallType.CALLORAPPLY);
        Assert.assertEquals((Object)"myService", (Object)call.getServiceName());
        Assert.assertEquals((long)0L, (long)((IntegerLiteral)call.getArguments().get(0)).getValue());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)call.getType());
    }

    @Test
    public void testVarRef() {
        Assert.assertEquals((Object)"var", (Object)new AstBuilder().varRef("var").getVariableName());
    }

    @Test
    public void testFeatureAccess() {
        AstBuilder builder = new AstBuilder();
        Call access = builder.callService("aqlFeatureAccess", new Expression[]{builder.varRef("var"), builder.stringLiteral("feature")});
        Assert.assertEquals((Object)"var", (Object)((VarRef)access.getArguments().get(0)).getVariableName());
        Assert.assertEquals((Object)"feature", (Object)((StringLiteral)access.getArguments().get(1)).getValue());
    }

    @Test
    public void testNullLiteral() {
        NullLiteral nullLiteral = new AstBuilder().nullLiteral();
        Assert.assertTrue((nullLiteral != null ? 1 : 0) != 0);
    }
}

