/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.acceleo.ui.interpreter.completeocl.IEvaluationExporter;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLEvaluator;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class AbstractExportCompleteOCLEvaluationResultAction
extends Action {
    private static final String TOOLTIP_TEXT = "Evaluate the current compilation result against the currently selected resource";
    private final XtextResource resource;
    private final Resource target;
    protected final IEvaluationExporter exporter;
    private final OCL ocl;

    public AbstractExportCompleteOCLEvaluationResultAction(String text, XtextResource resource, Resource target, OCL ocl, IEvaluationExporter exporter) {
        super(text, 1);
        this.setToolTipText(TOOLTIP_TEXT);
        this.resource = resource;
        this.target = target;
        this.ocl = ocl;
        this.exporter = exporter;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        final String savePath = fileDialog.open();
        if (savePath != null) {
            Element pivotElement;
            IParseResult parseResult = this.resource.getParseResult();
            final EvaluationResult evalutionResult = parseResult != null && parseResult.getRootASTElement() instanceof Pivotable ? ((pivotElement = ((Pivotable)parseResult.getRootASTElement()).getPivot()) instanceof Model ? new CompleteOCLEvaluator(this.ocl.getEnvironmentFactory()).evaluateCompleteOCLElement(pivotElement, (Notifier)this.target) : null) : null;
            if (evalutionResult != null && (evalutionResult.getStatus() == null || evalutionResult.getStatus().isOK()) && evalutionResult.getEvaluationResult() instanceof OCLElement) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            AbstractExportCompleteOCLEvaluationResultAction.this.exporter.export(savePath, (OCLElement)evalutionResult.getEvaluationResult(), monitor);
                        }
                        catch (CoreException e) {
                            AbstractExportCompleteOCLEvaluationResultAction.handleError(e.getCause(), true);
                        }
                        catch (IOException e) {
                            AbstractExportCompleteOCLEvaluationResultAction.handleError(e.getCause(), true);
                        }
                    }
                };
                try {
                    op.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    AbstractExportCompleteOCLEvaluationResultAction.handleError(e, false);
                }
                catch (InterruptedException e) {
                    AbstractExportCompleteOCLEvaluationResultAction.handleError(e, false);
                }
            }
        }
    }

    static void handleError(Throwable t, boolean popup) {
        final String message = "Internal error:" + t.getMessage();
        Status status = t instanceof CoreException ? new Status(((CoreException)t).getStatus().getSeverity(), "org.eclipse.acceleo.ui.interpreter", message, t) : new Status(4, "org.eclipse.acceleo.ui.interpreter", message, t);
        InterpreterPlugin.getDefault().getLog().log((IStatus)status);
        if (popup) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable((IStatus)status){
                private final /* synthetic */ IStatus val$status;
                {
                    this.val$status = iStatus;
                }

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Creation problems", (String)message, (IStatus)this.val$status);
                }
            });
        }
    }

    public boolean isEnabled() {
        return this.resource != null && !this.resource.getParseResult().hasSyntaxErrors() && this.target != null;
    }
}

