/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EOperationCompletionProposal
implements ICompletionProposal {
    private final EOperation eOperation;

    public EOperationCompletionProposal(EOperation eOperation) {
        this.eOperation = eOperation;
    }

    @Override
    public String getProposal() {
        return String.valueOf(this.eOperation.getName()) + "()";
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length() - 1;
    }

    public EOperation getObject() {
        return this.eOperation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.eOperation.getName());
        buffer.append('(');
        EList eParameters = this.eOperation.getEParameters();
        int i = 0;
        while (i < eParameters.size()) {
            EParameter eParameter = (EParameter)eParameters.get(i);
            buffer.append(eParameter.getName());
            buffer.append(": ");
            EClassifier eType = eParameter.getEType();
            if (eType != null) {
                buffer.append(eType.getEPackage().getName());
                buffer.append("::");
                buffer.append(eType.getName());
            }
            if (i + 1 < eParameters.size()) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("): ");
        EClassifier eType = this.eOperation.getEType();
        if (eType != null) {
            buffer.append(eType.getEPackage().getName());
            buffer.append("::");
            buffer.append(eType.getName());
        }
        return buffer.toString();
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append(this.eOperation.eClass().getName());
        result.append(" named ");
        result.append(this.eOperation.getName());
        result.append(" in ");
        result.append(this.eOperation.getEContainingClass().getName());
        result.append('(');
        result.append(this.eOperation.getEContainingClass().getEPackage().getNsURI());
        result.append(')');
        String doc = EcoreUtil.getDocumentation((EModelElement)this.eOperation);
        if (doc != null) {
            result.append('\n');
            result.append(doc);
        }
        return result.toString();
    }
}

